/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import java.io.Serializable;
import org.w3c.dom.Element;

@PublicApi
public class NumberRange
implements Serializable {
    private Double XE;
    private Double XF;
    private boolean vw;

    public NumberRange() {
        this.vw = true;
    }

    public NumberRange(double lower, double upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.vw = false;
        this.XE = new Double(lower);
        this.XF = new Double(upper);
    }

    public boolean isAutoRange() {
        return this.vw;
    }

    public void setAutoRange(boolean autoRange) {
        this.vw = autoRange;
    }

    public Double getLowerBound() {
        if (this.XE == null) {
            return null;
        }
        return this.XE;
    }

    public void setLowerBound(Double lower) {
        if (this.XF != null && lower > this.XF) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.XE = lower;
    }

    public Double getUpperBound() {
        if (this.XF == null) {
            return null;
        }
        return this.XF;
    }

    public void setUpperBound(Double upper) {
        if (this.XE != null && upper < this.XE) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.XF = upper;
    }

    boolean lT() {
        return this.getUpperBound() != null && this.getLowerBound() != null;
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeNumber");
            buffer.append(' ');
            if (this.XE != null) {
                f.b(buffer, "lowerBound", this.XE.toString());
            }
            if (this.XF != null) {
                f.b(buffer, "upperBound", this.XF.toString());
            }
            buffer.append("/");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element) {
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            this.setLowerBound(new Double(string));
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            this.setUpperBound(new Double(string));
        }
    }
}

