/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.f;
import com.inet.report.j;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class GroupAxis
extends BaseAxis {
    public static final Integer DEFAULT_MAXIMUM_LINES = 2;
    public static final Double DEFAULT_ROTATION_ANGLE = new Double(0.0);
    public static final Float DEFAULT_WIDTH_RATIO = new Float(0.0f);
    private boolean Xq = true;
    private Double Xr;
    private Float Xs = DEFAULT_WIDTH_RATIO;
    private Integer Xt = DEFAULT_MAXIMUM_LINES;
    private int Xu;
    private FormulaField Xv;

    public GroupAxis() {
        this.Xr = DEFAULT_ROTATION_ANGLE;
        this.setGridlinesVisible(false);
        this.Xu = 1;
    }

    public boolean isAutoFitTickLabel() {
        return this.Xq;
    }

    public void setAutoFitTickLabel(boolean autoFitTickLabel) {
        this.Xq = autoFitTickLabel;
    }

    public Double getTickLabelRotationAngle() {
        return this.Xr;
    }

    public void setTickLabelRotationAngle(Double tickLabelRotationAngle) {
        this.Xr = tickLabelRotationAngle;
    }

    public Float getTickLabelWidthRatio() {
        return this.Xs;
    }

    public void setTickLabelWidthRatio(Float tickLabelWidthRatio) {
        this.Xs = tickLabelWidthRatio;
    }

    public Integer getTickLabelMaximumLines() {
        return this.Xt;
    }

    public void setTickLabelMaximumLines(Integer tickLabelMaximumLines) {
        this.Xt = tickLabelMaximumLines;
    }

    public int getShowEachNthTickLabel() {
        return this.Xu;
    }

    public void setShowEachNthTickLabel(int showEachNthTickLabel) {
        if (showEachNthTickLabel < 1) {
            throw new IllegalArgumentException("Parameter 'showEachNthTickLabel' should be greater zero");
        }
        this.Xu = showEachNthTickLabel;
    }

    public FormulaField getShowEachNthTickLabelFormula() {
        return this.Xv;
    }

    public void setShowEachNthTickLabelFormula(FormulaField showEachNthTickLabelFormula) {
        if (this.Xv != null) {
            this.Xv.resetReferences();
        }
        this.Xv = showEachNthTickLabelFormula;
    }

    @Override
    protected StringBuilder cl(int n2) {
        StringBuilder stringBuilder = super.cl(n2);
        if (!this.isAutoFitTickLabel()) {
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<");
            stringBuilder.append("TickLabelAdjusting");
            stringBuilder.append(' ');
            f.b(stringBuilder, "angle", String.valueOf(this.getTickLabelRotationAngle()));
            f.b(stringBuilder, "width", String.valueOf(this.getTickLabelWidthRatio()));
            f.b(stringBuilder, "lines", String.valueOf(this.getTickLabelMaximumLines()));
            stringBuilder.append("/");
            stringBuilder.append(">\n");
        }
        if (this.getShowEachNthTickLabel() > 1) {
            f.b(stringBuilder, n2, "ShowNthLabels", String.valueOf(this.getShowEachNthTickLabel()));
        }
        if (this.Xv != null) {
            j.a(stringBuilder, n2, this.Xv, "chartAxisShowNthLabel");
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        this.setAutoFitTickLabel(true);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("TickLabelAdjusting")) {
                this.setAutoFitTickLabel(false);
                string = element2.getAttribute("angle");
                if (string.length() > 0) {
                    if (string.equals("null")) {
                        this.setTickLabelRotationAngle(null);
                    } else {
                        double d2 = Double.parseDouble(string);
                        this.setTickLabelRotationAngle(new Double(d2));
                    }
                }
                if ((string = element2.getAttribute("width")).length() > 0) {
                    if (string.equals("null")) {
                        this.setTickLabelWidthRatio(null);
                    } else {
                        float f2 = Float.parseFloat(string);
                        if (f2 >= 0.0f && f2 <= 1.0f) {
                            this.setTickLabelWidthRatio(new Float(f2));
                        }
                    }
                }
                if ((string = element2.getAttribute("lines")).length() > 0) {
                    if (string.equals("null")) {
                        this.setTickLabelMaximumLines(null);
                    } else {
                        int n2 = Integer.parseInt(string);
                        this.setTickLabelMaximumLines(n2);
                    }
                }
            }
            if (!element2.getNodeName().equals("ShowNthLabels") || (string = element2.getAttribute("value")).length() <= 0) continue;
            int n3 = Integer.parseInt(string);
            this.setShowEachNthTickLabel(n3);
        }
        FormulaField formulaField = j.a(nodeList, chart, "chartAxisShowNthLabel");
        if (formulaField != null) {
            this.setShowEachNthTickLabelFormula(formulaField);
            chart.updateReferences();
        }
    }

    @Override
    public List<Object> getReferencedObjects() {
        List<Object> list = super.getReferencedObjects();
        if (this.Xv != null) {
            list.add(this.Xv);
        }
        return list;
    }
}

