/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.axis.NumberRange;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DiscreteNumberAxis
extends BaseAxis {
    private NumberRange Xm = new NumberRange();
    private Double D;
    private FormulaField Xn;
    private Integer Xo;
    private FormulaField Xp;

    public NumberRange getRange() {
        return this.Xm;
    }

    public void setRange(NumberRange range) {
        if (range == null) {
            throw i.d("range");
        }
        this.Xm = range;
    }

    public Double getStepWidth() {
        return this.D;
    }

    public void setStepWidth(Double stepWidth) {
        if (stepWidth != null && stepWidth < 0.0) {
            throw new IllegalArgumentException("Parameter 'stepWidth' less than 0.");
        }
        this.D = stepWidth;
    }

    public Integer getNumberOfDivisions() {
        return this.Xo;
    }

    public void setNumberOfDivisions(Integer numberOfDivisions) {
        if (numberOfDivisions != null && numberOfDivisions.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Parameter 'numberOfDivisions' less or equal 0.");
        }
        this.Xo = numberOfDivisions;
    }

    @Override
    protected StringBuilder cl(int n2) {
        StringBuilder stringBuilder = super.cl(n2);
        this.getRange().saveProperties(stringBuilder, n2);
        if (this.Xo != null) {
            f.b(stringBuilder, n2, "NumberOfDivisions", this.Xo.toString());
        }
        if (this.D != null) {
            f.b(stringBuilder, n2, "StepWidth", this.D.toString());
        }
        if (this.Xp != null) {
            j.a(stringBuilder, n2, this.Xp, "chartAxisNumberOfDivisions");
        }
        if (this.Xn != null) {
            j.a(stringBuilder, n2, this.Xn, "chartAxisStepsize");
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        Object object;
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Number number;
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            object = (Element)nodeList.item(i2);
            if (object.getNodeName().equals("RangeNumber")) {
                this.getRange().readProperties((Element)object);
                continue;
            }
            if (object.getNodeName().equals("NumberOfDivisions")) {
                string = object.getAttribute("value");
                if (string.length() <= 0 || (number = Integer.valueOf(string)) == null || !(((Integer)number).doubleValue() >= 0.0)) continue;
                this.setNumberOfDivisions((Integer)number);
                continue;
            }
            if (!object.getNodeName().equals("StepWidth") || (string = object.getAttribute("value")).length() <= 0 || (number = Double.valueOf(string)) == null || !((Double)number >= 0.0)) continue;
            this.setStepWidth((Double)number);
        }
        FormulaField formulaField = j.a(nodeList, chart, "chartAxisNumberOfDivisions");
        if (formulaField != null) {
            this.setNumberOfDivisionsFormula(formulaField);
            chart.updateReferences();
        }
        if ((object = j.a(nodeList, chart, "chartAxisStepsize")) != null) {
            this.setStepWidthFormula((FormulaField)object);
            chart.updateReferences();
        }
    }

    public FormulaField getNumberOfDivisionsFormula() {
        return this.Xp;
    }

    public void setNumberOfDivisionsFormula(FormulaField numberOfDivisionsFormula) {
        if (this.Xp != null) {
            this.Xp.resetReferences();
        }
        this.Xp = numberOfDivisionsFormula;
    }

    public FormulaField getStepWidthFormula() {
        return this.Xn;
    }

    public void setStepWidthFormula(FormulaField stepWidthFormula) {
        if (this.Xn != null) {
            this.Xn.resetReferences();
        }
        this.Xn = stepWidthFormula;
    }

    @Override
    public List<Object> getReferencedObjects() {
        List<Object> list = super.getReferencedObjects();
        if (this.Xn != null) {
            list.add(this.Xn);
        }
        if (this.Xp != null) {
            list.add(this.Xp);
        }
        return list;
    }
}

