/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.PropertyConstants;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.RendererBase;
import com.inet.report.ReportException;
import com.inet.report.SQLField;
import com.inet.report.SpecialField;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.as;
import com.inet.report.bx;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.y;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class SortField
extends Field
implements ReferenceHolder,
Validatable {
    int MT;
    private FormulaField MU;
    private Number MV;
    public static final int ASCENDING_ORDER = 0;
    public static final int DESCENDING_ORDER = 1;
    public static final int ORIGINAL_ORDER = 2;
    public static final int ASCENDING_ALPHA_NUMERIC_ORDER = 16;
    public static final int DESCENDING_ALPHA_NUMERIC_ORDER = 17;
    private r qh = new r(this);

    SortField(RendererBase<?> ren) {
        this.bB = ren;
        this.type = 15;
    }

    @Override
    public void setName(String name) throws ReportException {
        Object object;
        this.resetReferences();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a sort field cannot be empty");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        FormulaField formulaField = this.bB.getFields().getFormulaField(name);
        if (formulaField != null && (object = bx.a(formulaField, "sort")) != null) {
            BaseUtils.warning(object);
        }
        if (Fields.a((Field[])this.bB.Iy, name)) {
            throw y.b("SortField", name, null);
        }
        object = this.bB.getFieldByRefName(true, name);
        if (object == null) {
            throw new IllegalArgumentException("No field with name " + name + " exists. Add it first.");
        }
        this.setField((Field)object);
        this.name = name;
        this.setReferences();
    }

    public void setSort(int sort) {
        if (sort != 2 && sort != 0 && sort != 1 && sort != 16 && sort != 17) {
            throw y.a(sort, "sort", (ErrorCode)ReportErrorCode.wrongParamType);
        }
        this.MT = sort;
    }

    public int getSort() {
        return this.MT;
    }

    public void setSortDirectionFormula(FormulaField formula) throws ReportException {
        FormulaField.d(this.MU);
        if (formula != null && !formula.isEmpty()) {
            if (formula.getFormulaType() != 3) {
                throw new ReportException("Wrong type of formula. Only type FormulaField.FORMULA_PROPERTY is permitted.", 0);
            }
            formula.setReferences();
            if (bx.a(formula, DatabaseField.class, false) || bx.a(formula, SQLField.class, false) || bx.a(formula, SpecialField.class, false)) {
                formula.resetReferences();
                throw new ReportException("Wrong formula. Sort Direction formula must not contains DatabaseFields, SQLFields or SpecialFields.", 0);
            }
        }
        this.MU = formula != null && formula.isEmpty() ? null : formula;
        this.MV = null;
        if (this.MU != null) {
            this.MU.setReferences();
        }
    }

    int iW() {
        if (this.MV == null) {
            try {
                this.MV = (Number)this.MU.a(null, this.MV);
            }
            catch (Exception exception) {
                BaseUtils.error("Wrong Sort Formula for SortField: " + String.valueOf(this.getField()));
                this.MV = new Integer(this.MT);
            }
            if (this.MV == null) {
                BaseUtils.error("Sort Direction Formula from SortField: " + String.valueOf(this.getField()) + " returns null.");
                this.MV = new Integer(this.MT);
            }
            if (this.MV.intValue() < 0 || this.MV.intValue() > 2) {
                BaseUtils.error("Wrong value: " + this.MV.intValue() + " of Sort Direction Formula from SortField: " + String.valueOf(this.getField()) + ". Allowed values see SortField.");
                this.MV = new Integer(this.MT);
            }
        }
        return this.MV.intValue();
    }

    public FormulaField getSortDirectionFormula() {
        return PropertyConstants.setPropertyDefault(this.MU, this.getSort(), 6);
    }

    @Override
    Field[] D(int n2) {
        return new SortField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, "Operation", k.z(this.MT));
        if (this.MU != null) {
            this.MU.a(stringBuilder, n2, "SortDirectionFormula");
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    final void a(int n2, String string, as as2) {
        switch (n2) {
            case 176: {
                this.MT = Integer.parseInt(string);
                break;
            }
            default: {
                super.a(n2, string, as2);
            }
        }
    }

    @Override
    void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        super.changeAllAliases(oldAlias, newAlias, dc);
        if (this.MU != null) {
            this.MU.b(oldAlias, newAlias, dc);
        }
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qh.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qh.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qh.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qh.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qh.removeReferencedObject(reference);
    }

    @Override
    public final void setReferences() {
        try {
            Field field = this.getField();
            if (field == null) {
                field = this.bB.getFieldByRefName(false, this.name);
                this.setField(field);
            }
            if (field == null) {
                return;
            }
            field.addReferenceHolder(this);
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        if (this.MU != null) {
            this.MU.setReferences();
        }
    }

    @Override
    public final void resetReferences() {
        this.qh.resetReferences();
        if (this.MU != null) {
            this.MU.resetReferences();
        }
    }

    @Override
    public boolean isUsed() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SortField && super.equals(obj) && this.MT == ((SortField)obj).MT;
    }

    @Override
    public int getValueType() {
        if (this.getField() == null) {
            return -1;
        }
        return this.getField().getValueType();
    }

    public void updateName() {
        this.name = this.getField().getRefName();
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            switch (a.am(tag)) {
                case MX: {
                    this.setField(Fields.b(atts, this.bB));
                    break;
                }
                case MY: {
                    if (this.name == null) {
                        this.name = atts.getValue("value");
                    }
                    break;
                }
                case MZ: {
                    this.setSort(Integer.valueOf(atts.getValue("value")));
                    break;
                }
                case Nb: {
                    try {
                        FormulaField formulaField = new FormulaField(this.bB);
                        formulaField.setFormulaType(3);
                        formulaField.G("0");
                        String string = atts.getValue("propertyType");
                        if (string != null) {
                            formulaField.rM = PropertyConstants.toToken(string);
                        }
                        this.setSortDirectionFormula(formulaField);
                        formulaField.G("");
                        return formulaField;
                    }
                    catch (Exception exception) {
                        BaseUtils.error(exception);
                        return null;
                    }
                }
                default: {
                    return super.parseElement(group, tag, atts, parserMap);
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public Validity validate() {
        if (this.getField() == null) {
            return new Validity(Validity.States.ERROR, y.a("valueType", null));
        }
        if (this.getField() instanceof Validatable) {
            Validity validity = ((Validatable)((Object)this.getField())).validate();
            if (validity.hasState(Validity.States.ERROR, Validity.States.DEPENDING_ERROR)) {
                return new Validity(Validity.States.DEPENDING_ERROR, validity.getErrorData());
            }
        }
        return new Validity(Validity.States.VALID, null);
    }

    @Override
    Object getValue() throws ReportException {
        return null;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a MX = new a();
        public static final /* enum */ a MY = new a();
        public static final /* enum */ a MZ = new a();
        public static final /* enum */ a Na = new a();
        public static final /* enum */ a Nb = new a();
        private static HashMap<String, a> gC;
        private static final /* synthetic */ a[] Nc;

        public static a[] values() {
            return (a[])Nc.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static a am(String string) {
            a a2 = gC.get(string);
            if (a2 == null) {
                a2 = Na;
            }
            return a2;
        }

        private static /* synthetic */ a[] iX() {
            return new a[]{MX, MY, MZ, Na, Nb};
        }

        static {
            Nc = a.iX();
            gC = new HashMap();
            gC.put("Reference", MX);
            gC.put("Name", MY);
            gC.put("Operation", MZ);
            gC.put("PropertyFormula", Nb);
        }
    }
}

