/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.list.IntList;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.BaseUtils;
import com.inet.report.BySummaryOrder;
import com.inet.report.Database;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseSetData;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.GroupTreeNode;
import com.inet.report.Join;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.RendererBase;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportProperties;
import com.inet.report.SortField;
import com.inet.report.SpecifiedOrder;
import com.inet.report.SummaryField;
import com.inet.report.Validity;
import com.inet.report.a;
import com.inet.report.aa;
import com.inet.report.ac;
import com.inet.report.bo;
import com.inet.report.bv;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.formula.ast.y;
import com.inet.report.formula.e;
import com.inet.report.formula.j;
import com.inet.report.formula.k;
import com.inet.report.formula.q;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.rowsource.OriginalObject;
import com.inet.report.rowsource.RowSource;
import com.inet.report.rowsource.RowSourceAccessor;
import com.inet.report.rowsource.SummaryObject;
import com.inet.report.rowsource.WrappedGroupValueForString;
import com.inet.report.rowsource.b;
import com.inet.report.rowsource.cache.c;
import com.inet.report.rowsource.cache.d;
import com.inet.report.rowsource.g;
import com.inet.report.rowsource.m;
import com.inet.report.rowsource.o;
import com.inet.report.rowsource.p;
import com.inet.report.summary.Aggregator;
import com.inet.report.summary.Store;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ReportDataHandler
extends a {
    private static final ConfigValue<Integer> rt = new ConfigValue(ConfigKey.COMPATIBILITY_LEVEL);
    private static final ConfigValue<Boolean> Jj = new ConfigValue(ConfigKey.HAS_GROUP_TREE);
    private static final ConfigValue<Integer> Jk = new ConfigValue(ConfigKey.ROW_LIMIT);
    private RowSource Jl;
    private boolean Jm;
    private boolean Jn;
    private boolean Jo = true;
    private boolean Jp;
    private int Jq = 1;
    private transient FormulaField Jr;
    private transient ArrayList<GroupTreeNode> Js;
    private transient Aggregator Jt;
    private boolean Ju = false;
    private transient Map<y, Object> Jv;
    private boolean Jw;
    private transient int Jx;
    private boolean Jy = true;
    private boolean Jz = true;
    private boolean JA = true;
    private Set<Join> JB = null;
    private boolean JC;
    private List<Field> JD;
    private HashSet<c> JE;

    public ReportDataHandler(RendererBase<?> renderer) {
        super(renderer, new Group[0], new SummaryField[0]);
    }

    public void setUseLastValueCache(boolean useLastValueCache) {
        this.Jo = useLastValueCache;
    }

    @Override
    public boolean isUseLastValueCache() {
        return this.Jo;
    }

    protected void setReturnSQLvalues(boolean returnSQLvalues) {
        this.Jp = returnSQLvalues;
    }

    protected boolean getReturnSQLvalues() {
        return this.Jp;
    }

    @Override
    public GroupTreeNode addGroupTreeNodesList(int depth, StringBuilder term, boolean getDataFromTree, Object obj) {
        int n2 = depth + this.getReport().getNumberOfStaticGroups();
        if (obj instanceof WrappedGroupValueForString) {
            obj = ((WrappedGroupValueForString)obj).getGroupValue();
        }
        if (obj instanceof p) {
            obj = ((p)obj).getGroupValue();
        }
        GroupTreeNode groupTreeNode = new GroupTreeNode(this.getReport(), depth + 1, n2, term, getDataFromTree, obj);
        groupTreeNode.setRowNumber(this.getRowSource().getRowPosition());
        this.Js.add(groupTreeNode);
        return groupTreeNode;
    }

    @Override
    public void addIndentationList(int groupIndex, int indentationCount, int anfang, int ende) {
        Group group = this.getGroup(groupIndex);
        if (group.sv == null) {
            group.sv = new int[this.getRowCount()];
        }
        for (int i2 = anfang; i2 < ende; ++i2) {
            group.sv[i2] = indentationCount * group.getIndentation();
        }
    }

    @Override
    public void addToTerm(Object groupValue, int ebene, StringBuilder buf) throws ReportException {
        Group group = this.getGroup(ebene);
        int n2 = group.getSortDirection();
        if (group.getHierarchicalGrouping()) {
            groupValue = ((g)groupValue).getGroupValue();
        }
        if (n2 == 3 && groupValue instanceof o) {
            o o2 = (o)groupValue;
            if (o2.getIsOther()) {
                if (group.getSpecifiedOrder().getCount() != 0) {
                    buf.append('(');
                    group.getSpecifiedOrder().b(buf);
                    buf.append(')');
                }
            } else {
                buf.append('(');
                o2.a(buf, group.getSpecifiedOrder());
                buf.append(')');
            }
            return;
        }
        if (n2 == 4 && this.hasSummaryData() && this.hasBySummaryOrder()) {
            SummaryObject summaryObject = (SummaryObject)groupValue;
            groupValue = summaryObject.getGroupValue();
            if (summaryObject.getIsOther()) {
                buf.append('(');
                buf.append(summaryObject.getOtherFormula());
                buf.append(')');
                return;
            }
        }
        if (n2 == 2 || n2 == 5) {
            groupValue = ((OriginalObject)groupValue).getGroupValue();
        }
        if (groupValue instanceof WrappedGroupValueForString) {
            groupValue = ((WrappedGroupValueForString)groupValue).getGroupValue();
        }
        if (groupValue instanceof p) {
            groupValue = ((p)groupValue).Mh();
        }
        if (groupValue != null) {
            buf.append(group.a(true, groupValue));
        } else {
            buf.append("IsNull({");
            buf.append(group.getField().getRefName());
            buf.append("})");
        }
    }

    @Override
    public Object createGroupTreeNode(Object groupValue, int groupIndex, StringBuilder term, StringBuilder overTerm) {
        Object object;
        Object object2 = groupValue;
        if (groupValue instanceof g) {
            object = (g)groupValue;
            this.Jx = ((g)object).LY();
            groupValue = ((g)object).getGroupValue();
        }
        if (groupValue instanceof OriginalObject) {
            groupValue = ((OriginalObject)groupValue).getGroupValue();
        }
        if (groupValue instanceof SummaryObject && !((SummaryObject)(object = (SummaryObject)groupValue)).getIsOther()) {
            groupValue = ((SummaryObject)object).getGroupValue();
        }
        if (overTerm != null) {
            term.append((CharSequence)overTerm);
        }
        if (term.length() != 0) {
            term.append(" AND ");
        }
        try {
            this.addToTerm(object2, groupIndex, term);
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        object = null;
        object = groupValue instanceof o ? this.addGroupTreeNodesList(groupIndex, term, true, groupValue) : (groupValue instanceof SummaryObject && ((SummaryObject)groupValue).getIsOther() ? this.addGroupTreeNodesList(groupIndex, term, true, this.getGroupBySummaryOrder(groupIndex).getOtherName()) : (this.isCustomizeGroupNameEnabled(groupIndex) ? this.addGroupTreeNodesList(groupIndex, term, false, null) : (groupValue instanceof p ? this.addGroupTreeNodesList(groupIndex, term, false, null) : this.addGroupTreeNodesList(groupIndex, term, true, groupValue))));
        if (this.Jx != 0) {
            ((GroupTreeNode)object).aj(this.Jx);
        }
        return object;
    }

    void g(FormulaField formulaField) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Join join : this.JB) {
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder();
            }
            for (int i2 = 0; i2 < join.getConditionCount(); ++i2) {
                StringBuilder stringBuilder3 = new StringBuilder();
                stringBuilder3.append('(');
                stringBuilder3.append('{');
                stringBuilder3.append(join.getSourceAlias());
                stringBuilder3.append('.');
                stringBuilder3.append(join.getConditionSourceColumn(i2));
                stringBuilder3.append('}');
                switch (join.getConditionLinkType(i2)) {
                    case 1: {
                        stringBuilder3.append(" = ");
                        break;
                    }
                    case 6: {
                        stringBuilder3.append(" <> ");
                        break;
                    }
                    case 2: {
                        stringBuilder3.append(" > ");
                        break;
                    }
                    case 3: {
                        stringBuilder3.append(" >= ");
                        break;
                    }
                    case 4: {
                        stringBuilder3.append(" < ");
                        break;
                    }
                    case 5: {
                        stringBuilder3.append(" <= ");
                    }
                }
                stringBuilder3.append('{');
                stringBuilder3.append(join.getTargetAlias());
                stringBuilder3.append('.');
                stringBuilder3.append(join.getConditionTargetColumn(i2));
                stringBuilder3.append('}');
                stringBuilder3.append(')');
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(" AND ");
                }
                stringBuilder2.append((CharSequence)stringBuilder3);
            }
        }
        formulaField.setFormula(stringBuilder.toString());
    }

    @Override
    public boolean filterJoinCycle() {
        Set<Join> set = this.JB;
        if (set != null && set.size() != 0) {
            if (this.Jr == null) {
                this.Jr = new FormulaField(this.getReport());
                this.g(this.Jr);
            }
            return this.h(this.Jr);
        }
        return false;
    }

    @Override
    public boolean filterRecordSelection() {
        FormulaField formulaField = this.getReport().getRecordSelectionFormula();
        if (formulaField != null && (this.Jy || this.getFilterLater())) {
            return this.h(formulaField);
        }
        return false;
    }

    @Override
    public IntList getColumnsForDistinct() {
        List<Field> list = this.JD;
        if (list == null) {
            return new IntList(0);
        }
        IntList intList = new IntList(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Field field = list.get(i2);
            if (!field.isUsed() || this.a(field)) continue;
            intList.addElement(i2);
        }
        return intList;
    }

    private boolean a(ReferencedObject referencedObject) {
        if (referencedObject.getReferenceHolderCount() > 0) {
            for (ReferenceHolder referenceHolder : referencedObject.getReferenceHolders()) {
                if (!(referenceHolder instanceof FormulaField ? ((FormulaField)referenceHolder).getFormulaType() != 1 && !this.a((FormulaField)referenceHolder) : !(referenceHolder instanceof SortField))) continue;
                return false;
            }
        }
        return true;
    }

    public int getColumnIdx(Field column) throws ReportException {
        ReportException reportException = null;
        List<Field> list = this.JD;
        try {
            return ReportDataHandler.a(column, list);
        }
        catch (ReportException reportException2) {
            reportException = reportException2;
            if (list == null) {
                Object[] objectArray = new Object[]{this.toString(), reportException.getMessage()};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.NoDataOrColumnsSet, objectArray);
            }
            if (this.getEngine().og < 10) {
                BaseUtils.info("available columns:");
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (list.get(i2) == null) continue;
                    BaseUtils.info(">" + list.get(i2).getName() + "<");
                }
            }
            throw reportException;
        }
    }

    @Override
    public boolean getDistinct() {
        return this.getReport().getReportProperties().isDistinct() && this.JA;
    }

    @Override
    public boolean getFilterLater() {
        if (this.Jm && this.getReport().getEngine().isDrillDownEngine()) {
            return true;
        }
        if (this.getReport().getReportProperties().isIgnoreFiltering()) {
            return false;
        }
        return this.Jm;
    }

    @Override
    public Group getGroup(int index) {
        return this.getReport().getGroup(index);
    }

    @Override
    public int getGroupCount() {
        return this.getReport().getGroupCount();
    }

    @Override
    public Object getGroupValue(boolean throwException, int groupIndex) throws ReportException {
        int n2;
        Object object;
        Group group = this.getGroup(groupIndex);
        Object object2 = null;
        if (group.isDate()) {
            object = this.getFieldValueByField(throwException, group.getField());
            if (object != null) {
                p p2 = new p();
                e e2 = this.getReport().getFormula().pN();
                p2.setGroupValue(e2.a(group.getSectionWillBePrinted(), object)[0]);
                p2.aP(this.getFieldValueByField(throwException, group.getGroupNameField()));
                if (object instanceof Number || object instanceof String) {
                    object = e2.k(object);
                }
                p2.n((java.util.Date)object);
                object2 = p2;
            }
        } else {
            object2 = this.getFieldValueByField(throwException, group.getField());
        }
        if (object2 instanceof String && (this.isSortLocally() || this.Jn)) {
            object = new WrappedGroupValueForString();
            ((WrappedGroupValueForString)object).setGroupValue((String)object2);
            object2 = object;
        }
        if ((n2 = group.getSortDirection()) == 3) {
            return this.a(group, this);
        }
        if (n2 == 4 && this.hasSummaryData() && this.hasBySummaryOrder()) {
            return this.a(this, group, groupIndex, object2);
        }
        if (n2 == 2 || n2 == 5) {
            object2 = OriginalObject.getOriginalObject(n2, object2, this.getRowPosition());
        }
        if (n2 == 16 || n2 == 17) {
            object2 = new m.a(String.valueOf(object2));
        }
        if (group.getHierarchicalGrouping()) {
            return this.a(throwException, object2, groupIndex);
        }
        return object2;
    }

    private Object a(boolean bl2, Object object, int n2) throws ReportException {
        Group group = this.getGroup(n2);
        if (group.getParentField() == null) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.ParentFieldNotFound, objectArray);
        }
        if (!group.getField().getClass().equals(group.getParentField().getClass())) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidParentOfGroup, objectArray);
        }
        g g2 = new g();
        g2.setGroupValue(object);
        g2.aO(this.getFieldValueByField(bl2, group.getParentField()));
        return g2;
    }

    Object a(Group group, ac ac2) throws ReportException {
        int n2;
        SpecifiedOrder specifiedOrder = group.getSpecifiedOrder();
        if (specifiedOrder == null) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.SpecificSortOrderNotDefined, objectArray);
        }
        o o2 = new o();
        for (n2 = 0; n2 < specifiedOrder.getCount(); ++n2) {
            FormulaField formulaField = specifiedOrder.getFormulaField(n2);
            if (formulaField == null) continue;
            com.inet.report.q q2 = new com.inet.report.q(ac2, this.getReport(), formulaField);
            q2.a(formulaField);
            q2.pn();
            Object object = formulaField.a(group.getField(), null, q2);
            if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            o2.setName(specifiedOrder.getName(n2));
            o2.ja(n2);
            return o2;
        }
        n2 = specifiedOrder.getOtherType();
        if (n2 == 0) {
            if (specifiedOrder.getOtherName() == null) {
                BaseUtils.warning("The name for other elements is null");
            }
            o2.setName(specifiedOrder.getOtherName());
            o2.setIsOther(true);
            return o2;
        }
        if (n2 == 2) {
            return this.getFieldValueByField(false, group.getField());
        }
        return null;
    }

    Object a(RowSourceAccessor rowSourceAccessor, Group group, int n2, Object object) throws ReportException {
        BySummaryOrder bySummaryOrder = group.getBySummaryOrder();
        if (bySummaryOrder == null) {
            Object[] objectArray = new Object[]{group.toString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.BySummaryOrderIsNull, objectArray);
        }
        bySummaryOrder.a(rowSourceAccessor);
        if (bySummaryOrder.ah() == null) {
            bySummaryOrder.g(n2);
        }
        SummaryObject summaryObject = new SummaryObject();
        summaryObject.setGroupValue(object);
        Object object2 = bySummaryOrder.ah()[rowSourceAccessor.getRowPosition() - 1];
        if (object2 instanceof Integer) {
            summaryObject.setNumber((Integer)object2);
        } else {
            if (bySummaryOrder.getOther() == 1) {
                return null;
            }
            summaryObject.setIsOther(true);
            summaryObject.setOtherFormula((String)object2);
            summaryObject.setOtherName(bySummaryOrder.getOtherName());
        }
        return summaryObject;
    }

    @Override
    public int getRowLimit() {
        return (Integer)Jk.get();
    }

    @Override
    public int getSortOrder(int index) throws ReportException {
        Fields fields = this.getReport().getFields();
        SortField sortField = fields.getSortField(index);
        if (sortField.getSortDirectionFormula() != null) {
            return sortField.iW();
        }
        return sortField.getSort();
    }

    @Override
    public Object getSortValue(int sortIndex) throws ReportException {
        Fields fields = this.getReport().getFields();
        SortField sortField = fields.getSortField(sortIndex);
        Field field = sortField.getField();
        if (field == null) {
            return this.getFieldValueByName(false, sortField.getName());
        }
        return this.getFieldValueByField(false, field);
    }

    @Override
    public boolean getExecuteLocalFilter() {
        FormulaField formulaField;
        boolean bl2 = this.getReport().getReportProperties().isIgnoreFiltering();
        if (bl2 && BaseUtils.isDebug()) {
            BaseUtils.debug("Property 'ignoreFiltering' was set.");
        }
        if (!bl2 && this.Jy && (formulaField = this.getReport().getRecordSelectionFormula()) != null) {
            if (formulaField.getFormulaTree() != null) {
                return true;
            }
            Validity validity = formulaField.validate();
            if (validity.getErrorData() == null) {
                formulaField.setFormulaTree(null);
                formulaField.resetReferences();
            }
            return validity.getErrorData() != null;
        }
        return false;
    }

    @Override
    public boolean hasGroupTree() {
        if (this.hasBySummaryOrder() && !this.hasSummaryData()) {
            return false;
        }
        RendererBase rendererBase = this.getReport();
        ReportProperties reportProperties = rendererBase.getReportProperties();
        return rendererBase.isSupportsGroupTree() && (Boolean)Jj.get() != false && rendererBase.isMain() && (reportProperties.getLabelWidth() == 0 || !reportProperties.isFormatWithMultipleColumns()) && reportProperties.isGroupTreeVisible();
    }

    @Override
    public boolean hasHierarchicalGrouping(int index) {
        return this.getGroup(index).getHierarchicalGrouping();
    }

    public RowSource getOriginalRowSource() {
        return this.Jl;
    }

    public void setOriginalRowSource(RowSource rowSource) {
        this.Jl = rowSource;
    }

    public void setFilterLater(boolean filterLater) {
        this.Jm = filterLater;
    }

    public final void sortRowSource(boolean rowSourceHasData) throws ReportException {
        Group group;
        int n2;
        RowSource rowSource;
        BaseUtils.info("Sort checkpoint reached.");
        BaseUtils.debugMemory("beforeSort");
        this.Jn = false;
        if (!rowSourceHasData) {
            this.setRowSource(this.getOriginalRowSource());
        }
        if ((rowSource = this.getRowSource()) == null) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoRowSource, new Object[0]);
        }
        this.Js = new ArrayList();
        for (n2 = 0; n2 < this.getGroupCount(); ++n2) {
            group = this.getGroup(n2);
            if (group.getHierarchicalGrouping() && group.getGroupDirectionFormula() == null && (group.getSort() == 3 || group.getSort() == 4)) {
                group.ab(0);
            }
            if (group.getSortDirection() == 3) {
                this.Jn = true;
                continue;
            }
            if (group.getSortDirection() == 4) {
                this.setHasBySummaryOrder(true);
                if (!this.hasSummaryData()) continue;
                this.Jn = true;
                if (group.getBySummaryOrder() == null) continue;
                group.getBySummaryOrder().a((Object[])null);
                continue;
            }
            if (!group.getHierarchicalGrouping()) continue;
            this.Jn = true;
        }
        if (this.getReport().getReportProperties().isIgnoreSorting() && BaseUtils.isDebug()) {
            BaseUtils.debug("Property 'ignoreSorting' was set.");
        }
        if (this.shouldSortOnRowSource()) {
            BaseUtils.info("Must sort on RowSource ...");
            if (BaseUtils.isDebug()) {
                for (n2 = 0; n2 < this.getGroupCount(); ++n2) {
                    group = this.getGroup(n2);
                    BaseUtils.debug("Must sort groups: " + group.getField().paramString());
                }
                Fields fields = this.getReport().getFields();
                for (int i2 = 0; i2 < fields.getSortFieldsCount(); ++i2) {
                    SortField sortField = fields.getSortField(i2);
                    BaseUtils.debug("Must sort fields: " + sortField.paramString());
                }
            }
            rowSource.sort();
            BaseUtils.info("Sort on RowSource completed.");
        } else {
            BaseUtils.info("Sort on database succeeded.");
            rowSource.handleSortedData();
        }
        this.setRowPosition(0);
        if (this.hasBySummaryOrder()) {
            if (this.hasSummaryData()) {
                this.ij();
                this.resetSummaryValues();
                this.evaluateWhileReading(true);
            }
        } else {
            this.ij();
            this.evaluateWhileReading(true);
        }
        BaseUtils.debugMemory("afterSort");
    }

    public final void filterGroupSelection(FormulaField formulaField) throws ReportException {
        if (formulaField == null || formulaField.getFormula() == null || FormulaField.c(formulaField).length() == 0 || formulaField.isEmpty()) {
            return;
        }
        this.setCurrentGroupNumber(0);
        IntList intList = new IntList(this.getRowCount());
        this.a(this.getReport().oE.qa());
        RowSource rowSource = this.getRowSource();
        try {
            for (int i2 = 0; i2 < rowSource.getRowCount(); ++i2) {
                rowSource.setRowPosition(i2);
                if (rowSource.getGroupChangeMarksElement(i2) > 0) {
                    this.setCurrentGroupNumber(this.getCurrentGroupNumber() + 1);
                }
                if (!this.h(formulaField)) continue;
                intList.addElement(i2);
            }
            this.setRowPosition(0);
            this.setCurrentGroupNumber(0);
            if (intList.size() != 0) {
                this.Js = new ArrayList();
                rowSource.removeRows(intList.toArray());
                this.ii();
                rowSource.handleSortedData();
                this.ij();
                this.resetSummaryValues();
                this.evaluateWhileReading(false);
                this.calcSummaryFields();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw ReportExceptionFactory.createReportExceptionWithCauseOutOfMemoryError("OOM by group selection filter", outOfMemoryError);
        }
        catch (bo bo2) {
            throw new bo(formulaField.getFormula(), "Filter group selection failed", bo2);
        }
        catch (ReportException reportException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(reportException);
        }
    }

    void ii() throws ReportException {
        Fields fields = this.getReport().getFields();
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            FormulaField formulaField = fields.getFormulaField(i2);
            formulaField.b((Object[])null);
            formulaField.c(formulaField);
        }
    }

    private final boolean h(FormulaField formulaField) throws bo {
        if (formulaField != null && formulaField.getFormula() != null && FormulaField.c(formulaField).length() > 0 && !formulaField.isEmpty()) {
            boolean bl2 = this.Jo;
            this.Jo = false;
            Object object = null;
            try {
                object = formulaField.a(null, (Object)null);
                if (object == null) {
                    object = Boolean.FALSE;
                }
            }
            catch (Throwable throwable) {
                if (!this.JC) {
                    this.JC = true;
                    BaseUtils.info("Could not parse FormulaField.  Please report this bug to ClearReports@inetsoftware.de");
                    BaseUtils.info("FormulaField:" + String.valueOf(formulaField));
                    BaseUtils.printStackTrace(throwable);
                }
                throw new bo(formulaField.getFormula(), throwable);
            }
            if (object != null) {
                if (object instanceof Boolean) {
                    if (!((Boolean)object).booleanValue()) {
                        this.Jo = bl2;
                        return true;
                    }
                } else {
                    throw new bo(formulaField.getFormula(), "Selection Formula did not result in a boolean");
                }
            }
            this.Jo = bl2;
        }
        return false;
    }

    public static void addCCFormatString(Object obj, StringBuilder buf) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        if (obj instanceof Boolean) {
            buf.append((Boolean)obj != false ? "true" : "false");
            return;
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            buf.append("Date(").append(1900 + date.getYear()).append(',').append(date.getMonth() + 1).append(',').append(date.getDate()).append(')');
            return;
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            buf.append("Time(").append(time.getHours()).append(',').append(time.getMinutes()).append(',').append(time.getSeconds()).append(')');
            return;
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            buf.append("DateTime(").append(1900 + date.getYear()).append(',').append(date.getMonth() + 1).append(',').append(date.getDate()).append(',').append(date.getHours()).append(',').append(date.getMinutes()).append(',').append(date.getSeconds()).append(')');
            return;
        }
        if (obj instanceof String) {
            char c2;
            String string = String.valueOf(obj);
            StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(c2 = '\''), true);
            if (stringTokenizer.countTokens() == 0) {
                buf.append(c2).append(c2);
            }
            boolean bl2 = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(String.valueOf(c2))) {
                    if (bl2) {
                        buf.append(string2).append(c2);
                    }
                    bl2 = true;
                    continue;
                }
                buf.append(c2).append(string2).append(c2);
                bl2 = false;
            }
            return;
        }
        buf.append(obj.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only used for string opertions")
    final void ij() throws ReportException {
        Serializable serializable;
        if (this.hasGroupTree() && this.Js.size() == 0) {
            this.setRowPosition(1);
            this.setHasBySummaryOrder(false);
            serializable = new StringBuilder();
            for (int i2 = 0; i2 < this.getGroupCount(); ++i2) {
                Object object = this.getGroupValue(true, i2);
                if (((StringBuilder)serializable).length() != 0) {
                    ((StringBuilder)serializable).append(" AND ");
                }
                this.addToTerm(object, i2, (StringBuilder)serializable);
                this.addGroupTreeNodesList(i2, (StringBuilder)serializable, false, null).completeGroupTreeNode(false);
            }
        }
        serializable = this.getEngine();
        RendererBase rendererBase = this.getReport();
        int n2 = !((Engine)serializable).isDrillDownEngine() || this.ik() ? 1 : 0;
        aa aa2 = null;
        aa2 = aa.d(this.Js.size() + n2, rendererBase.getReportProperties().isShowSuppressedGroupTreeNodes());
        if (n2 == 1) {
            String string = rendererBase.getSummaryInfo().getReportTitle();
            if (string == null || string.trim().length() == 0) {
                URL uRL = rendererBase.getEngine().getReportFile();
                string = String.valueOf(new File(String.valueOf(uRL.getFile())).getName());
            }
            aa2.a(0, new GroupTreeNode(rendererBase, string));
            this.Jw = true;
        }
        if (this.hasGroupTree()) {
            for (int i3 = n2; i3 < aa2.getLength(); ++i3) {
                aa2.a(i3, this.Js.get(i3 - n2));
            }
        }
        rendererBase.setGroupTree(aa2);
        this.Js = null;
        Object object = ((Engine)serializable).nU;
        synchronized (object) {
            ((Engine)serializable).nU.notifyAll();
        }
        this.setRowPosition(0);
    }

    public boolean groupTreeHasAdditionalRoot() {
        return this.Jw;
    }

    private boolean ik() {
        if (this.Js.size() == 0) {
            return false;
        }
        byte by2 = this.Js.get(0).getLevel();
        for (int i2 = 1; i2 < this.Js.size(); ++i2) {
            if (this.Js.get(i2).getLevel() != by2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSummaryData() {
        return this.hasBySummaryOrder() & super.hasSummaryData();
    }

    public void resetSummaryData() {
        this.setHasSummaryData(false);
        this.setHasBySummaryOrder(false);
    }

    @Override
    public int getCurrentGroupNumber() {
        return this.Jq;
    }

    public void setCurrentGroupNumber(int currentGroupNumber) {
        this.Jq = currentGroupNumber;
    }

    public void calcSummaryFields() throws ReportException {
        Fields fields;
        if (this.Jt == null) {
            this.initSummaryFields();
        }
        if ((fields = this.getReport().getFields()).getSummaryFieldsCount() == 0) {
            return;
        }
        for (int i2 = 0; i2 < fields.getSummaryFieldsCount(); ++i2) {
            this.getSummaryValue(i2, 0);
        }
        this.setHasSummaryData(true);
        this.setRowPosition(0);
    }

    public void initSummaryFields() throws ReportException {
        Fields fields = this.getReport().getFields();
        if (fields.getSummaryFieldsCount() == 0) {
            return;
        }
        this.Jt = new Aggregator(this, this.getRowCount());
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Initializing Summary Aggregator...");
        }
        for (int i2 = 0; i2 < fields.getSummaryFieldsCount(); ++i2) {
            SummaryField summaryField = fields.getSummaryField(i2);
            this.Jt.addSummaryField(summaryField, this.getGroupIndex(summaryField.getChangeField()), this.getGroupIndex(summaryField.getResetField()));
        }
        this.setHasSummaryData(true);
    }

    public void resetSummaryValues() {
        if (this.Jt != null) {
            this.Jt.reset();
        }
        if (this.getSummaryResults() != null) {
            Arrays.fill(this.getSummaryResults(), null);
        }
    }

    @Override
    protected int getGroupIndex(Field field) throws ReportException {
        if (!(field instanceof GroupField)) {
            return -1;
        }
        Group group = ((GroupField)field).getGroup();
        int n2 = -1;
        for (int i2 = 0; i2 < this.getGroupCount(); ++i2) {
            if (this.getGroup(i2) != group) continue;
            n2 = i2 + 1;
        }
        if (!this.getReport().getEngine().isDrillDownEngine() && n2 < 0) {
            Object[] objectArray = new Object[]{group.getField().paramString()};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.GroupNotFound, objectArray);
        }
        return n2;
    }

    public final Object getSummaryValue(int summaryIdx, int rowIdx) throws ReportException {
        if (this.Jt == null) {
            this.initSummaryFields();
        }
        Fields fields = this.getReport().getFields();
        if (this.getSummaryResults() == null) {
            this.setSummaryResults(new Store[fields.getSummaryFieldsCount()]);
        }
        SummaryField summaryField = fields.getSummaryField(summaryIdx);
        Store store = this.getSummaryResults()[summaryIdx];
        if (store == null) {
            this.getSummaryResults()[summaryIdx] = store = this.Jt.getSummaryResult(summaryField);
        }
        if (store != null) {
            return store.getValue(rowIdx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSummaryInGroupTree() {
        if (this.getSummaryResults() == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 < this.getReport().getGroupTree().getLength(); ++i2) {
                GroupTreeNode groupTreeNode = this.getReport().getGroupTree().af(i2);
                int n2 = groupTreeNode.getRowNumber();
                if (n2 == -1) continue;
                this.getRowSource().setRowPosition(n2);
                groupTreeNode.completeGroupTreeNode(true);
            }
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Write Summary to GroupTreeNode failed");
            }
        }
        finally {
            this.setRowPosition(0);
        }
    }

    protected void setEvaluateNewWhileReading(boolean evaluateNewWhileReading) {
        this.Ju = evaluateNewWhileReading;
    }

    @Override
    public boolean isEvaluateNewWhileReading() {
        return this.Ju;
    }

    public void evaluateWhileReading(boolean resetVariables) throws ReportException {
        Object object;
        if ((Integer)rt.get() < 9) {
            this.setEvaluateNewWhileReading(false);
            return;
        }
        this.setEvaluateNewWhileReading(true);
        boolean bl2 = this.Jo;
        this.Jo = true;
        Fields fields = this.getReport().getFields();
        ArrayList<FormulaField> arrayList = new ArrayList<FormulaField>();
        ArrayList<FormulaField> arrayList2 = new ArrayList<FormulaField>();
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            String string;
            int n2;
            FormulaField formulaField = fields.getFormulaField(i2);
            if (!formulaField.isUsed() || (object = formulaField.getReferenceHolders()) == null || ((ReferenceHolder[])object).length == 0 || ((ReferenceHolder[])object).length == 1 && object[0] == this.getReport().getRecordSelectionFormula()) continue;
            try {
                n2 = formulaField.t(true);
            }
            catch (ReportException reportException) {
                BaseUtils.error(reportException);
                n2 = 2;
            }
            boolean bl3 = false;
            if (n2 == 2) {
                bl3 = formulaField.usesSummaryFields();
            }
            if (n2 != 1 && !bl3 || formulaField.getFormula() == null || (string = FormulaField.c(formulaField)) == null || string.trim().length() == 0) continue;
            formulaField.c(formulaField);
            formulaField.b((Object[])null);
            if (bl3) {
                arrayList2.add(formulaField);
                continue;
            }
            arrayList.add(formulaField);
        }
        if ((arrayList.size() > 0 || arrayList2.size() > 0) && this.getRowCount() > 0) {
            if (resetVariables) {
                this.a(this.getReport().oE.qa());
            }
            this.restoreVariables();
            if (arrayList.size() > 0) {
                this.setRowPosition(0);
                Object[][] objectArray = new Object[arrayList.size()][this.getRowCount()];
                while (this.getRowSource().next()) {
                    for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                        objectArray[i3][this.getRowPosition() - 1] = object = this.getFieldValueByField(false, (Field)arrayList.get(i3));
                    }
                }
                for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                    object = (FormulaField)arrayList.get(i4);
                    object.b(objectArray[i4]);
                }
            }
            if (arrayList2.size() > 0) {
                this.setRowPosition(0);
                Object[][] objectArray = new Object[arrayList2.size()][this.getRowCount()];
                while (this.getRowSource().next()) {
                    for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                        objectArray[i5][this.getRowPosition() - 1] = object = this.getFieldValueByField(false, (Field)arrayList2.get(i5));
                    }
                }
                for (int i6 = 0; i6 < arrayList2.size(); ++i6) {
                    object = (FormulaField)arrayList2.get(i6);
                    object.b(objectArray[i6]);
                }
            }
        }
        this.setEvaluateNewWhileReading(false);
        this.Jo = bl2;
    }

    public void evaluateBeforeReading() throws ReportException {
        Fields fields = this.getReport().getFields();
        for (int i2 = 0; i2 < fields.getFormulaFieldsCount(); ++i2) {
            String string;
            int n2;
            FormulaField formulaField = fields.getFormulaField(i2);
            if (!formulaField.isUsed()) continue;
            try {
                n2 = formulaField.t(true);
            }
            catch (ReportException reportException) {
                BaseUtils.error(reportException);
                n2 = 2;
            }
            if (n2 != 0 || formulaField.getFormula() == null || (string = FormulaField.c(formulaField)) == null || string.trim().length() == 0) continue;
            formulaField.dg();
            Object object = this.getFieldValueByField(false, formulaField);
            formulaField.c(object);
        }
    }

    public void storeVariables() {
        k k2 = this.getReport().getFormula().pi();
        this.Jv = new HashMap<y, Object>();
        for (y y2 : k2.qa().values()) {
            if (!y2.rC()) continue;
            this.Jv.put(y2, y2.c(null));
        }
        for (y y2 : k2.qb().values()) {
            if (!y2.rC()) continue;
            this.Jv.put(y2, y2.c(null));
        }
        for (y y2 : k2.qc().values()) {
            if (!y2.rC()) continue;
            this.Jv.put(y2, y2.c(null));
        }
    }

    public void restoreVariables() {
        if (this.Jv == null || this.Jv.size() == 0) {
            return;
        }
        k k2 = this.getReport().getFormula().pi();
        for (y y2 : k2.qa().values()) {
            if (!this.Jv.containsKey(y2)) continue;
            y2.a(this.Jv.get(y2), (j)null);
        }
        for (y y2 : k2.qb().values()) {
            if (!this.Jv.containsKey(y2)) continue;
            y2.a(this.Jv.get(y2), (j)null);
        }
        for (y y2 : k2.qc().values()) {
            if (!this.Jv.containsKey(y2)) continue;
            y2.a(this.Jv.get(y2), (j)null);
        }
    }

    private void a(q q2) throws ReportException {
        if (q2 != null) {
            for (com.inet.report.formula.ast.o o2 : q2.values()) {
                o2.b(this.getReport().getFormula().pr());
            }
        }
    }

    @Override
    public Object getFieldValueByField(boolean throwException, Field data) throws ReportException {
        try {
            if (data != null) {
                return data.getValue();
            }
        }
        catch (bv bv2) {
            throw bv2;
        }
        catch (AccessDeniedException accessDeniedException) {
            throw accessDeniedException;
        }
        catch (Throwable throwable) {
            if (throwException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
            }
            if (data != null) {
                data.valueType = 11;
            }
            BaseUtils.printStackTrace(throwable);
            this.getEngine().setErrorMsg(throwable.getMessage());
            Object[] objectArray = new Object[]{this.getEngine().getErrorMsg()};
            return ReportErrorCode.FormulaError.getMsg(objectArray);
        }
        return null;
    }

    public final Object getFieldValueByName(boolean throwException, String name) throws ReportException {
        int n2 = RendererBase.getFieldTypeByName(name);
        if (n2 != 14) {
            name = name.substring(1);
        }
        if (name == null) {
            return Integer.toString(n2);
        }
        if (n2 == 14 && this.getRowSource() == null) {
            Database database;
            Datasource datasource;
            DatabaseField databaseField = (DatabaseField)this.getReport().a(throwException, n2, name);
            if (databaseField.kV != null) {
                datasource = databaseField.kV.getDatasource();
                database = (Database)datasource.getDataFactory();
            } else {
                datasource = this.getReport().getDbTables().getDatasource(0);
                database = (Database)datasource.getDataFactory();
            }
            return database.convertIdentifier(datasource, name);
        }
        Field field = this.getReport().a(throwException, n2, name);
        if (field == null) {
            Object[] objectArray = new Object[]{name, Field.e(n2)};
            ReportException reportException = ReportExceptionFactory.createReportException(ReportErrorCode.FieldNotFound, objectArray);
            if (throwException) {
                throw reportException;
            }
            return reportException.getMessage();
        }
        return this.getFieldValueByField(throwException, field);
    }

    public Object getFieldValueByName(String name) {
        try {
            int n2 = RendererBase.getFieldTypeByName(name);
            if (n2 != 14) {
                name = name.substring(1);
            }
            if (name == null) {
                return Integer.toString(n2);
            }
            if (n2 == 14 && this.getRowSource() == null) {
                Database database;
                Datasource datasource;
                DatabaseField databaseField = (DatabaseField)this.getReport().a(false, n2, name);
                if (databaseField.kV != null) {
                    datasource = databaseField.kV.getDatasource();
                    database = (Database)databaseField.kV.getDatasource().getDataFactory();
                } else {
                    datasource = this.getReport().getDbTables().getDatasource(0);
                    database = (Database)datasource.getDataFactory();
                }
                return database.convertIdentifier(datasource, name);
            }
            Field field = this.getReport().a(false, n2, name);
            if (field != null) {
                return field.getValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean f(Datasource datasource) {
        if (!com.inet.report.rowsource.cache.e.bc()) {
            return false;
        }
        String string = datasource.getDataSourceConfigurationName();
        if ("Core".equals(string) || "".equals(string)) {
            return false;
        }
        DataFactory dataFactory = datasource.k(false);
        return dataFactory == null || dataFactory.getClass() != DatabaseSetData.class;
    }

    public void fetchData(DatabaseTables dbTables, Datasource datasource) throws ReportException {
        try {
            if (ReportDataHandler.f(datasource)) {
                d d2;
                c c2 = com.inet.report.rowsource.cache.e.c(this);
                if (this.JE != null && !this.JE.contains(c2)) {
                    com.inet.report.rowsource.cache.e.b(c2);
                    this.JE.add(c2);
                    d2 = null;
                } else {
                    d2 = com.inet.report.rowsource.cache.e.a(c2);
                }
                if (d2 != null) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Use cached report data");
                    }
                    d2.b(this);
                } else {
                    int n2;
                    long l2 = System.nanoTime();
                    this.a(dbTables, datasource);
                    l2 = Math.max(0L, System.nanoTime() - l2 - 5000000L);
                    int n3 = n2 = this.Jl != null ? this.Jl.getRowCount() : 0;
                    if (n2 > 0 && (double)l2 / (double)n2 > 4000.0) {
                        if (BaseUtils.isDebug()) {
                            BaseUtils.debug("Store report data in data cache");
                        }
                        com.inet.report.rowsource.cache.e.a(c2, this);
                    } else if (BaseUtils.isDebug()) {
                        BaseUtils.debug("Caching unnecessary, the data fetching time: " + l2 / 1000000L + "ms");
                    }
                }
            } else {
                this.a(dbTables, datasource);
            }
            if (com.inet.report.database.coredata.d.mY()) {
                DatabaseCore.m(this.getReport());
            }
        }
        catch (ReportException reportException) {
            throw reportException;
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.dataFetching, "\n\n" + StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
        }
    }

    private void a(DatabaseTables databaseTables, Datasource datasource) throws ReportException {
        RendererBase rendererBase = this.getReport();
        if (rendererBase.isMain()) {
            databaseTables.bK();
        } else {
            DatabaseUtils.getReportData(rendererBase.getEngine());
        }
    }

    public boolean shouldSortOnRowSource() {
        boolean bl2 = true;
        if (!(this.Jn || !this.getReport().getReportProperties().isIgnoreSorting() && this.isSortLocally())) {
            bl2 = false;
        }
        return bl2;
    }

    public void setData(String[] columns, Object[][] data, boolean sortExecutedOnDB, boolean filterLater, boolean distinctExecutedOnDB) {
        this.JA = !distinctExecutedOnDB;
        this.Jz = !sortExecutedOnDB;
        this.setFilterLater(filterLater);
        this.a(columns);
        this.setOriginalRowSource(new b(data, this));
    }

    void a(String[] stringArray) {
        this.JD = ReportDataHandler.createFieldList(stringArray, this.getReport());
    }

    public static List<Field> createFieldList(String[] columns, RendererBase<?> renderer) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        block2: for (int i2 = 0; i2 < columns.length; ++i2) {
            String string = columns[i2];
            try {
                Field field = renderer.getFieldByRefName(false, string);
                if (field != null) {
                    arrayList.add(field);
                    continue;
                }
                int n2 = renderer.getDbFields().indexOfShortName(string);
                if (n2 >= 0) {
                    arrayList.add(renderer.getDbFields().elementAt(n2));
                    continue;
                }
                if (renderer.Ix != null) {
                    for (int i3 = 0; i3 < renderer.Ix.length; ++i3) {
                        if (!string.equalsIgnoreCase(renderer.Ix[i3].getName())) continue;
                        arrayList.add(renderer.Ix[i3]);
                        continue block2;
                    }
                }
                DatabaseField databaseField = new DatabaseField(renderer);
                databaseField.kX = databaseField.name = string;
                arrayList.add(databaseField);
                continue;
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
            }
        }
        return arrayList;
    }

    public void deleteCacheReportKey() throws ReportException {
        if (com.inet.report.rowsource.cache.e.bc()) {
            this.JE = new HashSet();
            RendererBase rendererBase = this.getReport();
            for (int i2 = 0; i2 < rendererBase.getSubReportCount(); ++i2) {
                ReportDataHandler reportDataHandler = rendererBase.getSubReport(i2).getDataProvider();
                reportDataHandler.JE = this.JE;
            }
        }
    }

    @Override
    protected void completeGroupsImpl() {
        throw new IllegalStateException("Is for chart or crosstab only.");
    }

    @Override
    protected void setSums(SummaryField[] sums) {
        throw new IllegalStateException("Is for chart or crosstab only.");
    }

    @Override
    protected SummaryField[] getSums() {
        throw new IllegalStateException("Is for chart or crosstab only.");
    }

    private static int a(Field field, List<Field> list) throws ReportException {
        int n2 = list.indexOf(field);
        if (n2 < 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(list.get(i2).getName());
            }
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoColumn, field.getName(), stringBuilder);
        }
        return n2;
    }

    public boolean isSortLocally() {
        return this.Jz;
    }

    public void setSortLocally(boolean sortLocally) {
        this.Jz = sortLocally;
    }

    public void setFilterLocally(boolean filterLocally) {
        this.Jy = filterLocally;
    }

    public void setDistinctLocally(boolean distinctLocally) {
        this.JA = distinctLocally;
    }

    public boolean isDistinctLocally() {
        return this.JA;
    }

    public boolean isFilterSelectionErrorLogged() {
        return this.JC;
    }

    public void setFilterSelectionErrorLogged(boolean filterSelectionErrorLogged) {
        this.JC = filterSelectionErrorLogged;
    }

    public List<Field> getDatabaseColumns() {
        return this.JD;
    }

    public void setDatabaseColumns(List<Field> databaseColumns) {
        this.JD = databaseColumns;
    }
}

