/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingValueProvider;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldValueProvider;
import com.inet.report.Fields;
import com.inet.report.FormulaDefaultValue;
import com.inet.report.FormulaField;
import com.inet.report.FormulaRange;
import com.inet.report.PromptRequestWarning;
import com.inet.report.QueryValueProvider;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.RendererBase;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLValueProvider;
import com.inet.report.TableSource;
import com.inet.report.as;
import com.inet.report.bd;
import com.inet.report.formula.Evaluable;
import com.inet.report.formula.e;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.util.PromptUtils;
import com.inet.report.y;
import com.inet.viewer.PromptValue;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class PromptField
extends Field
implements ReferenceHolder {
    transient boolean valueSet;
    private ArrayList<DefaultValue> yU;
    private DynamicValueProvider yV;
    String yW;
    TableSource yX;
    String promptText;
    boolean yY;
    int yZ;
    boolean range;
    Object za;
    Object zb;
    String editMask = "";
    boolean zc;
    int zd;
    boolean ze;
    boolean zf;
    private boolean zg = true;
    private boolean descOnly;
    Integer zh;
    int zi;
    Object value;
    private Evaluable zj;
    public static final int DISCRETE_VALUE = 0;
    public static final int RANGE_VALUE = 1;
    public static final int DISCRETE_AND_RANGE_VALUE = 2;
    private r qh = new r(this);

    PromptField(RendererBase ren) {
        this.type = 16;
        this.bB = ren;
        this.zg = true;
        this.ze = true;
    }

    @Override
    public final void setName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a prompt field cannot be empty");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (name.equalsIgnoreCase(this.name)) {
            try {
                this.rename(name);
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("Name not allowed", reportException);
            }
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.id(), name)) {
            throw y.b("PromptField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    public final String getPromptText() {
        return this.promptText;
    }

    public final void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public final Object getPromptValue() {
        return this.getValue();
    }

    void e(Object object) throws ReportException {
        Object object2;
        if (!this.range) {
            return;
        }
        if (this.za == null && this.zb == null) {
            return;
        }
        if (object instanceof FormulaRange) {
            FormulaRange formulaRange = (FormulaRange)object;
            this.e(formulaRange.getFrom());
            this.e(formulaRange.getTo());
            return;
        }
        if (object instanceof Object[]) {
            for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                this.e(((Object[])object)[i2]);
            }
            return;
        }
        switch (this.getPromptType()) {
            case 11: {
                if (!(object instanceof String) || this.za != null && !((double)((String)object).length() >= ((Number)this.za).doubleValue()) || this.zb != null && !((double)((String)object).length() <= ((Number)this.zb).doubleValue())) break;
                return;
            }
            case 6: 
            case 7: {
                if (!(object instanceof Number)) break;
                object2 = (Number)object;
                if (this.za != null && !(((Number)object2).doubleValue() >= ((Number)this.za).doubleValue()) || this.zb != null && !(((Number)object2).doubleValue() <= ((Number)this.zb).doubleValue())) break;
                return;
            }
            case 8: {
                return;
            }
            case 9: 
            case 10: 
            case 15: {
                if (!(object instanceof java.util.Date)) break;
                object2 = (java.util.Date)object;
                if (this.za != null && !((java.util.Date)this.za).before((java.util.Date)object2) && !this.za.equals(object2) || this.zb != null && !((java.util.Date)this.zb).after((java.util.Date)object2) && !this.zb.equals(object2)) break;
                return;
            }
        }
        String string = switch (this.getPromptType()) {
            case 6, 7, 9, 10, 15 -> {
                e var4_5 = this.bB.getFormula().pN();
                object2 = ReportErrorCode.valueNoBetweenMinMax;
                yield object2.getMsg(new Object[]{var4_5.b(this.za, true), var4_5.b(this.zb, true)});
            }
            case 11 -> {
                object2 = ReportErrorCode.valueNoBetweenMinMaxLength;
                yield object2.getMsg(new Object[]{this.za, this.zb});
            }
            case 8 -> {
                object2 = ReportErrorCode.rangeOnBoolean;
                yield object2.getMsg(new Object[0]);
            }
            default -> {
                object2 = ReportErrorCode.wrongPromptType;
                yield object2.getMsg(new Object[]{this.getPromptType()});
            }
        };
        int n2 = ((ReportErrorCode)((Object)object2)).getErrorCodeNumber();
        throw new PromptRequestWarning(string, n2, Engine.t(this.bB));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPromptValue(Object prompt) throws ReportException {
        if (prompt == null) {
            this.e(prompt);
            this.value = prompt;
            this.valueSet = true;
            return;
        }
        if (prompt instanceof PromptValue) {
            this.setPromptValueAsFormula("formula:" + ((PromptValue)prompt).getStringRepresentation());
            return;
        }
        if (this.yY) {
            if (!(prompt instanceof Object[])) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongMultipleDiscreteValue, String.valueOf(this.yY));
            }
            Object[] objectArray = (Object[])prompt;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                PromptField.a(object, this.valueType, this.name, this.getValueTypeString());
                if (object instanceof FormulaRange) {
                    if (this.yZ == 0) {
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongRangeValue, String.valueOf(this.yZ));
                    }
                    this.e(object);
                    continue;
                }
                if (this.yZ == 1) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongRangeValue, String.valueOf(this.yZ));
                }
                this.e(object);
            }
            if (objectArray.length == 0) {
                this.e(null);
            }
            this.valueSet = true;
            this.value = prompt;
            return;
        } else if (this.yZ == 0) {
            if (prompt instanceof Object[] || prompt instanceof FormulaRange) throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongDiscreteValue, "Object");
            PromptField.a(prompt, this.valueType, this.name, this.getValueTypeString());
            this.e(prompt);
            this.valueSet = true;
            this.value = prompt;
            return;
        } else if (this.yZ == 1) {
            if (!(prompt instanceof FormulaRange)) throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongDiscreteValue, "FormulaRange");
            PromptField.a(prompt, this.valueType, this.name, this.getValueTypeString());
            this.e(prompt);
            this.valueSet = true;
            this.value = prompt;
            return;
        } else {
            if (this.yZ != 2) return;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongMultipleDiscreteValue, String.valueOf(this.yY));
        }
    }

    public void setPromptValueAsFormula(String formula) throws ReportException {
        this.bB.getEngine().a(this, formula);
    }

    public final int getPromptType() {
        if (this.valueType == -1) {
            return this.valueType;
        }
        return this.valueType % 128;
    }

    public final void setPromptType(int valueType) {
        if (this.valueType == valueType) {
            return;
        }
        this.valueType = valueType;
        this.za = null;
        this.zb = null;
        if (valueType % 128 != 6 && valueType % 128 != -1 && valueType % 128 != 7 && valueType % 128 != 8 && valueType % 128 != 9 && valueType % 128 != 10 && valueType % 128 != 15 && valueType % 128 != 11 && valueType % 128 != 14) {
            throw new IllegalArgumentException("illegal prompt value type " + valueType + "! Must be one of the Field value type constants!");
        }
        this.bB.getFields().a(this, 2);
    }

    public final void setUseRange(boolean newValue) {
        this.range = newValue;
    }

    public final boolean getUseRange() {
        return this.range;
    }

    public final void setDescriptionOnly(boolean descOnly) {
        this.descOnly = descOnly;
    }

    public final boolean isDescriptionOnly() {
        return this.descOnly;
    }

    public final void setEditable(boolean isEditable) {
        if (!isEditable && this.isPasswordField()) {
            throw new UnsupportedOperationException("password fields must be editable!");
        }
        this.zg = isEditable;
    }

    public final boolean isEditable() {
        return this.zg;
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public final boolean isPasswordField() {
        return "password".equals(this.editMask);
    }

    public final void setPasswordField(boolean isPasswordField) {
        if (isPasswordField) {
            this.editMask = "password";
            this.setDefaultValues(null);
            this.setEditable(true);
            this.setAllowMultipleValues(false);
            this.setDiscreteOrRangeType(0);
        } else {
            this.editMask = "";
        }
    }

    public void setDiscreteOrRangeType(int newValue) throws IllegalArgumentException {
        if (newValue != 0 && this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field must have the discrete type DISCRETE_VALUE");
        }
        if (newValue < 0 || newValue > 2) {
            throw y.a(newValue, "DiscreteOrRangeType", (ErrorCode)ReportErrorCode.outOfRange2);
        }
        this.yZ = newValue;
    }

    public int getDiscreteOrRangeType() {
        return this.yZ;
    }

    public void setAllowMultipleValues(boolean newValue) {
        if (this.isPasswordField() && newValue) {
            throw new UnsupportedOperationException("Password Fields can not be set to allow multiple values.");
        }
        this.yY = newValue;
    }

    public boolean getAllowMultipleValues() {
        return this.yY;
    }

    public int getValuesCount() {
        if (this.getValue() == null) {
            return 0;
        }
        if (this.getValue() instanceof Object[]) {
            return ((Object[])this.getValue()).length;
        }
        return 1;
    }

    public void setMinRangeValue(Object min) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (min == null) {
            this.za = null;
        } else {
            this.setMinMaxRangeValues(min, this.zb);
        }
    }

    public void setMaxRangeValue(Object max) throws ReportException {
        if (!this.range) {
            throw new IllegalStateException("Range is disabled");
        }
        if (max == null) {
            this.zb = null;
        } else {
            this.setMinMaxRangeValues(this.za, max);
        }
    }

    public void setMinMaxRangeValues(Object min, Object max) throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 11: {
                    double d2;
                    if (min instanceof Number) {
                        d2 = ((Number)min).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MinNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                    if (max instanceof Number) {
                        d2 = ((Number)max).doubleValue();
                        if (d2 < 0.0) {
                            Object[] objectArray = new Object[]{max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxNegativeForString, objectArray);
                        }
                        if (d2 - Math.floor(d2) > 0.0) {
                            Object[] objectArray = new Object[]{max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.StringLimitIsFractional, objectArray);
                        }
                    }
                }
                case 6: 
                case 7: {
                    if (min instanceof Number && max instanceof Number) {
                        if (((Number)min).doubleValue() > ((Number)max).doubleValue()) {
                            Object[] objectArray = new Object[]{max, min};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Number || min instanceof Number && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.MinMaxNotNumber, objectArray);
                    }
                    this.za = min;
                    this.zb = max;
                    break;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    if (min instanceof Date && max instanceof Date) {
                        if (((Date)min).getTime() > ((Date)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Date || min instanceof Date && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noDateInstance, objectArray);
                    }
                    this.za = min;
                    this.zb = max;
                    break;
                }
                case 15: {
                    if (min instanceof Timestamp && max instanceof Timestamp) {
                        if (((Timestamp)min).getTime() > ((Timestamp)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Timestamp || min instanceof Timestamp && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noTimeStampInstance, objectArray);
                    }
                    this.za = min;
                    this.zb = max;
                    break;
                }
                case 10: {
                    if (min instanceof Time && max instanceof Time) {
                        if (((Time)min).getTime() > ((Time)max).getTime()) {
                            Object[] objectArray = new Object[]{min, max};
                            throw ReportExceptionFactory.createReportException(ReportErrorCode.MaxLessThanMin, objectArray);
                        }
                    } else if (!(min == null && max instanceof Time || min instanceof Time && max == null || min == null && max == null)) {
                        Object[] objectArray = new Object[]{};
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.noTimeInstance, objectArray);
                    }
                    this.za = min;
                    this.zb = max;
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{this.name};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
                }
            }
        } else {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
        }
    }

    public Object getMinRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.za;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.za;
                }
                case 15: {
                    return this.za;
                }
                case 10: {
                    return this.za;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
    }

    public Object getMaxRangeValue() throws ReportException {
        if (this.range) {
            switch (this.getPromptType()) {
                case 6: 
                case 7: 
                case 11: {
                    return this.zb;
                }
                case 8: {
                    Object[] objectArray = new Object[]{};
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.rangeOnBoolean, objectArray);
                }
                case 9: {
                    return this.zb;
                }
                case 15: {
                    return this.zb;
                }
                case 10: {
                    return this.zb;
                }
            }
            Object[] objectArray = new Object[]{this.name};
            throw ReportExceptionFactory.createReportException(ReportErrorCode.wrongPromptType, objectArray);
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ReportErrorCode.disabledRange, objectArray);
    }

    public void setPromptValueDescriptions(String[] descr) {
        if (descr == null) {
            throw new NullPointerException("description array is null");
        }
        int n2 = this.getDefaultValueCount();
        if (n2 != descr.length) {
            throw new IllegalArgumentException("description array's length(" + descr.length + ") does not match default value count (" + n2 + ")");
        }
        for (int i2 = 0; i2 < descr.length; ++i2) {
            String string = descr[i2];
            this.getDefaultValue(i2).setDescription(string);
        }
    }

    public String[] getPromptValueDescriptions() {
        if (this.yV != null) {
            DefaultValue[] defaultValueArray = this.yV.getDefaultValues();
            String[] stringArray = new String[defaultValueArray.length];
            for (int i2 = 0; i2 < defaultValueArray.length; ++i2) {
                DefaultValue defaultValue = defaultValueArray[i2];
                stringArray[i2] = defaultValue.getDescription();
            }
            return stringArray;
        }
        if (this.yU == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.getDefaultValueCount()];
        for (int i3 = 0; i3 < this.getDefaultValueCount(); ++i3) {
            stringArray[i3] = this.getDefaultValue(i3).getDescription();
        }
        return stringArray;
    }

    @Override
    Field[] D(int n2) {
        return new PromptField[n2];
    }

    void fr() throws ReportException {
        this.value = null;
        this.valueSet = false;
        int n2 = this.getDefaultValueCount();
        if (this.yU == null || n2 == 0) {
            return;
        }
        if (this.yY) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = this.getDefaultValue(i2).getValue();
                if (!(object instanceof FormulaRange) && this.getDiscreteOrRangeType() == 1) continue;
                arrayList.add(object);
            }
            this.setPromptValue(arrayList.toArray());
        } else if (this.getDiscreteOrRangeType() != 0) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object = this.getDefaultValue(i3).getValue();
                if (!(object instanceof FormulaRange)) continue;
                this.setPromptValue(object);
            }
        } else {
            this.setPromptValue(this.getDefaultValue(0).getValue());
        }
    }

    @Override
    public void setValueType(int newValue) {
        if (PromptUtils.isArray(newValue)) {
            newValue ^= 0x100;
            this.setAllowMultipleValues(true);
        }
        if (PromptUtils.isRange(newValue)) {
            newValue ^= 0x80;
            this.setDiscreteOrRangeType(1);
        }
        super.setValueType(newValue);
    }

    @Override
    public int getValueType() {
        int n2 = this.valueType;
        if (n2 == -1) {
            return n2;
        }
        if (this.yY && !PromptUtils.isArray(n2)) {
            n2 += 256;
        }
        if (this.yZ != 0 && !PromptUtils.isRange(n2)) {
            n2 += 128;
        }
        return n2;
    }

    @Override
    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("\n\tText: ").append(this.promptText);
        stringBuilder.append("\n\tType: ").append(this.valueType);
        stringBuilder.append("\n\tValue:").append(this.getValue());
        stringBuilder.append("\n\tLink: ").append(this.zh);
        return stringBuilder.toString();
    }

    public String getPromptValueAsFormula() {
        return PromptUtils.defaultPrompt(this.value, this.valueType);
    }

    public void setDefaultValueProvider(DynamicValueProvider provider) {
        if (provider instanceof CascadingValueProvider && this.a((CascadingValueProvider)provider)) {
            throw new IllegalArgumentException("Circular dependency: this prompt is already an ancestor of the prompt being set as parent!");
        }
        this.yV = provider;
        this.resetReferences();
        this.setReferences();
        if (provider != null) {
            this.yU = null;
        }
    }

    private boolean a(CascadingValueProvider cascadingValueProvider) {
        PromptField promptField = cascadingValueProvider.getParent();
        ArrayList<PromptField> arrayList = new ArrayList<PromptField>();
        while (true) {
            if (arrayList.contains(promptField)) {
                return true;
            }
            arrayList.add(promptField);
            if (promptField == this) {
                return true;
            }
            DynamicValueProvider dynamicValueProvider = promptField.getDefaultValueProvider();
            if (!(dynamicValueProvider instanceof CascadingValueProvider)) break;
            promptField = ((CascadingValueProvider)dynamicValueProvider).getParent();
        }
        return false;
    }

    public DynamicValueProvider getDefaultValueProvider() {
        return this.yV;
    }

    public DefaultValue[] getDefaultValues() {
        if (this.yV != null) {
            DefaultValue[] defaultValueArray;
            for (DefaultValue defaultValue : defaultValueArray = this.yV.getDefaultValues()) {
                if (PromptUtils.checkValueType(defaultValue.getValue(), this.valueType)) continue;
                BaseUtils.error("Dynamic default values were not the correct type: " + defaultValue.getValue().getClass().getCanonicalName() + " for value type " + this.getValueTypeString());
                return new DefaultValue[0];
            }
            if (this.yV instanceof SQLValueProvider && defaultValueArray.length == 1000) {
                this.setEditable(true);
            }
            return defaultValueArray;
        }
        if (this.yU == null) {
            return null;
        }
        return this.yU.toArray(new DefaultValue[0]);
    }

    public void setDefaultValues(DefaultValue[] values) {
        DefaultValue defaultValue;
        int n2;
        if (this.yU != null) {
            for (n2 = 0; n2 < this.yU.size(); ++n2) {
                defaultValue = this.yU.get(n2);
                if (!(defaultValue instanceof FormulaDefaultValue)) continue;
                FormulaField.d(((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField());
            }
        }
        if (values == null || values.length == 0 || values[0] == null) {
            this.yU = null;
            this.yV = null;
            return;
        }
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("A password field can not have default values");
        }
        this.yU = new ArrayList();
        this.yV = null;
        for (n2 = 0; n2 < values.length; ++n2) {
            if (values[n2] instanceof FormulaDefaultValue) continue;
            try {
                this.e(values[n2].getValue());
                continue;
            }
            catch (ReportException reportException) {
                throw new IllegalArgumentException("The default value '" + String.valueOf(values[n2].getValue()) + "' is not in the allowed value range.");
            }
        }
        this.yU.clear();
        for (n2 = 0; n2 < values.length; ++n2) {
            defaultValue = values[n2];
            this.yU.add(defaultValue);
        }
        this.fs();
        this.resetReferences();
        this.setReferences();
    }

    public String getDefaultPromptValuesAsString() {
        DefaultValue[] defaultValueArray = this.getDefaultValues();
        if (defaultValueArray == null) {
            return "";
        }
        return PromptUtils.parsePrompt(defaultValueArray, this.valueType);
    }

    public void addDefaultValue(DefaultValue value) {
        this.a(value);
        this.fs();
    }

    private void fs() {
        if (this.bB != null && this.bB.gE > 0 || ((Boolean)bd.Dj.get()).booleanValue()) {
            try {
                this.fr();
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
                throw new IllegalArgumentException("could not set default value as prompt's value:" + reportException.getMessage());
            }
        }
    }

    private void a(DefaultValue defaultValue) {
        FormulaField formulaField;
        if (this.isPasswordField()) {
            throw new UnsupportedOperationException("Password prompts can not have default values.");
        }
        try {
            this.e(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            try {
                throw new IllegalArgumentException("default value (" + String.valueOf(defaultValue.getValue()) + ") was not in the allowed range (" + String.valueOf(this.getMinRangeValue()) + " to " + String.valueOf(this.getMaxRangeValue()) + ").");
            }
            catch (ReportException reportException2) {
                BaseUtils.printStackTrace(reportException2);
            }
        }
        if (this.yU == null) {
            this.yU = new ArrayList();
        }
        if (this.yV != null) {
            this.yV = null;
        }
        this.yU.add(defaultValue);
        if (defaultValue instanceof FormulaDefaultValue && (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) != null) {
            this.addReferencedObject(formulaField);
        }
    }

    public void removeDefaultValue(int index) {
        if (this.yU == null) {
            throw new IndexOutOfBoundsException("trying to remove a default value when there are none!");
        }
        this.yU.remove(index);
        if (this.yU.size() == 0) {
            this.yU = null;
        }
    }

    public int getDefaultValueCount() {
        if (this.yU == null) {
            return 0;
        }
        return this.yU.size();
    }

    public void setDefaultValue(int index, DefaultValue defaultValue) {
        try {
            this.e(defaultValue.getValue());
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("trying to set illegal default value: " + reportException.getMessage());
        }
        if (this.yU == null) {
            throw new IndexOutOfBoundsException(index + " >= 0");
        }
        this.yU.set(index, defaultValue);
        this.fs();
    }

    @Override
    void a(int n2, String string, as as2) {
        try {
            switch (n2) {
                case 210: {
                    this.range = Boolean.valueOf(string);
                    break;
                }
                case 7701: {
                    this.editMask = string;
                    break;
                }
                case 216: {
                    this.zb = this.W(string);
                    break;
                }
                case 215: {
                    this.za = this.W(string);
                    break;
                }
                case 208: {
                    this.yZ = Integer.parseInt(string);
                    break;
                }
                case 209: {
                    this.promptText = string;
                    break;
                }
                case 223: {
                    if (as2.xK < this.getDefaultValueCount()) {
                        this.getDefaultValue(as2.xK).setDescription(string);
                        ++as2.xK;
                        break;
                    }
                    BaseUtils.warning("truncated prompt descriptions for prompt field " + this.getName() + " - the number of prompt values did not match the number of prompt descriptions!");
                    break;
                }
                case 221: {
                    Datasource datasource;
                    this.yW = string;
                    if (this.yW.trim().length() == 0) {
                        this.yW = this.name;
                    }
                    if (this.yW != null && (datasource = as2.wR.bI().getDbTables().getDatasource(0)).getTableSourceCount() > 0 && this.yX == null) {
                        this.yX = datasource.getTableSource(0);
                    }
                    break;
                }
                case 207: {
                    this.zg = Boolean.valueOf(string);
                    break;
                }
                case 229: {
                    this.descOnly = Boolean.valueOf(string);
                    break;
                }
                case 206: {
                    this.yY = Boolean.valueOf(string);
                    break;
                }
                case 214: {
                    this.zh = new Integer(Integer.parseInt(string));
                    break;
                }
                case 228: {
                    try {
                        this.yX = as2.wR.bI().getDbTables().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                default: {
                    super.a(n2, string, as2);
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    private Object W(String string) {
        Comparable<java.util.Date> comparable = null;
        switch (this.getPromptType()) {
            case 6: 
            case 7: 
            case 11: {
                comparable = new Double(string);
                break;
            }
            case 9: {
                comparable = Date.valueOf(string);
                break;
            }
            case 10: {
                comparable = Time.valueOf(string);
                break;
            }
            case 15: {
                comparable = Timestamp.valueOf(string);
            }
        }
        return comparable;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public boolean isParameterOfStoredProcedure() {
        return this.yW != null && this.yX != null;
    }

    public TableSource[] getTableSources() {
        if (this.yX == null) {
            return null;
        }
        return new TableSource[]{this.yX};
    }

    public String[] getStoredProceduresParameterNames() {
        if (this.yW == null) {
            return null;
        }
        return new String[]{this.yW};
    }

    public boolean isSubreportLink() {
        return this.zi > 0;
    }

    @Override
    public boolean isUsed() {
        if (this.yX != null || this.yW != null && this.yW.trim().length() > 0) {
            return true;
        }
        if (!super.isUsed()) {
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (!(referenceHolderArray[i2] instanceof PromptField) || !((PromptField)referenceHolderArray[i2]).isUsed()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    boolean f(TableSource tableSource) {
        if (super.isUsed()) {
            return false;
        }
        return this.yX == tableSource;
    }

    public DefaultValue getDefaultValue(int i2) {
        if (this.yU == null) {
            throw new IndexOutOfBoundsException("trying to retrieve a default value when there are none!");
        }
        return this.yU.get(i2);
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        Object object;
        Object object2;
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        k.a(stringBuilder, n2, a.zn.name(), k.g(this.yY));
        k.a(stringBuilder, n2, a.zo.name(), k.z(this.yZ));
        k.a(stringBuilder, n2, a.zv.name(), k.g(this.zg));
        k.a(stringBuilder, n2, a.zp.name(), k.g(this.descOnly));
        k.a(stringBuilder, n2, a.zq.name(), this.editMask);
        if (this.range) {
            object2 = "";
            int n3 = this.getPromptType();
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.za != null) {
                object2 = k.e(((Number)this.za).doubleValue());
            } else if (n3 == 9 && this.za != null) {
                object2 = this.za.toString();
            } else if (n3 == 10 && this.za != null) {
                object2 = this.za.toString();
            } else if (n3 == 15 && this.za != null) {
                object2 = this.za.toString();
            }
            if (((String)object2).length() != 0) {
                k.a(stringBuilder, n2, a.zt.name(), (String)object2);
            }
            object = "";
            if ((n3 == 6 || n3 == 7 || n3 == 11) && this.zb != null) {
                object = k.e(((Number)this.zb).doubleValue());
            } else if (n3 == 9 && this.zb != null) {
                object = this.zb.toString();
            } else if (n3 == 10 && this.zb != null) {
                object = this.zb.toString();
            } else if (n3 == 15 && this.zb != null) {
                object = this.zb.toString();
            }
            if (((String)object).length() != 0) {
                k.a(stringBuilder, n2, a.zu.name(), (String)object);
            }
        }
        k.a(stringBuilder, n2, a.zr.name(), this.promptText);
        k.a(stringBuilder, n2, a.zs.name(), k.g(this.range));
        if (this.zh != null) {
            k.a(stringBuilder, n2, a.zx.name(), k.z(this.zh));
        }
        k.a(stringBuilder, n2, a.zz.name(), this.yW);
        if (this.yX != null) {
            k.a(stringBuilder, n2, a.zy.name(), this.yX.getAlias());
        }
        if (this.yV != null) {
            stringBuilder.append(string).append("<").append("DefaultValueProvider");
            if (this.yV instanceof QueryValueProvider) {
                PromptField promptField;
                String string2;
                object2 = (QueryValueProvider)this.yV;
                k.a(stringBuilder, "type", "sql");
                stringBuilder.append(">\n");
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zC.name(), ((QueryValueProvider)object2).getQuery().replaceAll("\r\n", "\n"));
                String string3 = ((QueryValueProvider)object2).getFieldRefName();
                if (string3 != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, a.zD.name(), string3);
                }
                if ((string2 = ((Datasource)(object = ((QueryValueProvider)object2).getDatasource())).getDataSourceConfigurationName()) != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, a.zE.name(), string2);
                }
                if ((promptField = ((QueryValueProvider)object2).getParent()) != null) {
                    k.a(stringBuilder, n2, promptField, "cascading parent");
                }
            } else if (this.yV instanceof CascadingValueProvider) {
                k.a(stringBuilder, "type", "cascading");
                stringBuilder.append(">\n");
                object2 = (CascadingValueProvider)this.yV;
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zw.name(), k.z(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((CascadingValueProvider)object2).getParent(), "cascading parent");
            } else if (this.yV instanceof FieldValueProvider) {
                k.a(stringBuilder, "type", "field");
                stringBuilder.append(">\n");
                object2 = (FieldValueProvider)this.yV;
                stringBuilder.append(string);
                k.a(stringBuilder, n2, a.zw.name(), k.z(((FieldValueProvider)object2).getSortType()));
                stringBuilder.append(string);
                k.a(stringBuilder, n2, ((FieldValueProvider)object2).getValues(), "dynamic value field");
                if (((FieldValueProvider)object2).getDescriptions() != null) {
                    stringBuilder.append(string);
                    k.a(stringBuilder, n2, ((FieldValueProvider)object2).getDescriptions(), "dynamic description field");
                }
            } else {
                stringBuilder.append(">\n");
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("could not save dynamic value provider");
                }
            }
            stringBuilder.append(string + "</DefaultValueProvider>\n");
        } else if (this.yU != null) {
            int n4 = this.getDefaultValueCount();
            stringBuilder.append(string + "<DefaultPromptValues>\n");
            String[] stringArray = this.getPromptValueDescriptions();
            for (int i2 = 0; i2 < n4; ++i2) {
                DefaultValue defaultValue;
                stringBuilder.append(string + string + "<DefaultValue");
                if (stringArray != null && stringArray.length > i2 && stringArray[i2] != null && !stringArray[i2].equals("")) {
                    stringBuilder.append(k.l("description", stringArray[i2]));
                }
                if ((defaultValue = this.getDefaultValue(i2)) instanceof FormulaDefaultValue) {
                    stringBuilder.append(">\n");
                    stringBuilder.append(string + string + string + k.h(((FormulaDefaultValue)defaultValue).getFormulaText()) + "\n");
                    stringBuilder.append(string + string + string);
                    k.a(stringBuilder, 0, FormulaField.a.sc.name(), k.z(((FormulaDefaultValue)defaultValue).isBasicSyntax() ? 1002 : 1001));
                    stringBuilder.append(string + string + "</DefaultValue>\n");
                    continue;
                }
                stringBuilder.append(k.l("value", PromptUtils.parsePrompt(defaultValue.getValue(), this.getPromptType())));
                stringBuilder.append("/>\n");
            }
            stringBuilder.append(string + "</DefaultPromptValues>\n");
        }
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        if ("formula".equals(parserMap.get("defaultvaluetype"))) {
            parserMap.put("defaultvalueformulatext", text);
        } else {
            super.parseText(text, parserMap);
        }
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            a a2 = a.valueOf(tag);
            String string = atts.getValue("value");
            switch (a2) {
                case zl: {
                    if (group != XMLTag.DefaultPromptValues) break;
                    String string2 = atts.getValue("value");
                    String string3 = atts.getValue("description");
                    if (string2 != null) {
                        DefaultValue defaultValue = DefaultValue.createDefaultValueFromFormula(string2, string3, this.bB.getEngine());
                        this.a(defaultValue);
                        break;
                    }
                    parserMap.put("defaultvaluetype", "formula");
                    parserMap.put("defaultvaluedescription", string3);
                    break;
                }
                case zG: {
                    parserMap.put("defaultvalueformulasyntax", Integer.valueOf(string));
                    break;
                }
                case zm: {
                    this.setName(string);
                    break;
                }
                case zr: {
                    this.setPromptText(string);
                    break;
                }
                case zn: {
                    this.setAllowMultipleValues(Boolean.valueOf(string));
                    break;
                }
                case zo: {
                    this.setDiscreteOrRangeType(Integer.valueOf(string));
                    break;
                }
                case zp: {
                    this.setDescriptionOnly(Boolean.valueOf(string));
                    break;
                }
                case zs: {
                    this.setUseRange(Boolean.valueOf(string));
                    break;
                }
                case zq: {
                    this.editMask = string;
                    break;
                }
                case zv: {
                    this.setEditable(Boolean.valueOf(string));
                    break;
                }
                case zx: {
                    this.zh = Integer.valueOf(string);
                    break;
                }
                case zy: {
                    try {
                        this.yX = this.bB.getDbTables().getTablesource(string);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.error(reportException);
                    }
                    break;
                }
                case zz: {
                    this.yW = string;
                    if (this.yW.trim().length() != 0) break;
                    this.yW = this.name;
                    break;
                }
                case zt: {
                    this.za = this.W(string);
                    break;
                }
                case zu: {
                    this.zb = this.W(string);
                    break;
                }
                case zB: {
                    String string4 = atts.getValue("type");
                    parserMap.put(b.zJ.name(), this.bB.getEngine());
                    SQLValueProvider sQLValueProvider = null;
                    if ("sql".equals(string4)) {
                        sQLValueProvider = new QueryValueProvider();
                    } else if ("cascading".equals(string4)) {
                        sQLValueProvider = new CascadingValueProvider();
                    } else if ("field".equals(string4)) {
                        sQLValueProvider = new FieldValueProvider();
                    }
                    parserMap.put(b.zK.name(), sQLValueProvider);
                    return sQLValueProvider;
                }
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.printStackTrace(illegalArgumentException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
        if (XMLTag.DefaultValue.name().equals(tag)) {
            String string = (String)parserMap.get("defaultvalueformulatext");
            Integer n2 = (Integer)parserMap.get("defaultvalueformulasyntax");
            String string2 = (String)parserMap.get("defaultvaluedescription");
            if (string != null && n2 != null && "formula".equals(parserMap.get("defaultvaluetype"))) {
                try {
                    FormulaField formulaField = this.bB.getEngine().getFields().addFormulaField("defaultvalueformula", string, 3);
                    formulaField.setSyntax(n2);
                    FormulaDefaultValue formulaDefaultValue = DefaultValue.createFormulaFieldDefaultValueFromFormula(formulaField, string2, this.getValueType(), this.bB.getEngine());
                    this.a(formulaDefaultValue);
                }
                catch (ReportException reportException) {
                    BaseUtils.printStackTrace(reportException);
                }
            }
            parserMap.remove("defaultvalueformulatext");
            parserMap.remove("defaultvaluedescription");
            parserMap.remove("defaultvalueformulasyntax");
            parserMap.remove("defaultvaluetype");
            super.parseEndElement(group, tag, parserMap);
            return;
        }
        DynamicValueProvider dynamicValueProvider = (DynamicValueProvider)parserMap.get(b.zK.name());
        if (dynamicValueProvider != null) {
            try {
                QueryValueProvider queryValueProvider;
                if (dynamicValueProvider instanceof CascadingValueProvider) {
                    CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)dynamicValueProvider;
                    if (cascadingValueProvider.getParent() == null || cascadingValueProvider.getParent().getDefaultValueProvider() == null || cascadingValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read cascading prompt: parent - " + String.valueOf(cascadingValueProvider.getParent()) + "; values - " + String.valueOf(cascadingValueProvider.getValues()));
                        return;
                    }
                } else if (dynamicValueProvider instanceof FieldValueProvider) {
                    FieldValueProvider fieldValueProvider = (FieldValueProvider)dynamicValueProvider;
                    if (fieldValueProvider.getValues() == null) {
                        BaseUtils.warning("could not read dynamic prompt: values - " + String.valueOf(fieldValueProvider.getValues()));
                        return;
                    }
                } else if (dynamicValueProvider instanceof QueryValueProvider && ((queryValueProvider = (QueryValueProvider)dynamicValueProvider).getQuery() == null || queryValueProvider.getDatasource() == null)) {
                    BaseUtils.warning("could not read dynamic query-based prompt: sql - " + queryValueProvider.getQuery() + "; datasource - " + String.valueOf(queryValueProvider.getDatasource()));
                    return;
                }
                this.setDefaultValueProvider(dynamicValueProvider);
            }
            finally {
                parserMap.remove(b.zK.name());
            }
        }
        this.fs();
        super.parseEndElement(group, tag, parserMap);
    }

    @Override
    public void addReferencedObject(ReferencedObject reference) {
        this.qh.addReferencedObject(reference);
    }

    @Override
    public void removeReferencedObject(ReferencedObject reference) {
        this.qh.removeReferencedObject(reference);
    }

    @Override
    public int getReferencedObjectCount() {
        return this.qh.getReferencedObjectCount();
    }

    @Override
    public ReferencedObject[] getReferencedObjects() {
        return this.qh.getReferencedObjects();
    }

    @Override
    public void resetReferences() {
        this.qh.resetReferences();
        if (this.yU != null) {
            for (int i2 = 0; i2 < this.yU.size(); ++i2) {
                FormulaField formulaField;
                DefaultValue defaultValue = this.yU.get(i2);
                if (!(defaultValue instanceof FormulaDefaultValue) || (formulaField = ((FormulaDefaultValue)defaultValue).getUnderlyingFormulaField()) == null) continue;
                formulaField.resetReferences();
            }
        }
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qh.getRealReferencedObjectCount();
    }

    @Override
    public void setReferences() {
        Field field;
        Serializable serializable;
        NodeParser nodeParser;
        DynamicValueProvider dynamicValueProvider = this.getDefaultValueProvider();
        if (dynamicValueProvider != null && dynamicValueProvider instanceof CascadingValueProvider) {
            nodeParser = ((CascadingValueProvider)dynamicValueProvider).getParent();
            ((Field)nodeParser).addReferenceHolder(this);
        }
        if (dynamicValueProvider != null && dynamicValueProvider instanceof FieldValueProvider) {
            nodeParser = (FieldValueProvider)dynamicValueProvider;
            serializable = ((FieldValueProvider)nodeParser).getValues();
            serializable.addReferenceHolder(this);
            field = ((FieldValueProvider)nodeParser).getDescriptions();
            if (field != null) {
                field.addReferenceHolder(this);
            }
        }
        if (this.yU != null) {
            for (int i2 = 0; i2 < this.yU.size(); ++i2) {
                serializable = this.yU.get(i2);
                if (!(serializable instanceof FormulaDefaultValue) || (field = ((FormulaDefaultValue)serializable).getUnderlyingFormulaField()) == null) continue;
                ((FormulaField)field).resetReferences();
                ((FormulaField)field).setReferences();
                field.addReferenceHolder(this);
            }
        }
    }

    @Override
    public Field duplicate(String name) {
        PromptField promptField;
        try {
            promptField = this.bB.getFields().addPromptField(name, this.getPromptText(), this.getPromptType());
            promptField.setAllowMultipleValues(this.getAllowMultipleValues());
            promptField.setDescriptionOnly(this.isDescriptionOnly());
            promptField.setDiscreteOrRangeType(this.getDiscreteOrRangeType());
            promptField.setEditable(this.isEditable());
            promptField.setUseRange(this.getUseRange());
            if (this.getUseRange()) {
                promptField.setMaxRangeValue(this.getMaxRangeValue());
                promptField.setMinRangeValue(this.getMinRangeValue());
            }
            if (this.getDefaultValueProvider() == null) {
                DefaultValue[] defaultValueArray = this.getDefaultValues();
                if (defaultValueArray != null) {
                    for (DefaultValue defaultValue : defaultValueArray) {
                        try {
                            promptField.addDefaultValue((DefaultValue)defaultValue.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            BaseUtils.printStackTrace(cloneNotSupportedException);
                        }
                    }
                }
            } else if (this.yV instanceof QueryValueProvider) {
                QueryValueProvider queryValueProvider = (QueryValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new QueryValueProvider(queryValueProvider.getQuery(), queryValueProvider.getDatasource()));
            } else if (this.yV instanceof CascadingValueProvider) {
                CascadingValueProvider cascadingValueProvider = (CascadingValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new CascadingValueProvider(cascadingValueProvider.getParent(), cascadingValueProvider.getParentSource(), cascadingValueProvider.getValues(), cascadingValueProvider.getDescriptions(), cascadingValueProvider.getSortType()));
            } else if (this.yV instanceof FieldValueProvider) {
                FieldValueProvider fieldValueProvider = (FieldValueProvider)this.getDefaultValueProvider();
                promptField.setDefaultValueProvider(new FieldValueProvider(fieldValueProvider.getValues(), fieldValueProvider.getDescriptions(), fieldValueProvider.getSortType()));
            } else {
                BaseUtils.warning("cannot duplicate default value provider while duplicating " + this.getName() + " - using no default value provider instead...");
            }
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("cannot duplicate prompt field with name " + name, reportException);
        }
        return promptField;
    }

    void a(Evaluable evaluable) {
        this.zj = evaluable;
    }

    public Evaluable getFormulaAst() {
        return this.zj;
    }

    static void a(Object object, int n2, String string, String string2) throws ReportException {
        if (object == null) {
            return;
        }
        switch (n2 %= 128) {
            case 6: 
            case 7: {
                if (object instanceof Number) {
                    return;
                }
                if (object instanceof FormulaRange && (((FormulaRange)object).getFrom() instanceof Number && ((FormulaRange)object).getTo() instanceof Number || ((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getFrom() == null || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                    PromptField.a(((Object[])object)[i2], n2, string, string2);
                }
                return;
            }
            case 8: {
                if (object instanceof Boolean) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof Boolean || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof Boolean || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i3 = 0; i3 < ((Object[])object).length; ++i3) {
                    PromptField.a(((Object[])object)[i3], n2, string, string2);
                }
                return;
            }
            case 9: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i4 = 0; i4 < ((Object[])object).length; ++i4) {
                    PromptField.a(((Object[])object)[i4], n2, string, string2);
                }
                return;
            }
            case 10: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof java.util.Date || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof java.util.Date || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i5 = 0; i5 < ((Object[])object).length; ++i5) {
                    PromptField.a(((Object[])object)[i5], n2, string, string2);
                }
                return;
            }
            case 11: {
                if (object instanceof String) {
                    return;
                }
                if (object instanceof FormulaRange && ((((FormulaRange)object).getFrom() instanceof String || ((FormulaRange)object).getFrom() == null) && ((FormulaRange)object).getTo() instanceof String || ((FormulaRange)object).getTo() == null)) {
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i6 = 0; i6 < ((Object[])object).length; ++i6) {
                    PromptField.a(((Object[])object)[i6], n2, string, string2);
                }
                return;
            }
            case 15: {
                if (object instanceof java.util.Date) {
                    return;
                }
                if (object instanceof FormulaRange) {
                    if ((!(((FormulaRange)object).getFrom() instanceof java.util.Date) && ((FormulaRange)object).getFrom() != null || !(((FormulaRange)object).getTo() instanceof java.util.Date)) && ((FormulaRange)object).getTo() != null) break;
                    return;
                }
                if (!(object instanceof Object[])) break;
                for (int i7 = 0; i7 < ((Object[])object).length; ++i7) {
                    PromptField.a(((Object[])object)[i7], n2, string, string2);
                }
                return;
            }
            case 14: {
                if (!(object instanceof byte[])) break;
                return;
            }
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.WrongPromptData, string, object, object.getClass().getName(), string2);
    }

    public void copySPParametersTo(PromptField toField) {
        if (this.yW != null) {
            toField.yW = this.yW;
        }
        if (this.yX != null) {
            try {
                TableSource tableSource = toField.bB.getDbTables().getTablesource(this.yX.getAlias());
                if (tableSource != null) {
                    toField.yX = tableSource;
                }
            }
            catch (ReportException reportException) {
                BaseUtils.warning(reportException);
            }
        }
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a zl = new a();
        public static final /* enum */ a zm = new a();
        public static final /* enum */ a zn = new a();
        public static final /* enum */ a zo = new a();
        public static final /* enum */ a zp = new a();
        public static final /* enum */ a zq = new a();
        public static final /* enum */ a zr = new a();
        public static final /* enum */ a zs = new a();
        public static final /* enum */ a zt = new a();
        public static final /* enum */ a zu = new a();
        public static final /* enum */ a zv = new a();
        public static final /* enum */ a zw = new a();
        public static final /* enum */ a zx = new a();
        public static final /* enum */ a zy = new a();
        public static final /* enum */ a zz = new a();
        public static final /* enum */ a zA = new a();
        public static final /* enum */ a zB = new a();
        public static final /* enum */ a zC = new a();
        public static final /* enum */ a zD = new a();
        public static final /* enum */ a zE = new a();
        public static final /* enum */ a zF = new a();
        public static final /* enum */ a zG = new a();
        public static final /* enum */ a zH = new a();
        private static final /* synthetic */ a[] zI;

        public static a[] values() {
            return (a[])zI.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] ft() {
            return new a[]{zl, zm, zn, zo, zp, zq, zr, zs, zt, zu, zv, zw, zx, zy, zz, zA, zB, zC, zD, zE, zF, zG, zH};
        }

        static {
            zI = a.ft();
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b zJ = new b();
        public static final /* enum */ b zK = new b();
        private static final /* synthetic */ b[] zL;

        public static b[] values() {
            return (b[])zL.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] fu() {
            return new b[]{zJ, zK};
        }

        static {
            zL = b.fu();
        }
    }
}

