/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.graphics.GraphicsBase;
import com.inet.graphics.encode.PNGEncoder;
import com.inet.lib.util.ColorUtils;
import com.inet.report.BaseUtils;
import com.inet.report.svg.SVGUtils;
import com.inet.shared.utils.MemoryStream;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;

@InternalApi
public class GraphicsSVG
extends GraphicsBase {
    private MemoryStream sj;
    private MemoryStream sk;
    private boolean sl;

    public GraphicsSVG(MemoryStream outSec) {
        this(outSec, null);
    }

    public GraphicsSVG(MemoryStream outSec, AffineTransform transform) {
        this.sk = outSec;
        this.sj = new MemoryStream();
        AffineTransform affineTransform = transform != null ? transform : AffineTransform.getScaleInstance(15.0, 15.0);
        SVGUtils.writeStartTransform(this.sj, affineTransform);
    }

    public void copyArea(int x2, int y2, int width, int height, int dx, int dy) {
        GraphicsSVG.notSupported((String)"copyArea(int,int,int,int,int,int)");
    }

    public Graphics create() {
        GraphicsSVG.notSupported((String)"create()");
        return this;
    }

    public void dispose() {
        if (!this.sl) {
            this.sl = true;
            SVGUtils.writeEndTransform(this.sj);
            this.sk.write(this.sj.toByteArray());
        }
    }

    public void draw(Shape shape) {
        this.fill(this.getStroke().createStrokedShape(shape));
    }

    public void drawArc(int x2, int y2, int w2, int h2, int startAngle, int angleExtent) {
        Arc2D.Double double_ = new Arc2D.Double(x2, y2, w2, h2, startAngle, angleExtent, 0);
        this.draw(double_);
    }

    public void drawGlyphVector(GlyphVector glyphs, float x2, float y2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(x2, y2);
        Shape shape = affineTransform.createTransformedShape(glyphs.getOutline());
        this.fill(shape);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x2, int y2) {
        this.drawImage((Image)img, x2, y2, null);
    }

    public boolean drawImage(Image img, AffineTransform tx, ImageObserver observer) {
        int n2;
        int n3 = img.getWidth(null);
        int n4 = n2 = img.getHeight(null);
        int n5 = n3;
        if (n3 != -1 && n2 != -1) {
            byte[] byArray;
            try {
                byArray = PNGEncoder.getPNGImageData((Image)img, (int)n3, (int)n2, (ImageObserver)observer);
            }
            catch (Throwable throwable) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(throwable);
                }
                byArray = null;
            }
            AffineTransform affineTransform = this.getTransform();
            affineTransform.concatenate(tx);
            SVGUtils.writeStartTransform(this.sj, affineTransform);
            SVGUtils.writeImage(this.sj, byArray, null, 0, 0, n5, n4);
            SVGUtils.writeEndTransform(this.sj);
            return byArray != null;
        }
        return false;
    }

    public boolean drawImage(Image img, int x2, int y2, Color color, ImageObserver observer) {
        return this.a(img, x2, y2, img.getWidth(observer), img.getHeight(observer));
    }

    public boolean drawImage(Image img, int x2, int y2, ImageObserver observer) {
        return this.a(img, x2, y2, img.getWidth(observer), img.getHeight(observer));
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, Color arg5, ImageObserver arg6) {
        return this.a(img, dx1, dy1, dx2, dy2);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, ImageObserver arg5) {
        return this.a(img, dx1, dy1, dx2, dy2);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color arg9, ImageObserver arg10) {
        return this.a(img, dx1, dy1, dx2, dy2);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver arg9) {
        return this.a(img, dx1, dy1, dx2, dy2);
    }

    private boolean a(Image image, int n2, int n3, int n4, int n5) {
        if (n4 != -1 && n5 != -1) {
            byte[] byArray;
            try {
                byArray = PNGEncoder.getPNGImageData((Image)image, (int)n4, (int)n5, null);
            }
            catch (Throwable throwable) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(throwable);
                }
                byArray = null;
            }
            SVGUtils.writeStartTransform(this.sj, this.getInternalTransform());
            SVGUtils.writeImage(this.sj, byArray, null, n2, n3, n4, n5);
            SVGUtils.writeEndTransform(this.sj);
            return byArray != null;
        }
        return false;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double double_ = new Line2D.Double(x1, y1, x2, y2);
        this.draw(double_);
    }

    public void drawOval(int x2, int y2, int w2, int h2) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(x2, y2, w2, h2);
        this.draw(double_);
    }

    public void drawPolygon(int[] xCoords, int[] yCoords, int nPoints) {
        Polygon polygon = new Polygon(xCoords, yCoords, nPoints);
        this.draw(polygon);
    }

    public void drawPolyline(int[] xCoords, int[] yCoords, int nPoints) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(xCoords[0], yCoords[0]);
        for (int i2 = 1; i2 < nPoints; ++i2) {
            generalPath.lineTo(xCoords[i2], yCoords[i2]);
        }
        this.draw(generalPath);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform tx) {
        this.drawRenderedImage(img.createDefaultRendering(), tx);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform tx) {
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        bufferedImage.setData(img.getData());
        this.drawImage(bufferedImage, tx, null);
    }

    public void drawRoundRect(int x2, int y2, int w2, int h2, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(x2, y2, w2, h2, arcWidth, arcHeight);
        this.draw(double_);
    }

    public void drawString(AttributedCharacterIterator arg0, float x2, float y2) {
        this.drawString(arg0.toString(), x2, y2);
    }

    public void drawString(AttributedCharacterIterator arg0, int x2, int y2) {
        this.drawString(arg0.toString(), x2, y2);
    }

    public void drawString(String string, float x2, float y2) {
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(x2, y2);
        SVGUtils.writeStartTransform(this.sj, affineTransform);
        SVGUtils.writeRotateString(this.sj, string, 0, 0, 0, this.getFont(), ColorUtils.toCcColor((Color)this.getColor()));
        SVGUtils.writeEndTransform(this.sj);
    }

    public void drawString(String string, int x2, int y2) {
        this.drawString(string, (float)x2, (float)y2);
    }

    public void fill(Shape shape) {
        Area area = new Area(shape);
        area.transform(this.getInternalTransform());
        Shape shape2 = this.getCompositeClip();
        if (shape2 != null) {
            area.intersect(new Area(shape2));
        }
        if (!area.isEmpty()) {
            SVGUtils.writePath(this.sj, area.getPathIterator(null), this.getPaint(), null);
        }
    }

    public void fillArc(int x2, int y2, int w2, int h2, int startAngle, int angleExtent) {
        Arc2D.Double double_ = new Arc2D.Double(x2, y2, w2, h2, startAngle, angleExtent, 2);
        this.fill(double_);
    }

    public void fillOval(int x2, int y2, int w2, int h2) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(x2, y2, w2, h2);
        this.fill(double_);
    }

    public void fillPolygon(int[] xCoords, int[] yCoords, int nPoints) {
        Polygon polygon = new Polygon(xCoords, yCoords, nPoints);
        this.fill(polygon);
    }

    public void fillRect(int x2, int y2, int w2, int h2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(x2, y2, w2, h2);
        this.fill(double_);
    }

    public void fillRoundRect(int x2, int y2, int w2, int h2, int arcWidth, int arcHeight) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(x2, y2, w2, h2, arcWidth, arcHeight);
        this.fill(double_);
    }

    public void setPaint(Paint paint) {
        if (paint instanceof Color || paint instanceof GradientPaint || paint instanceof LinearGradientPaint || paint instanceof RadialGradientPaint) {
            super.setPaint(paint);
        } else {
            GraphicsSVG.notSupported((String)"Paint other than Color or Gradient Paint");
        }
    }

    protected void setTransformImpl(AffineTransform tx) {
    }

    protected void transformImpl(AffineTransform tx) {
    }
}

