/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.CrossTab;
import com.inet.report.CrossTabBodyCell;
import com.inet.report.CrossTabHeader;
import com.inet.report.CrossTabHeaderList;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SummaryField;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.m;
import com.inet.report.parser.NodeParser;
import com.inet.report.y;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class CrossTabBody
implements Serializable {
    private final CrossTab je;
    private final List<CrossTabBodyCell> jf;
    private final List<SummaryField> jg;

    CrossTabBody(@Nonnull CrossTab crossTab) {
        this.je = crossTab;
        this.jf = new ArrayList<CrossTabBodyCell>();
        this.jg = new ArrayList<SummaryField>();
    }

    public int getCellCount() {
        return this.jf.size();
    }

    public void removeSummaryField(int index) throws ReportException {
        if (index >= this.jg.size()) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.elementNotFound, new Object[0]);
        }
        if (index < 0) {
            throw y.a("index", index, null);
        }
        SummaryField summaryField = this.jg.remove(index);
        for (int i2 = 0; i2 < this.jf.size(); ++i2) {
            this.jf.get(i2).remove(index);
        }
        summaryField.getField().removeReferenceHolder(this.je);
        this.je.aR().bd();
        this.je.aR().be();
    }

    public void moveSummaryField(int from, int to) {
        if (from >= this.jg.size()) {
            throw y.a(from, "from", null);
        }
        if (to >= this.jg.size()) {
            throw y.a(to, "to", null);
        }
        if (from < 0) {
            throw y.a("from", from, null);
        }
        if (to < 0) {
            throw y.a("to", to, null);
        }
        this.jg.add(to, this.jg.remove(from));
        for (int i2 = 0; i2 < this.jf.size(); ++i2) {
            this.jf.get(i2).move(from, to);
        }
        this.je.aR().bd();
        this.je.aR().be();
    }

    @Nonnull
    public SummaryField getSummaryField(int index) {
        return this.jg.get(index);
    }

    public int getSummaryFieldsCount() {
        return this.jg.size();
    }

    public SummaryField addSummaryField(@Nonnull Field field, int operation) {
        SummaryField summaryField = new SummaryField(this.je.bB);
        summaryField.setName(field.getName());
        summaryField.setField(field);
        summaryField.setSummaryOperation(operation);
        summaryField.setSummaryFieldType(1);
        this.addSummaryField(summaryField);
        return summaryField;
    }

    void addSummaryField(@Nonnull SummaryField summaryField) {
        this.jg.add(summaryField);
        for (int i2 = 0; i2 < this.jf.size(); ++i2) {
            this.jf.get(i2).b(summaryField);
        }
        this.je.aR().bd();
        this.je.aR().be();
        Field field = summaryField.getField();
        if (field != null) {
            field.removeReferenceHolder(summaryField);
            field.addReferenceHolder(this.je);
        }
    }

    void aX() {
        if (this.jf.size() > 0) {
            CrossTabBodyCell crossTabBodyCell = this.jf.get(0);
            for (int i2 = this.jg.size(); i2 < crossTabBodyCell.getFieldElementCount(); ++i2) {
                this.jg.add((SummaryField)crossTabBodyCell.getFieldElement(i2).getField());
            }
        }
    }

    void setReferences() {
        NodeParser nodeParser;
        int n2;
        this.aX();
        for (n2 = 0; n2 < this.jg.size(); ++n2) {
            nodeParser = this.jg.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().addReferenceHolder(this.je);
            }
            if (((SummaryField)nodeParser).getField2nd() == null) continue;
            ((SummaryField)nodeParser).getField2nd().addReferenceHolder(this.je);
        }
        for (n2 = 0; n2 < this.jf.size(); ++n2) {
            nodeParser = this.jf.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).setReferences();
            }
        }
    }

    void resetReferences() {
        NodeParser nodeParser;
        int n2;
        for (n2 = 0; n2 < this.jg.size(); ++n2) {
            nodeParser = this.jg.get(n2);
            if (((Field)nodeParser).getField() != null) {
                ((Field)nodeParser).getField().removeReferenceHolder(this.je);
            }
            ((SummaryField)nodeParser).resetReferences();
        }
        for (n2 = 0; n2 < this.jf.size(); ++n2) {
            nodeParser = this.jf.get(n2);
            for (int i2 = 0; i2 < ((CrossTabBodyCell)nodeParser).getFieldElementCount(); ++i2) {
                ((CrossTabBodyCell)nodeParser).getFieldElement(i2).resetReferences();
            }
        }
    }

    public CrossTabBodyCell getCell(int idx) {
        return this.jf.get(idx);
    }

    @Nonnull
    public CrossTabBodyCell getCell(int rowIdx, int columnIdx) {
        CrossTabHeader crossTabHeader = this.je.getRows().get(rowIdx);
        CrossTabHeader crossTabHeader2 = this.je.getColumns().get(columnIdx);
        int n2 = this.jf.size() - rowIdx - columnIdx * this.je.getRows().size() - 1;
        CrossTabBodyCell crossTabBodyCell = this.jf.get(n2);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        Collections.sort(this.jf, new a(this.je));
        crossTabBodyCell = this.jf.get(n2);
        if (crossTabBodyCell.getRow() == crossTabHeader && crossTabBodyCell.getColumn() == crossTabHeader2) {
            return crossTabBodyCell;
        }
        throw new IllegalStateException("Cell not found: " + rowIdx + ", " + columnIdx);
    }

    @Nonnull
    CrossTabBodyCell aY() {
        return this.a(this.jf.size(), null, null);
    }

    void a(@Nullable CrossTabHeader crossTabHeader) {
        for (int i2 = 0; i2 < this.jf.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.jf.get(i2);
            if (crossTabBodyCell.getRow() != crossTabHeader && crossTabBodyCell.getColumn() != crossTabHeader) continue;
            this.jf.remove(i2);
            --i2;
        }
    }

    void b(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.je.getColumns();
        int n2 = crossTabHeaderList.size();
        int n3 = this.je.getRows().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a((i2 + 1) * n3 - 1, crossTabHeader, crossTabHeader2);
        }
    }

    void c(@Nonnull CrossTabHeader crossTabHeader) {
        CrossTabHeaderList crossTabHeaderList = this.je.getRows();
        int n2 = crossTabHeaderList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CrossTabHeader crossTabHeader2 = crossTabHeaderList.get(i2);
            this.a(this.jf.size(), crossTabHeader2, crossTabHeader);
        }
    }

    @Nonnull
    private CrossTabBodyCell a(int n2, @Nullable CrossTabHeader crossTabHeader, @Nullable CrossTabHeader crossTabHeader2) {
        CrossTabBodyCell crossTabBodyCell = new CrossTabBodyCell(this.je, crossTabHeader, crossTabHeader2);
        this.jf.add(n2, crossTabBodyCell);
        if (crossTabHeader != null && crossTabHeader2 != null) {
            int n3 = this.jg.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                crossTabBodyCell.b(this.jg.get(i2));
            }
        }
        return crossTabBodyCell;
    }

    int b(@Nullable Element element) {
        for (int i2 = this.jf.size() - 1; i2 >= 0; --i2) {
            CrossTabBodyCell crossTabBodyCell = this.jf.get(i2);
            for (int i3 = crossTabBodyCell.getFieldElementCount() - 1; i3 >= 0; --i3) {
                if (element != crossTabBodyCell.getFieldElement(i3)) continue;
                return i2;
            }
        }
        return -1;
    }

    void aZ() {
        m m2 = this.je.aR();
        for (int i2 = 0; i2 < this.jf.size(); ++i2) {
            CrossTabBodyCell crossTabBodyCell = this.jf.get(i2);
            int n2 = crossTabBodyCell.getFieldElementCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                crossTabBodyCell.getFieldElement(i3).addPropertyChangeListener(m2);
            }
        }
    }

    private static class a
    implements Comparator<CrossTabBodyCell> {
        private final CrossTabHeaderList in;
        private final CrossTabHeaderList im;

        private a(@Nonnull CrossTab crossTab) {
            this.in = crossTab.getRows();
            this.im = crossTab.getColumns();
        }

        public int a(CrossTabBodyCell crossTabBodyCell, CrossTabBodyCell crossTabBodyCell2) {
            int n2;
            int n3 = this.im.g(crossTabBodyCell.getColumn());
            if (n3 == (n2 = this.im.g(crossTabBodyCell2.getColumn()))) {
                int n4;
                int n5 = this.in.g(crossTabBodyCell.getRow());
                return n5 < (n4 = this.in.g(crossTabBodyCell2.getRow())) ? 1 : (n5 == n4 ? 0 : -1);
            }
            return n3 < n2 ? 1 : -1;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((CrossTabBodyCell)object, (CrossTabBodyCell)object2);
        }
    }
}

