/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.bx;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.renderer.java.e;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.archive.search.SearchHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

@PublicApi
public class CacheRenderData
implements RenderData {
    private final Cache hn;
    private final Properties ho = new Properties();
    private final PropertiesChecker hp;
    private final Object hq;
    private Properties hr = new Properties();
    private String hs;
    private String url;
    private ReportCacheKey ht;
    private int hu = 1;
    private boolean hv;

    public CacheRenderData(String url, PropertiesChecker checker, Object req) {
        this.hn = Cache.getCache();
        this.setReportLocation(url);
        this.hp = checker;
        this.hq = req;
    }

    public CacheRenderData(Properties props, PropertiesChecker checker, Object req) {
        this.hn = Cache.getCache();
        this.ho.putAll((Map<?, ?>)props);
        this.hp = checker;
        this.hq = req;
    }

    @Override
    public void setReportTitle(String title) {
        this.hs = title;
    }

    @Override
    public String getReportTitle() {
        return this.hs;
    }

    @Override
    public void setReportLocation(String name) {
        this.ho.clear();
        bx.b(name, this.ho, false);
        try {
            ReportKeyFactory.decodeProps(this.ho);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + String.valueOf(throwable));
        }
        this.url = name;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    private void ak() throws ViewerException {
        this.ho.put("export_fmt", "java");
        try {
            this.ht = this.getKey(this.ho);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
    }

    protected ReportCacheKey getKey(Properties props) throws ReportException {
        return this.hn.getKey(props, this.hp, this.getEngineFactory(), this.hq);
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        this.ak();
        try {
            return this.hn.getPageAndWait(this.ht, page, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        this.ak();
        try {
            return this.hn.getPageCountAndWait(this.ht, 600000);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public boolean isPageLimitExceeded() {
        this.ak();
        try {
            return this.hn.isPageLimitExceeded(this.ht);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string = this.hr.getProperty("export_fmt");
            if (string.equals("svg")) {
                if (this.hu == 0) {
                    ++this.hu;
                    String string2 = this.hr.getProperty("file");
                    string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                    int n2 = SVGUtils.getAutoRefresh(this.hr);
                    return SVGUtils.getSvgViewerPackage(-1, true, string2, n2);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, this.hu + ".svg", this.hn.getPageAndWait(this.ht, this.hu++, 600000));
                return byteArrayOutputStream.toByteArray();
            }
            if (this.hu >= 0) {
                return this.hn.getPageAndWait(this.ht, this.hu++, 600000);
            }
            ++this.hu;
            if (string.startsWith("htm")) {
                String string3 = this.hr.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, string3, RenderDataUtils.getHtmlViewerData());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            BaseUtils.error("Chunk " + this.hu + " out of range...");
            BaseUtils.printStackTrace(pageOutOfRangeException);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            BaseUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IOException iOException) {
            BaseUtils.printStackTrace(iOException);
        }
        return null;
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        this.hr = bx.a(this.ho, expProps);
        try {
            this.ht = this.getKey(this.hr);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        try {
            int n2;
            String string = expProps.getProperty("export_fmt");
            if (string.equals("svg")) {
                this.hu = 0;
                n2 = this.hn.getPageCountAndWait(this.ht, 600000) + 1;
            } else if (string.startsWith("htm")) {
                this.hu = -1;
                n2 = this.hn.getPageCountAndWait(this.ht, 600000) + 2;
            } else {
                this.hu = 1;
                n2 = this.hn.getPageCountAndWait(this.ht, 600000);
            }
            Throwable throwable = this.hn.getFailureCause(this.ht);
            if (throwable != null) {
                throw ViewerException.createViewerException(throwable);
            }
            return n2;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return -1;
    }

    protected EngineFactory getEngineFactory() {
        return Cache.getEngineFactory();
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        this.ak();
        try {
            return this.hn.getGroupTreeAndWait(this.ht, -1, 3, 600000);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        if (this.hv) {
            this.ho.put("promptonrefresh", "1");
        }
        return this.getPageData(page);
    }

    @Override
    public void setReportProperty(String key, String value) {
        if (value == null) {
            this.ho.remove(key);
        } else {
            this.ho.setProperty(key, value);
        }
    }

    @Override
    public String getReportProperty(String propertyKey) {
        return this.ho.getProperty(propertyKey);
    }

    @Override
    public Properties getProperties() {
        return this.ho;
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.hv = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hv;
    }

    @Override
    public RenderData getCopy() {
        return new CacheRenderData(this.url, this.hp, this.hq);
    }

    @Override
    public void stop() {
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        try {
            return new SearchHandler(this).search(phrase, startPage, flags);
        }
        catch (ViewerException viewerException) {
            return e.getErrorData(viewerException, this.ho);
        }
    }

    @Override
    public byte[] getFontData(int fontID) {
        try {
            return this.hn.getPageAndWait(this.ht, -fontID, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        Properties properties = (Properties)this.ho.clone();
        try {
            this.ht = this.hn.createKey(properties, this.hp, this.hq);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        if (!this.hn.exists(this.ht)) {
            throw new ViewerException("report is no longer in the cache. You should not see this error.");
        }
        this.hn.resetCacheTimeout(this.ht);
    }
}

