clearreportsApp.run(function($rootScope, driveModel, driveFactory, actionservice ) {
    var renderEntry = function( entry, format ){
        var driveURL = driveFactory.getEntryURL( entry.id );
        var roothref = $('base').attr("roothref");
        var url = roothref + 'report?report=' + encodeURIComponent(driveURL);
        if( format ) {
            url = url + "&init=" + format;
        }
        var newWin = window.open( url, '_blank');
        return newWin;
    }
    
    var availableFormats = angular.fromJson( [[AVAILABLE_FORMATS]] );
    var checkEnabledSingle = function( entry ){ return entry.type == "CONTENT" && entry.name.toLowerCase().endsWith( ".rpt" ) };
    
    var drilldownSingle = [];
    var keys = Object.keys(availableFormats);
    for( var i=0; i<keys.length; i++ ) {
        (function(key, isDefault){            
            var formatAction = {
                key: "reporting.render." + key,
                icon: "icon-" + key.replace(".","-"),
                name: availableFormats[key] + (isDefault? " " + getMsg("reporting.drive.action.default") : ""),
                single:{
                    tooltip: "",
                    action: function( entry ){
                        var newWin = renderEntry( entry, key );
                        if (newWin != undefined) {
                            newWin.focus();
                        }
                    },
                    checkEnabled: checkEnabledSingle
                },    
            };
            drilldownSingle.push( formatAction );
        })(keys[i],i==0);
    }
    
    var drilldownMulti = [];
    var keys = Object.keys(availableFormats);
    var defaultName = availableFormats[keys[0]];
    for( var i=0; i<keys.length; i++ ) {
        (function(key,isDefault){            
            var formatAction = {
                key: "reporting.render.multi." + key,
                icon: "icon-" + key.replace(".","-"),
                name: availableFormats[key] + (isDefault? " " + getMsg("reporting.drive.action.default") : ""),
                multi:{
                    tooltip: function() { return "" },
                    action: function( entry ){
                        var entries = driveModel.getSelectedEntries();
                        var newWin;
                        for( var i=0; i<entries.length; i++ ) {
                            newWin = renderEntry( entries[i], key );
                            if (newWin != undefined) {
                                newWin.focus();
                            }
                        }
                    },
                    checkEnabled: function(){
                        var entries = driveModel.getSelectedEntries();
                        if( entries.length != 1 ) {
                            return false;
                        }
                        for( var i=0; i<entries.length; i++ ) {
                            if( !checkEnabledSingle( entries[i] ) ) {
                                return false;
                            }
                        }
                        return true;
                    }
                },    
            };
            drilldownMulti.push( formatAction);
        })(keys[i],i==0 );
    }
    
    var actionRenderReport = {
        key: "reporting.render",
        icon: "icon-cr-render",
        name: $rootScope.getMsg("reporting.drive.action.render"),
        single:{
            tooltip: "",
            action: function( entry ){
                var newWin = renderEntry( entry );
                if (newWin != undefined) {
                    newWin.focus();
                }
            },
            checkEnabled: checkEnabledSingle,
            drilldown: drilldownSingle
        },
        multi:{
            tooltip: function(){
                return $rootScope.getMsg("reporting.drive.action.render.to", defaultName);
            },
            action: function(){
                var entries = driveModel.getSelectedEntries();
                var newWin;
                for( var i=0; i<entries.length; i++ ) {
                    newWin = renderEntry( entries[i] );
                    if (newWin != undefined) {
                        newWin.focus();
                    }
                }
            },
            checkEnabled: function(){ 
                if( driveModel.selectedIDs.size == 0 ) {
                    return false;
                }
                var entries = driveModel.getSelectedEntries();
                for( var i=0; i<entries.length; i++ ) {
                    var entry =  entries[i];
                    if( entry.type != "CONTENT" || !entry.name.toLowerCase().endsWith( ".rpt" ) ) {
                        return false;
                    }
                }
                return true;
            },
            drilldown: drilldownMulti
        },
    }
    actionservice.registerAction( actionRenderReport, actionservice.ACTION_TYPE.MIME );
});