/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.doc;

import com.inet.annotations.InternalApi;
import com.inet.report.ReportException;
import com.inet.report.output.DocumentOutput;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.DocumentWriter;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class AbstractDocumentWriter
implements DocumentWriter {
    private DocumentOutput nO;
    private int yB;
    private DocumentMetaData aCG;
    private Properties Vd;
    protected static final int STATE_BEFORE_PAGE = 1;
    protected static final int STATE_IN_PAGE = 2;
    protected static final int STATE_DOC_END = 5;

    @Override
    public void setOutput(DocumentOutput pages) throws ReportException {
        if (pages == null) {
            throw new IllegalArgumentException("parameter pages is null");
        }
        if (this.nO != null) {
            throw new IllegalStateException("pages already set");
        }
        this.nO = pages;
        this.yB = 1;
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        this.Vd = props;
        this.checkState(1);
    }

    @Override
    public void setMetaData(@Nonnull DocumentMetaData metaData) {
        this.aCG = metaData;
        this.checkState(1);
    }

    protected DocumentMetaData getMetaData() {
        return this.aCG;
    }

    protected Properties getProperties() {
        return this.Vd;
    }

    @Override
    public void setSheetName(String sheetName) {
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        this.checkState(1);
    }

    @Override
    public void setColumnWidths(int[] widths) {
    }

    @Override
    public void startDocument() throws ReportException {
        this.checkState(1);
    }

    @Override
    public void startPage() throws ReportException {
        this.checkState(1);
        this.yB = 2;
    }

    @Override
    public void endPage() throws ReportException {
        this.checkState(2);
        this.yB = 1;
    }

    @Override
    public void endDocument() throws ReportException {
        this.checkState(1);
        this.yB = 5;
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data) {
    }

    protected void checkState(int neededState) throws IllegalStateException {
        if (this.yB != neededState) {
            throw new IllegalStateException("method is called in an invalid state: " + this.yB);
        }
    }

    protected DocumentOutput getPages() {
        return this.nO;
    }

    @Override
    public void clean() {
    }
}

