/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula;

import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.formula.IFormulaData;
import com.inet.report.formula.j;
import com.inet.report.formula.m;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;

public class FormulaException
extends ReportException {
    private m aix;
    private String aiy;
    private int aiz;

    protected FormulaException(String msg, int messageId) {
        super(msg, messageId);
    }

    public FormulaException(String msg, int messageId, m position) {
        super(msg, messageId);
        this.aix = position;
    }

    public FormulaException(ReportException e2, m position) {
        super(e2.getMessage(), e2.getErrorCode());
        super.initCause(e2);
        this.aix = position;
    }

    public static FormulaException create(ReportErrorCode idAsString, m position, Object ... msgParameter) {
        String string = idAsString.name();
        int n2 = idAsString.getErrorCodeNumber();
        string = Msg.getMsg(string, msgParameter);
        FormulaException formulaException = new FormulaException(string, n2);
        formulaException.aix = position;
        return formulaException;
    }

    public int getRow() {
        if (this.aix != null) {
            return this.aix.getLine();
        }
        return -1;
    }

    public int getColumn() {
        if (this.aix != null) {
            return this.aix.getColumn();
        }
        return -1;
    }

    public int getEndRow() {
        if (this.aix != null) {
            return this.aix.qe();
        }
        return -1;
    }

    public int getEndColumn() {
        if (this.aix != null) {
            return this.aix.getEndColumn();
        }
        return -1;
    }

    public int getStartIndex() {
        if (this.aix != null) {
            return this.aix.getStartIndex();
        }
        return -1;
    }

    public int getLength() {
        if (this.aix != null) {
            return this.aix.getLength();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (this.aiy != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Msg.getMsg(this.aiz == 0 ? "InFormula" : "InFunction", super.getMessage(), this.aiy));
            if (this.aix != null) {
                stringBuilder.append(", ");
                stringBuilder.append(Msg.getMsg("FormulaError.Position", this.aix.getLine() + 1, this.aix.getColumn() + 1));
            }
            return stringBuilder.toString();
        }
        return super.getMessage();
    }

    public void setFormulaField(j formula) {
        if (formula != null) {
            this.setFormulaField(formula.pe());
        }
    }

    public void setFormulaField(IFormulaData formulaField) {
        if (formulaField != null && formulaField.getName() != null) {
            this.aiy = formulaField.getName();
            this.aiz = formulaField instanceof FormulaField ? 0 : 1;
        }
    }

    public void setFormulaName(String name) {
        if (this.aiy == null) {
            this.aiy = name;
        }
    }

    public void setPosition(m position) {
        this.pT();
        this.aix = position;
    }

    public m getPosition() {
        return this.aix;
    }

    protected void pT() {
    }

    public String getCausingFormulaName() {
        return this.aiy;
    }
}

