/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.weblog;

import com.inet.annotations.InternalApi;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.RelativePathDataFactory;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.csvdata.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DatabaseWeblog
extends RelativePathDataFactory {
    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return super.getTableSourceInfos(ds, catalog, string -> {
            int n2 = string.length() - 4;
            if (string.endsWith(".log") && string.lastIndexOf(46, n2 - 1) < 0) {
                return string.substring(0, n2);
            }
            if (string.endsWith(".csv")) {
                return string;
            }
            return null;
        });
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file name generated for the log file")
    private InputStream g(@Nonnull TableSource tableSource) throws Exception {
        Datasource datasource = tableSource.getDatasource();
        Object object = tableSource.getDatabaseIdentifier();
        if (((String)object).indexOf(46) < 0) {
            object = (String)object + ".log";
        }
        File file = null;
        List<String> list = this.getPathNames(datasource);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            File file2 = new File(list.get(i2), (String)object);
            if (!file2.exists()) continue;
            file = file2;
            break;
        }
        if (file == null) {
            file = new File(list.get(0), (String)object);
        }
        return new FileInputStream(file);
    }

    @Override
    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        List<ColumnInfo> list;
        block8: {
            InputStream inputStream = this.g(ts);
            try {
                list = new h(inputStream).getColumns();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw ReportExceptionFactory.createReportExceptionWithCause(exception);
                }
            }
            inputStream.close();
        }
        return list;
    }

    @Override
    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        try {
            InputStream inputStream = this.g(ts);
            return new TableData(new h(inputStream).getResultSet());
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    @Override
    public boolean getReportDataPerInstance() {
        return true;
    }
}

