/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.annotations.PublicApi;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.TableData;
import com.inet.report.database.fetch.DataCollector;
import com.inet.report.database.fetch.FetchTables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public abstract class BaseDataFactory
implements DataFactory {
    private DatabaseConfiguration abv = DatabaseConfiguration.getDefault();

    protected BaseDataFactory() {
    }

    @Override
    public boolean getReportDataPerInstance() {
        return false;
    }

    @Override
    public DatabaseConfiguration getConfiguration() {
        return this.abv;
    }

    @Override
    public void setConfiguration(@Nonnull DatabaseConfiguration configuration) {
        this.abv = configuration;
    }

    @Override
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        DatabaseField[] databaseFieldArray;
        ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>();
        for (DatabaseField databaseField : databaseFieldArray = ts.getDatabaseFields()) {
            if (databaseField.getReferenceHolderCount() <= 0) continue;
            arrayList.add(databaseField);
        }
        return this.getTableSourceData(ts, arrayList);
    }

    protected TableData getTableSourceData(@Nonnull TableSource ts, @Nonnull List<DatabaseField> columns) throws ReportException {
        throw new ReportException("You need to implement getTableSourceData", 0);
    }

    @Override
    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        String[] stringArray = DatabaseUtils.parseSourceName(this.getConfiguration(), ts.getDatabaseIdentifier());
        return this.getColumns(ts.getDatasource(), stringArray[0], stringArray[1], stringArray[2], ts.getType());
    }

    @Nonnull
    protected List<ColumnInfo> getColumns(@Nonnull Datasource datasource, String catalog, String schema, String name, int type) throws ReportException {
        throw new ReportException("You need to implement getColumns", 0);
    }

    @Override
    public void fetchData(Engine engine, FetchTables fetchTables, DataCollector collector) throws ReportException {
        for (TableSource tableSource : fetchTables.getTableSources()) {
            collector.addUnjoinedData(tableSource, this.getTableSourceData(tableSource));
        }
    }
}

