/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache.store;

import com.inet.annotations.PublicApi;
import com.inet.cache.StoreMap;
import com.inet.classloader.ObjectStreams;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cache.store.a;
import com.inet.report.cache.store.b;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;

@PublicApi
public class CachedOutput
implements DocumentOutput,
Comparable<CachedOutput> {
    private final long VI = System.currentTimeMillis();
    private final ReportCacheKey ht;
    private ReportGenerator VJ;
    private int VD;
    private int VK;
    private int VL;
    private byte VM;
    private boolean VN;
    private boolean VO;
    private long VP;
    private String VQ;

    public CachedOutput(ReportCacheKey key, ReportGenerator engine) {
        this.ht = key;
        this.VJ = engine;
    }

    @Override
    public int getPageCount() {
        return this.VD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aF(String string) {
        StoreMap<a, byte[]> storeMap = b.VU;
        synchronized (storeMap) {
            this.stop(string);
            this.ld();
        }
    }

    private void ld() {
        for (int i2 = -this.VK; i2 <= this.VD; ++i2) {
            b.VU.remove((Object)new a(this.ht, i2));
        }
        this.VL = 0;
        this.VD = 0;
        this.VK = 0;
        this.VJ = null;
    }

    @Override
    public void clear() {
        this.ld();
        this.VM = 0;
        this.VQ = null;
    }

    @Override
    public byte[] getPageData(int idx) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = (byte[])b.VU.get((Object)new a(this.ht, idx));
        if (byArray == null) {
            this.F(idx, this.VD);
        }
        return byArray;
    }

    private void F(int n2, int n3) {
        byte[] byArray;
        if (this.VM == 3 && (byArray = (byte[])b.VU.get((Object)new a(this.ht, 1))) != null) {
            Throwable throwable = null;
            try {
                ObjectStreams.CacheObjectInputStream cacheObjectInputStream = new ObjectStreams.CacheObjectInputStream((InputStream)new ByteArrayInputStream(byArray));
                throwable = (Throwable)cacheObjectInputStream.readObject();
                cacheObjectInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (throwable != null) {
                ErrorCode.throwAny(throwable);
            }
        }
        ErrorCode.throwAny((Throwable)new PageOutOfRangeException(n2, n3, this.VQ));
    }

    @Override
    public byte[] getGroupTree() {
        return (byte[])b.VU.get((Object)new a(this.ht, 0));
    }

    @Override
    public void addPage(byte[] page) throws IllegalStateException {
        if (this.a("addPage()", this.VD + 1, page, 0)) {
            ++this.VD;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("addPage:" + this.VD);
            }
        }
    }

    @Override
    public void setPageData(byte[] page, int idx) throws IllegalStateException {
        this.a("setPageData()", idx, page, 0);
    }

    @Override
    public void setGroupTree(byte[] data) throws IllegalStateException {
        this.a("setGroupTree()", 0, data, 2);
    }

    @Override
    public void setErrorData(byte[] error) throws IllegalStateException {
        this.a("setErrorData()", 1, error, 3);
        if (this.VD == 0) {
            this.VD = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String cause) {
        StoreMap<a, byte[]> storeMap = b.VU;
        synchronized (storeMap) {
            this.VQ = cause;
            this.VM = 1;
            this.VJ = null;
            b.VU.notifyAll();
        }
    }

    @Override
    public void addFontData(byte[] fontData) throws IllegalStateException {
        if (this.a("addFontData()", -1 - this.VK, fontData, 0)) {
            ++this.VK;
        }
    }

    @Override
    public void setFontData(byte[] fontData, int idx) throws IllegalStateException {
        this.a("setFontData()", -1 - idx, fontData, 0);
    }

    @Override
    public byte[] getFontData(int idx) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = (byte[])b.VU.get((Object)new a(this.ht, -1 - idx));
        if (byArray == null) {
            this.F(idx, this.VK);
        }
        return byArray;
    }

    @Override
    public int getFontCount() {
        return this.VK;
    }

    @Override
    public void setPageLimitExceeded() {
        this.VN = true;
    }

    @Override
    public boolean isPageLimitExceeded() {
        return this.VN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsingTotalPage() {
        StoreMap<a, byte[]> storeMap = b.VU;
        synchronized (storeMap) {
            this.VO = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string, int n2, byte @Nonnull [] byArray, int n3) {
        Object object;
        a a2 = new a(this.ht, n2);
        StoreMap<a, byte[]> storeMap = b.VU;
        synchronized (storeMap) {
            switch (this.VM) {
                case 1: {
                    object = ": Rendering stopped: " + this.VQ;
                    break;
                }
                case 2: {
                    object = ": Rendering finished";
                    break;
                }
                case 3: {
                    object = ": Rendering error";
                    break;
                }
                default: {
                    if (n2 != 0) {
                        byte[] byArray2 = (byte[])b.VU.get((Object)a2);
                        this.VL += byArray.length;
                        if (byArray2 != null) {
                            this.VL -= byArray2.length;
                        }
                    }
                    b.VU.put((Object)a2, (Object)byArray);
                    this.VM = (byte)n3;
                    if (n3 != 0) {
                        this.VJ = null;
                    }
                    b.VU.notifyAll();
                    return true;
                }
            }
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Report Cache] Cache already closed: " + string + (String)object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] G(int n2, int n3) throws ReportException, PageOutOfRangeException, IllegalArgumentException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Illegal timeout value: " + n3);
        }
        a a2 = new a(this.ht, n2);
        long l2 = n3 == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)n3;
        int n4 = 5;
        long l3 = 0L;
        while (true) {
            StoreMap<a, byte[]> storeMap;
            StoreMap<a, byte[]> storeMap2 = storeMap = b.VU;
            synchronized (storeMap2) {
                long l4;
                if (!this.VO || this.VM != 0) {
                    byte[] byArray = (byte[])storeMap.get((Object)a2);
                    if (byArray != null) {
                        return byArray;
                    }
                    if (this.VM != 0) {
                        if (this.VM == 3 && n2 != 1 && (byArray = (byte[])storeMap.get((Object)new a(this.ht, 1))) != null) {
                            return byArray;
                        }
                        throw new PageOutOfRangeException(n2, this.VD, this.VQ);
                    }
                }
                if (l2 < (l4 = System.currentTimeMillis())) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.Timeout, this.ht);
                }
                long l5 = (l4 - this.VI) / 1000L;
                if (BaseUtils.isDebug() && l5 - l3 > (long)n4) {
                    BaseUtils.debug("[Report Cache] Rendering worker is running or queued since " + l5 + " seconds. Waiting for available of chunk " + n2 + " of report: " + String.valueOf(this.ht));
                    l3 = l5;
                    ++n4;
                }
                try {
                    storeMap.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    ReportExceptionFactory.createReportExceptionWithCause(interruptedException);
                }
            }
        }
    }

    int le() {
        return this.VL;
    }

    int lf() {
        return this.VM;
    }

    public ReportCacheKey getKey() {
        return this.ht;
    }

    public ReportGenerator getEngine() {
        return this.VJ;
    }

    void a(long l2) {
        this.VP = l2;
    }

    @Override
    public int compareTo(CachedOutput o2) {
        return Long.compare(this.VP, o2.VP);
    }
}

