/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.RendererBase;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import com.inet.report.y;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

@PublicApi
public class SQLField
extends Field
implements ReferenceHolder,
Validatable {
    String LE = "";
    private Datasource qS;
    private Validity rS;
    private r qh = new r(this);

    SQLField(RendererBase ren) {
        this(ren, ren.getDbTables().getDatasource(0));
    }

    SQLField(RendererBase ren, Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("Parameter 'datasource' is null");
        }
        this.type = 17;
        this.bB = ren;
        this.qS = datasource;
    }

    @Override
    public void setName(String name) throws ReportException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name of a SQL field can not be empty.");
        }
        if (name.equals(this.name)) {
            return;
        }
        if (this.bB == null) {
            return;
        }
        if (Fields.a((Field[])this.bB.Ix, name)) {
            throw y.b("SQLField", name, null);
        }
        try {
            this.rename(name);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("Name not allowed", reportException);
        }
    }

    public String getSQLExpression() {
        return this.LE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSQLExpression(String formula) throws ReportException {
        try {
            this.LE = formula;
            this.iu();
        }
        finally {
            this.updateReferences();
            ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
            for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
                if (!(referenceHolderArray[i2] instanceof FormulaField)) continue;
                FormulaField formulaField = (FormulaField)referenceHolderArray[i2];
                formulaField.setFormula(formulaField.getFormula());
            }
            Fields.a(this.bB, this, 3);
        }
    }

    private void iu() {
        if (this.LE == null || this.LE.trim().isEmpty()) {
            this.valueType = -1;
            this.rS = new Validity(Validity.States.ERROR, ReportExceptionFactory.createReportException(ReportErrorCode.EmptySQLField, new Object[0]));
            return;
        }
        try (Connection connection = this.qS.getConnection();){
            if (connection == null) {
                this.valueType = 11;
                this.rS = new Validity(Validity.States.UNKNOWN, null);
            } else {
                Database database = (Database)this.qS.getDataFactory();
                this.valueType = database.a(this.bB.getDbTables(), this.qS, this.LE, connection);
                this.rS = new Validity(Validity.States.VALID, null);
            }
        }
        catch (Throwable throwable) {
            if (BaseUtils.isWarning()) {
                BaseUtils.warning(throwable.toString());
            }
            this.valueType = -1;
            this.rS = new Validity(Validity.States.ERROR, throwable);
        }
    }

    void ak(String string) {
        this.LE = string;
    }

    @Override
    Field[] D(int n2) {
        return new SQLField[n2];
    }

    public void changeAliasName(String oldAlias, String newAlias) {
        try {
            int n2 = 0;
            int n3 = 0;
            Object object = this.LE;
            StringTokenizer stringTokenizer = null;
            String string = "";
            stringTokenizer = new StringTokenizer((String)object, "\"'{() \n;./}", true);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().toUpperCase();
                n2 = string.length();
                if (string.equals(oldAlias.toUpperCase()) && ((String)object).charAt(n3 + n2) == '.') {
                    object = ((String)object).substring(0, n3) + newAlias + ((String)object).substring(n3 + n2, ((String)object).length());
                    n2 = newAlias.length();
                }
                n3 += n2;
            }
            this.LE = object;
        }
        catch (Exception exception) {
            BaseUtils.warning(exception);
        }
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + k.h(this.LE) + "\n");
        k.a(stringBuilder, n2, a.LI.name(), this.qS.getDataSourceConfigurationName());
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder);
        }
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qh.addReferencedObject(reference);
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qh.getReferencedObjects();
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qh.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qh.getReferencedObjectCount();
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qh.removeReferencedObject(reference);
    }

    @Override
    public final void setReferences() {
        PromptField[] promptFieldArray = this.bB.id();
        if (promptFieldArray != null) {
            for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
                String string = promptFieldArray[i2].getPlaceholderName();
                int n2 = -1;
                while ((n2 = this.LE.indexOf(string, n2 + 1)) != -1) {
                    promptFieldArray[i2].addReferenceHolder(this);
                }
            }
        }
    }

    @Override
    public final void resetReferences() {
        this.qh.resetReferences();
        PromptField[] promptFieldArray = this.bB.id();
        if (promptFieldArray != null) {
            for (int i2 = 0; i2 < promptFieldArray.length; ++i2) {
                String string = "{?" + promptFieldArray[i2].name + "}";
                int n2 = -1;
                while ((n2 = this.LE.indexOf(string, n2 + 1)) != -1) {
                    promptFieldArray[i2].removeReferenceHolder(this);
                }
            }
        }
    }

    private final void updateReferences() {
        this.resetReferences();
        this.setReferences();
    }

    @Override
    public boolean isUsed() {
        return super.isUsed();
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        try {
            String string = atts.getValue("value");
            switch (a.valueOf(tag)) {
                case LG: {
                    try {
                        this.setName(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        BaseUtils.printStackTrace(illegalArgumentException);
                        for (int i2 = 1; i2 < 10000; ++i2) {
                            try {
                                this.setName(string + " (" + i2 + ")");
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException2) {
                                continue;
                            }
                        }
                        if (this.getName() != null) break;
                        this.setName(string + " " + System.nanoTime());
                    }
                    break;
                }
                case LH: {
                    break;
                }
                case LI: {
                    String string2 = string;
                    Datasource datasource = this.bB.getDbTables().getDatasource(string2);
                    if (datasource == null) break;
                    this.qS = datasource;
                }
            }
            return null;
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
            return super.parseElement(group, tag, atts, parserMap);
        }
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
        try {
            if (this.valueType == -1) {
                this.setSQLExpression(text);
            } else {
                this.ak(text);
            }
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
    }

    @Override
    public Field duplicate(String copyName) {
        try {
            return this.bB.getFields().addSQLField(copyName, this.valueType, this.getSQLExpression(), this.qS);
        }
        catch (ReportException reportException) {
            throw new IllegalArgumentException("could not duplicate SQL field " + copyName, reportException);
        }
    }

    public Datasource getDatasource() {
        return this.qS;
    }

    @Override
    public Validity validate() {
        if (this.rS == null) {
            this.iu();
        }
        return this.rS;
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.getDataProvider();
        if (reportDataHandler.getRowSource() == null) {
            return "(" + this.LE + ")";
        }
        int n2 = this.cV();
        if (n2 < 0) {
            this.U(reportDataHandler.getColumnIdx(this));
            n2 = this.cV();
        }
        return reportDataHandler.getObject(n2);
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a LG = new a();
        public static final /* enum */ a LH = new a();
        public static final /* enum */ a LI = new a();
        private static final /* synthetic */ a[] LJ;

        public static a[] values() {
            return (a[])LJ.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] iv() {
            return new a[]{LG, LH, LI};
        }

        static {
            LJ = a.iv();
        }
    }
}

