/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPSecretKeyDecryptorWithAAD;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePBEProtectionRemoverFactory
implements PBEProtectionRemoverFactory {
    private final char[] passPhrase;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;
    private JceAEADUtil aeadUtil = new JceAEADUtil(this.helper);
    private JcaPGPDigestCalculatorProviderBuilder calculatorProviderBuilder;

    public JcePBEProtectionRemoverFactory(char[] cArray) {
        this.passPhrase = cArray;
        this.calculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    }

    public JcePBEProtectionRemoverFactory(char[] cArray, PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.passPhrase = cArray;
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public JcePBEProtectionRemoverFactory setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadUtil = new JceAEADUtil(this.helper);
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(provider);
        }
        return this;
    }

    public JcePBEProtectionRemoverFactory setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.aeadUtil = new JceAEADUtil(this.helper);
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(string);
        }
        return this;
    }

    @Override
    public PBESecretKeyDecryptor createDecryptor(String string) throws PGPException {
        if (this.calculatorProvider == null) {
            this.calculatorProvider = this.calculatorProviderBuilder.build();
        }
        if (string.indexOf("ocb") >= 0) {
            return new PGPSecretKeyDecryptorWithAAD(this.passPhrase, this.calculatorProvider){

                @Override
                public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) throws PGPException {
                    try {
                        Cipher cipher = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(n) + "/OCB/NoPadding");
                        cipher.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(n, byArray), (AlgorithmParameterSpec)new AEADParameterSpec(byArray2, 128, byArray3));
                        return cipher.doFinal(byArray4, n2, n3);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new PGPException("invalid parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                    }
                }

                @Override
                public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                    byte[] byArray5 = new byte[]{(byte)(0xC0 | n3), (byte)n4, (byte)n, (byte)n2};
                    KDFCalculator kDFCalculator = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.HKDF.withPRF(FipsKDF.AgreementKDFPRF.SHA256).using(byArray).withIV(byArray5));
                    byte[] byArray6 = new byte[SymmetricKeyUtils.getKeyLengthInOctets(n)];
                    kDFCalculator.generateBytes(byArray6, 0, byArray6.length);
                    byte[] byArray7 = Arrays.prepend((byte[])byArray4, (byte)((byte)(0xC0 | n3)));
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray6, PGPUtil.getSymmetricCipherName(n));
                    Cipher cipher = JcePBEProtectionRemoverFactory.this.aeadUtil.createAEADCipher(n, n2);
                    try {
                        JceAEADCipherUtil.setUpAeadCipher(cipher, secretKeySpec, 2, byArray2, 128, byArray7);
                        byte[] byArray8 = cipher.doFinal(byArray3);
                        return byArray8;
                    }
                    catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                        throw new PGPException("Cannot extract AEAD protected secret key material", generalSecurityException);
                    }
                }
            };
        }
        return new PBESecretKeyDecryptor(this.passPhrase, this.calculatorProvider){

            @Override
            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    Cipher cipher = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(n) + "/CBC/NoPadding");
                    cipher.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(n, byArray), new IvParameterSpec(byArray2));
                    return cipher.doFinal(byArray3, n2, n3);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new PGPException("invalid parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }

            @Override
            public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                byte[] byArray5 = new byte[]{(byte)(0xC0 | n3), (byte)n4, (byte)n, (byte)n2};
                KDFCalculator kDFCalculator = new FipsKDF.AgreementOperatorFactory().createKDFCalculator(FipsKDF.HKDF.withPRF(FipsKDF.AgreementKDFPRF.SHA256).using(byArray).withIV(byArray5));
                byte[] byArray6 = new byte[SymmetricKeyUtils.getKeyLengthInOctets(n)];
                kDFCalculator.generateBytes(byArray6, 0, byArray6.length);
                byte[] byArray7 = Arrays.prepend((byte[])byArray4, (byte)((byte)(0xC0 | n3)));
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray6, PGPUtil.getSymmetricCipherName(n));
                Cipher cipher = JcePBEProtectionRemoverFactory.this.aeadUtil.createAEADCipher(n, n2);
                try {
                    JceAEADCipherUtil.setUpAeadCipher(cipher, secretKeySpec, 2, byArray2, 128, byArray7);
                    byte[] byArray8 = cipher.doFinal(byArray3);
                    return byArray8;
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                    throw new PGPException("Cannot extract AEAD protected secret key material", generalSecurityException);
                }
            }
        };
    }
}

