/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketInputStream;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

public class SignaturePacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private int signatureType;
    private long creationTime;
    private long keyID;
    private int keyAlgorithm;
    private int hashAlgorithm;
    private MPInteger[] signature;
    private byte[] fingerPrint;
    private SignatureSubpacket[] hashedData;
    private SignatureSubpacket[] unhashedData;
    private byte[] signatureEncoding;
    private byte[] salt;

    SignaturePacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    SignaturePacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(2, bl);
        this.version = bCPGInputStream.read();
        switch (this.version) {
            case 2: 
            case 3: {
                this.parseV2_V3(bCPGInputStream);
                break;
            }
            case 4: 
            case 5: {
                this.parseV4_V5(bCPGInputStream);
                break;
            }
            case 6: {
                this.parseV6(bCPGInputStream);
                break;
            }
            default: {
                Streams.drain((InputStream)bCPGInputStream);
                throw new UnsupportedPacketVersionException("unsupported version: " + this.version);
            }
        }
    }

    private void parseV2_V3(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.read();
        this.signatureType = bCPGInputStream.read();
        this.creationTime = StreamUtil.readTime(bCPGInputStream);
        this.keyID = StreamUtil.readKeyID(bCPGInputStream);
        this.keyAlgorithm = bCPGInputStream.read();
        this.hashAlgorithm = bCPGInputStream.read();
        this.fingerPrint = new byte[2];
        bCPGInputStream.readFully(this.fingerPrint);
        this.parseSignature(bCPGInputStream);
    }

    private void parseV4_V5(BCPGInputStream bCPGInputStream) throws IOException {
        this.signatureType = bCPGInputStream.read();
        this.keyAlgorithm = bCPGInputStream.read();
        this.hashAlgorithm = bCPGInputStream.read();
        this.parseSubpackets(bCPGInputStream);
        this.fingerPrint = new byte[2];
        bCPGInputStream.readFully(this.fingerPrint);
        this.parseSignature(bCPGInputStream);
    }

    private void parseV6(BCPGInputStream bCPGInputStream) throws IOException {
        this.signatureType = bCPGInputStream.read();
        this.keyAlgorithm = bCPGInputStream.read();
        this.hashAlgorithm = bCPGInputStream.read();
        this.parseSubpackets(bCPGInputStream);
        this.fingerPrint = new byte[2];
        bCPGInputStream.readFully(this.fingerPrint);
        int n = bCPGInputStream.read();
        this.salt = new byte[n];
        bCPGInputStream.readFully(this.salt);
        this.parseSignature(bCPGInputStream);
    }

    private void parseSubpackets(BCPGInputStream bCPGInputStream) throws IOException {
        SignatureSubpacket signatureSubpacket;
        int n;
        Vector<SignatureSubpacket> vector = this.readSignatureSubpacketVector(bCPGInputStream);
        this.hashedData = new SignatureSubpacket[vector.size()];
        for (n = 0; n != this.hashedData.length; ++n) {
            signatureSubpacket = vector.elementAt(n);
            if (signatureSubpacket instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)signatureSubpacket).getKeyID();
            } else if (signatureSubpacket instanceof SignatureCreationTime) {
                this.creationTime = ((SignatureCreationTime)signatureSubpacket).getTime().getTime();
            }
            this.hashedData[n] = signatureSubpacket;
        }
        vector = this.readSignatureSubpacketVector(bCPGInputStream);
        this.unhashedData = new SignatureSubpacket[vector.size()];
        for (n = 0; n != this.unhashedData.length; ++n) {
            signatureSubpacket = vector.elementAt(n);
            if (signatureSubpacket instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)signatureSubpacket).getKeyID();
            }
            this.unhashedData[n] = signatureSubpacket;
        }
        this.setIssuerKeyId();
        this.setCreationTime();
    }

    private Vector<SignatureSubpacket> readSignatureSubpacketVector(BCPGInputStream bCPGInputStream) throws IOException {
        SignatureSubpacket signatureSubpacket;
        int n = this.version == 6 ? StreamUtil.read4OctetLength(bCPGInputStream) : StreamUtil.read2OctetLength(bCPGInputStream);
        byte[] byArray = new byte[n];
        bCPGInputStream.readFully(byArray);
        SignatureSubpacketInputStream signatureSubpacketInputStream = new SignatureSubpacketInputStream(new ByteArrayInputStream(byArray));
        Vector<SignatureSubpacket> vector = new Vector<SignatureSubpacket>();
        while ((signatureSubpacket = signatureSubpacketInputStream.readPacket()) != null) {
            vector.addElement(signatureSubpacket);
        }
        return vector;
    }

    private void parseSignature(BCPGInputStream bCPGInputStream) throws IOException {
        switch (this.keyAlgorithm) {
            case 1: 
            case 3: {
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[1];
                this.signature[0] = mPInteger;
                break;
            }
            case 17: {
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                MPInteger mPInteger2 = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[2];
                this.signature[0] = mPInteger;
                this.signature[1] = mPInteger2;
                break;
            }
            case 16: 
            case 20: {
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                MPInteger mPInteger3 = new MPInteger(bCPGInputStream);
                MPInteger mPInteger4 = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[3];
                this.signature[0] = mPInteger;
                this.signature[1] = mPInteger3;
                this.signature[2] = mPInteger4;
                break;
            }
            case 28: {
                this.signatureEncoding = new byte[114];
                bCPGInputStream.readFully(this.signatureEncoding);
                break;
            }
            case 27: {
                this.signatureEncoding = new byte[64];
                bCPGInputStream.readFully(this.signatureEncoding);
                break;
            }
            case 19: 
            case 22: {
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                MPInteger mPInteger5 = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[2];
                this.signature[0] = mPInteger;
                this.signature[1] = mPInteger5;
                break;
            }
            default: {
                if (this.keyAlgorithm >= 100 && this.keyAlgorithm <= 110) {
                    this.signature = null;
                    this.signatureEncoding = Streams.readAll((InputStream)bCPGInputStream);
                    break;
                }
                throw new IOException("unknown signature key algorithm: " + this.keyAlgorithm);
            }
        }
    }

    public SignaturePacket(int n, long l, int n2, int n3, SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket[] signatureSubpacketArray2, byte[] byArray, MPInteger[] mPIntegerArray) {
        this(4, n, l, n2, n3, signatureSubpacketArray, signatureSubpacketArray2, byArray, mPIntegerArray);
    }

    public SignaturePacket(int n, int n2, long l, int n3, int n4, long l2, byte[] byArray, MPInteger[] mPIntegerArray) {
        this(n, n2, l, n3, n4, null, null, byArray, mPIntegerArray);
        this.creationTime = l2;
    }

    public SignaturePacket(int n, int n2, long l, int n3, int n4, SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket[] signatureSubpacketArray2, byte[] byArray, MPInteger[] mPIntegerArray) {
        super(2);
        this.version = n;
        this.signatureType = n2;
        this.keyID = l;
        this.keyAlgorithm = n3;
        this.hashAlgorithm = n4;
        this.hashedData = signatureSubpacketArray;
        this.unhashedData = signatureSubpacketArray2;
        this.fingerPrint = byArray;
        this.signature = mPIntegerArray;
        if (signatureSubpacketArray != null) {
            this.setCreationTime();
        }
    }

    public SignaturePacket(int n, int n2, long l, int n3, int n4, SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket[] signatureSubpacketArray2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(2);
        this.version = n;
        this.signatureType = n2;
        this.keyID = l;
        this.keyAlgorithm = n3;
        this.hashAlgorithm = n4;
        this.hashedData = signatureSubpacketArray;
        this.unhashedData = signatureSubpacketArray2;
        this.fingerPrint = byArray;
        this.signatureEncoding = Arrays.clone((byte[])byArray2);
        this.salt = Arrays.clone((byte[])byArray3);
        if (signatureSubpacketArray != null) {
            this.setCreationTime();
        }
    }

    public SignaturePacket(int n, int n2, long l, int n3, int n4, SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket[] signatureSubpacketArray2, byte[] byArray, MPInteger[] mPIntegerArray, byte[] byArray2) {
        super(2);
        this.version = n;
        this.signatureType = n2;
        this.keyID = l;
        this.keyAlgorithm = n3;
        this.hashAlgorithm = n4;
        this.hashedData = signatureSubpacketArray;
        this.unhashedData = signatureSubpacketArray2;
        this.fingerPrint = byArray;
        this.signature = mPIntegerArray;
        this.salt = Arrays.clone((byte[])byArray2);
        if (signatureSubpacketArray != null) {
            this.setCreationTime();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerPrint() {
        return Arrays.clone((byte[])this.fingerPrint);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getSignatureTrailer() {
        byte[] byArray = null;
        if (this.version == 3 || this.version == 2) {
            byArray = new byte[5];
            long l = this.creationTime / 1000L;
            byArray[0] = (byte)this.signatureType;
            Pack.intToBigEndian((int)((int)l), (byte[])byArray, (int)1);
        } else if (this.version == 4 || this.version == 5 || this.version == 6) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SignatureSubpacket[] signatureSubpacketArray = this.getHashedSubPackets();
            try {
                byteArrayOutputStream.write((byte)this.getVersion());
                byteArrayOutputStream.write((byte)this.getSignatureType());
                byteArrayOutputStream.write((byte)this.getKeyAlgorithm());
                byteArrayOutputStream.write((byte)this.getHashAlgorithm());
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                for (int i = 0; i != signatureSubpacketArray.length; ++i) {
                    signatureSubpacketArray[i].encode(byteArrayOutputStream2);
                }
                byte[] byArray2 = byteArrayOutputStream2.toByteArray();
                if (this.version != 6) {
                    StreamUtil.write2OctetLength(byteArrayOutputStream, byArray2.length);
                } else {
                    StreamUtil.write4OctetLength(byteArrayOutputStream, byArray2.length);
                }
                byteArrayOutputStream.write(byArray2);
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.write((byte)this.getVersion());
                byteArrayOutputStream.write(-1);
                if (this.version == 5) {
                    StreamUtil.write8OctetLength(byteArrayOutputStream, byArray3.length);
                } else {
                    StreamUtil.write4OctetLength(byteArrayOutputStream, byArray3.length);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("exception generating trailer: " + iOException);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public MPInteger[] getSignature() {
        return this.signature;
    }

    public byte[] getSignatureBytes() {
        if (this.signatureEncoding != null) {
            return Arrays.clone((byte[])this.signatureEncoding);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            for (int i = 0; i != this.signature.length; ++i) {
                bCPGOutputStream.writeObject(this.signature[i]);
            }
            bCPGOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public SignatureSubpacket[] getHashedSubPackets() {
        return this.hashedData;
    }

    public SignatureSubpacket[] getUnhashedSubPackets() {
        return this.unhashedData;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        if (this.version == 3 || this.version == 2) {
            bCPGOutputStream2.write(5);
            long l = this.creationTime / 1000L;
            bCPGOutputStream2.write(this.signatureType);
            StreamUtil.writeTime(bCPGOutputStream2, l);
            StreamUtil.writeKeyID(bCPGOutputStream2, this.keyID);
            bCPGOutputStream2.write(this.keyAlgorithm);
            bCPGOutputStream2.write(this.hashAlgorithm);
        } else if (this.version == 4 || this.version == 5 || this.version == 6) {
            bCPGOutputStream2.write(this.signatureType);
            bCPGOutputStream2.write(this.keyAlgorithm);
            bCPGOutputStream2.write(this.hashAlgorithm);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.writeSignatureSubpacketArray(byteArrayOutputStream2, bCPGOutputStream2, this.hashedData);
            byteArrayOutputStream2.reset();
            this.writeSignatureSubpacketArray(byteArrayOutputStream2, bCPGOutputStream2, this.unhashedData);
        } else {
            throw new IOException("unknown version: " + this.version);
        }
        bCPGOutputStream2.write(this.fingerPrint);
        if (this.version == 6) {
            bCPGOutputStream2.write(this.salt.length);
            bCPGOutputStream2.write(this.salt);
        }
        if (this.signature != null) {
            for (int i = 0; i != this.signature.length; ++i) {
                bCPGOutputStream2.writeObject(this.signature[i]);
            }
        } else {
            bCPGOutputStream2.write(this.signatureEncoding);
        }
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), 2, byteArrayOutputStream.toByteArray());
    }

    private void writeSignatureSubpacketArray(ByteArrayOutputStream byteArrayOutputStream, BCPGOutputStream bCPGOutputStream, SignatureSubpacket[] signatureSubpacketArray) throws IOException {
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            signatureSubpacketArray[i].encode(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (this.version == 6) {
            StreamUtil.write4OctetLength(bCPGOutputStream, byArray.length);
        } else {
            StreamUtil.write2OctetLength(bCPGOutputStream, byArray.length);
        }
        bCPGOutputStream.write(byArray);
    }

    private void setCreationTime() {
        for (int i = 0; i != this.hashedData.length; ++i) {
            if (!(this.hashedData[i] instanceof SignatureCreationTime)) continue;
            this.creationTime = ((SignatureCreationTime)this.hashedData[i]).getTime().getTime();
            break;
        }
    }

    private void setIssuerKeyId() {
        if (this.keyID != 0L) {
            return;
        }
        for (SignatureSubpacket signatureSubpacket : this.hashedData) {
            if (signatureSubpacket instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)signatureSubpacket).getKeyID();
                return;
            }
            if (!(signatureSubpacket instanceof IssuerFingerprint)) continue;
            this.keyID = ((IssuerFingerprint)signatureSubpacket).getKeyID();
            return;
        }
        for (SignatureSubpacket signatureSubpacket : this.unhashedData) {
            if (signatureSubpacket instanceof IssuerKeyID) {
                this.keyID = ((IssuerKeyID)signatureSubpacket).getKeyID();
                return;
            }
            if (!(signatureSubpacket instanceof IssuerFingerprint)) continue;
            this.keyID = ((IssuerFingerprint)signatureSubpacket).getKeyID();
            return;
        }
    }

    public static SignaturePacket fromByteArray(byte[] byArray) throws IOException {
        BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(byArray));
        return new SignaturePacket(bCPGInputStream);
    }
}

