/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mail.api;

import com.inet.annotations.InternalApi;
import com.inet.mail.api.AttachedFile;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.PartContent;
import com.inet.mail.api.PartHandler;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class MailAttachmentUtilities {
    private static final String u = System.getProperty("file.separator", "//");

    public static boolean testAttachmentName(String theName, String patternString) {
        if (patternString == null || patternString.length() == 0) {
            return false;
        }
        int n = patternString.indexOf(42);
        if (n > -1) {
            if (n == 0) {
                return theName.endsWith(patternString.substring(1));
            }
            if (n == patternString.length() - 1) {
                return theName.startsWith(patternString.substring(0, patternString.length() - 1));
            }
            String string = patternString.substring(0, n);
            String string2 = patternString.substring(n + 1);
            return theName.startsWith(string) && theName.indexOf(string2, string.length()) > -1 && theName.endsWith(string2);
        }
        return patternString.equals(theName);
    }

    public static String getContentType(Part part) {
        try {
            String string = part.getContentType();
            string = string != null ? string.toLowerCase() : "";
            String[] stringArray = part.getHeader("Content-Type");
            if (stringArray != null && stringArray.length > 0) {
                String string2 = stringArray[0];
                if (string.startsWith("text/plain") && string2.startsWith("text/html")) {
                    string = string2.toLowerCase();
                } else if (string.startsWith("text/plain") && string2.startsWith("multipart/") && string2.indexOf("boundary=") > -1) {
                    string = string2;
                }
            }
            return string;
        }
        catch (Exception exception) {
            BaseEmail.LOGGER.error((Throwable)exception);
            return "";
        }
    }

    public static void fetchParts(Part part, ArrayList<PartHandler> list, boolean alternativePart) throws Exception {
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            boolean bl = part.isMimeType("multipart/alternative");
            for (int i = 0; i < multipart.getCount(); ++i) {
                MailAttachmentUtilities.fetchParts((Part)multipart.getBodyPart(i), list, bl);
            }
        } else {
            String string = MailAttachmentUtilities.getContentType(part);
            if (string.startsWith("multipart/")) {
                MailAttachmentUtilities.fixWebDeProblem(part, list, string);
            } else {
                list.add(new PartHandler(part, alternativePart));
            }
        }
    }

    public static void fixWebDeProblem(Part messagePart, ArrayList<PartHandler> list, String cotentTypeString) throws Exception {
        String string = messagePart.getContentType();
        String string2 = string = string != null ? string.toLowerCase() : "";
        if (cotentTypeString.indexOf("boundary=") == -1 || !string.startsWith("text/plain")) {
            throw new IllegalArgumentException("no boundarys");
        }
        String string3 = messagePart.getContent().toString();
        MailAttachmentUtilities.a(list, string3, cotentTypeString);
    }

    private static void a(ArrayList<PartHandler> arrayList, String string, String string2) throws Exception {
        String string3 = string2.substring(string2.indexOf("boundary=") + "boundary=".length());
        int n = string.indexOf(string3);
        int n2 = string.indexOf(string3, n + string3.length());
        while (n2 > -1) {
            int n3 = n + string3.length();
            while (string.charAt(n3) < ' ') {
                ++n3;
            }
            int n4 = n2 - 1;
            while (string.charAt(n4) < ' ' || string.charAt(n4) == '-') {
                --n4;
            }
            MailAttachmentUtilities.a(string.substring(n3, n4 + 1), arrayList);
            n = n2;
            n2 = string.indexOf(string3, n + string3.length());
        }
    }

    private static void a(String string, ArrayList<PartHandler> arrayList) throws Exception {
        int n = string.indexOf("\r\n\r\n");
        if (n > -1) {
            String string2 = string.substring(0, n + 2);
            String string3 = string.substring(n + 4);
            PartContent partContent = new PartContent(string2);
            if (partContent.getContentType().indexOf("multipart/") > -1) {
                MailAttachmentUtilities.a(arrayList, string3, partContent.getContentType());
            } else {
                partContent.setContent(string3, null);
                arrayList.add(new PartHandler(partContent, false));
            }
        }
    }

    @Nonnull
    public static String extractCharset(String meta, int charsetIndex) {
        int n = (meta = meta.replace('\"', ' ')).indexOf(32, charsetIndex + 10);
        if (n > -1) {
            return meta.substring(charsetIndex + 8, n).trim();
        }
        return meta.substring(charsetIndex + 8).trim();
    }

    public static String getFileName(String name, String ext, List<AttachedFile> atts) {
        String string = (name = MailAttachmentUtilities.normalisiertenFileName(name)) + ext;
        if (MailAttachmentUtilities.a(string, atts)) {
            for (int i = 1; i < 100 && MailAttachmentUtilities.a(string = name + "(" + i + ")" + ext, atts); ++i) {
            }
        }
        return string;
    }

    private static boolean a(String string, List<AttachedFile> list) {
        for (int i = 0; i < list.size(); ++i) {
            AttachedFile attachedFile = list.get(i);
            if (!attachedFile.getFileName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static String normalisiertenFileName(String name) {
        name = name.replace("%20", "_");
        name = name.replace("=20", "_");
        name = name.replace('?', '_');
        name = name.replace('*', '_');
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        name = name.replace(':', '_');
        name = name.replace('\"', '_');
        return name;
    }
}

