/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.webapi.data.HelpDeskTicketSearchRequestData;
import com.inet.helpdesk.webapi.data.HelpDeskTicketSearchResponseData;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.AvailableSearchTags;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
public class HelpDeskTicketSearchHandler
extends RequestHandler<HelpDeskTicketSearchRequestData, Set<Integer>> {
    public static final String REQUEST_HANDLER_NAME = "search";

    public HelpDeskTicketSearchHandler() {
        super(new String[]{REQUEST_HANDLER_NAME});
        this.registerRequestHandler((RequestHandlerBase)new AvailableSearchTags(() -> TicketManager.getReader().getSearchEngine()));
    }

    public String getHelpPageKey() {
        return "webapi.ticket.search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Search tickets", description="Search for tickets using a query string with optional field filters. Returns matching tickets and search suggestions.", responses={@ApiResponse(responseCode="200", description="Search completed successfully", content={@Content(schema=@Schema(implementation=HelpDeskTicketSearchResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid search request or no query specified"), @ApiResponse(responseCode="401", description="User not logged in")})
    public Set<Integer> handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable HelpDeskTicketSearchRequestData requestData, boolean previewModeEnabled) throws IOException {
        Locale locale;
        if (requestData == null) {
            throw new ClientMessageException("No request data was sent to specify the search query.");
        }
        String query = "";
        int start = 0;
        int limit = 100;
        Locale defaultLocale = locale = ClientLocale.getThreadLocale();
        query = requestData.getQuery();
        limit = requestData.getLimit();
        start = requestData.getStart();
        locale = requestData.getLocale();
        IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
        GUID userAccountID = UserManager.getInstance().getCurrentUserAccountID();
        if (userAccountID == null) {
            throw new ClientMessageException("A user is not logged in to run the search query.");
        }
        SearchCommand globalCommand = GlobalSearchViewDefinition.INSTANCE.createSearchCommand(userAccountID, locale, engine);
        SearchCommand searchCommand = new TextSearchCommandBuilder(engine, query).build(locale);
        searchCommand.getSearchExpression().addAll(0, (Collection)globalCommand.getSearchExpression());
        Set search = engine.simpleSearch(searchCommand);
        try {
            ClientLocale.setThreadLocale((Locale)locale);
            List suggestedValues = engine.getSuggestedValues(query, null);
            boolean hasMore = search.size() > start + limit;
            Set<Integer> responseList = search.stream().skip(start).limit(limit).collect(Collectors.toSet());
            ResponseWriter.json((HttpServletResponse)response, (Object)HelpDeskTicketSearchResponseData.from(responseList, suggestedValues, hasMore));
            Set set = search;
            return set;
        }
        finally {
            ClientLocale.setThreadLocale((Locale)defaultLocale);
        }
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }
}

