/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data.step;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Basic response data for a ticket reaction step")
public class TicketStepEntryResponseData {
    @Schema(description="The unique identifier of the reaction step")
    private int id;
    @Schema(description="The identifier of the action that was performed")
    private int actionID;
    @Schema(description="The GUID of the user who performed the action")
    private GUID userGUID;
    @Schema(description="The timestamp when the reaction step was last modified")
    private long lastModified;
    @Schema(description="The ID of the secondary ticket this step originally belongs to. Only present if this step comes from a bundled secondary ticket (i.e., when viewing a primary ticket with merged steps).")
    @JsonExcludeNull
    private Integer secondaryTicketId;

    protected TicketStepEntryResponseData() {
    }

    public TicketStepEntryResponseData(ReaStepVO reaStepVO, int currentTicketId) {
        this.id = reaStepVO.getID();
        this.actionID = reaStepVO.getActionID();
        this.userGUID = reaStepVO.getUserID();
        this.lastModified = reaStepVO.getEndDate();
        int orgBunID = reaStepVO.getOrgBunID();
        if (orgBunID != currentTicketId) {
            this.secondaryTicketId = orgBunID;
        }
    }

    public static List<@Nonnull TicketStepEntryResponseData> from(List<ReaStepVO> reaStepsForTicket, int currentTicketId) {
        return reaStepsForTicket.stream().map(r -> new TicketStepEntryResponseData((ReaStepVO)r, currentTicketId)).collect(Collectors.toList());
    }
}

