/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.classloader.translations.TranslationKey;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fieldgroups.AllowedActionsFieldPanelDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.group.AllowedActionsGroupFieldDefinition;
import com.inet.helpdesk.usersandgroups.ui.fields.values.AllowedActionsFieldValue;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AllowedActionsUserFieldDefinition
extends UserFieldDefinition<Set<Integer>> {
    public AllowedActionsUserFieldDefinition() {
        super(AllowedActionsFieldPanelDefinition.FIELD_PANEL_KEY, HDUsersAndGroups.FIELD_ALLOWED_ACTIONS.getKey(), AllowedActionsGroupFieldDefinition.FIELD_TYPE, 100);
    }

    public AllowedActionsFieldValue getFieldValue(@Nullable UserAccount account) {
        TreeSet<Integer> value = account == null ? Collections.emptySet() : new TreeSet<Integer>((Collection)account.getValue((UserField)HDUsersAndGroups.FIELD_ALLOWED_ACTIONS));
        HashSet<Integer> inheritActions = new HashSet<Integer>();
        if (account != null) {
            UserGroupManager ugman = UserGroupManager.getRecoveryEnabledInstance();
            Set groupsForUser = ugman.getGroupsForUser(account.getID());
            for (UserGroupInfo userGroupInfo : groupsForUser) {
                if (userGroupInfo.getType() != null && userGroupInfo.getType().equals((Object)UsersAndGroups.GROUPTYPE_ADMIN)) {
                    inheritActions.addAll(ActionManager.getInstance().getAll(true).stream().map(FieldVO::getId).collect(Collectors.toSet()));
                    continue;
                }
                inheritActions.addAll((Collection)userGroupInfo.getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS));
            }
        }
        boolean showSupporterActions = account == null || HDUsersAndGroups.isSupporter(account);
        return new AllowedActionsFieldValue(value, inheritActions, showSupporterActions);
    }

    public String getLabel() {
        return null;
    }

    public boolean isAvailable(UserAccount account) {
        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }

    public Set<Integer> convertFromString(String value) {
        return (Set)new Json().fromJson(value, Set.class, new Type[]{Integer.class});
    }

    public String getDescription() {
        return null;
    }

    public TranslationKey getLabelTranslationKey() {
        return null;
    }
}

