/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.lib.util.StringFunctions;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.ApiSearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.TagIndex;
import com.inet.search.tokenizers.NoTokenTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketIdMatcher
extends ApiSearchTag<Integer> {
    public static final String KEY = "ticketid";

    TicketIdMatcher(@Nonnull IndexSearchEngine<Integer> index) {
        super(KEY, (SearchTokenizer)new NoTokenTokenizer(), 200, () -> Tickets.MSG.getMsg("field.ticketid", new Object[0]), index, index.getTag("statusid"));
    }

    protected void search(SearchCondition condition, SearchResultHolder<Integer> map, String token) {
        try {
            int id = Tickets.decodeTicketID(token, false);
            if (id < 0) {
                return;
            }
            Iterator it = super.createIterator(false, TagIndex.IteratorType.ID, null, switch (condition.getOperator()) {
                case SearchCondition.SearchTermOperator.GT -> v -> v > id;
                case SearchCondition.SearchTermOperator.GE -> v -> v >= id;
                case SearchCondition.SearchTermOperator.LT -> v -> v < id;
                case SearchCondition.SearchTermOperator.LE -> v -> v <= id;
                case SearchCondition.SearchTermOperator.Unequals -> v -> v != id;
                default -> v -> v == id;
            }, null);
            while (it.hasNext()) {
                Integer next = (Integer)it.next();
                map.add((Object)next, true, this.getTag(), token, condition);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nonnull
    protected <T> Iterator<T> createIterator(boolean forward, @Nonnull TagIndex.IteratorType itType, @Nullable Comparable<?> startsWith, @Nonnull Predicate<Integer> filter, final @Nullable Function<Object, String> formatter) {
        try {
            if (startsWith != null && startsWith.getClass() == String.class) {
                startsWith = StringFunctions.isEmpty((String)((String)((Object)startsWith))) ? null : Integer.valueOf((String)((Object)startsWith));
            }
        }
        catch (NumberFormatException e) {
            return Collections.emptyIterator();
        }
        if (itType == TagIndex.IteratorType.VALUES) {
            itType = TagIndex.IteratorType.ID;
        }
        Iterator it = super.createIterator(forward, itType, null, filter, formatter);
        if (startsWith instanceof Number) {
            Iterator allIds = it;
            Iterable iterable = () -> allIds;
            Stream<? super Integer> stream = StreamSupport.stream(iterable.spliterator(), false);
            it = stream.filter(TicketIdMatcher.filter(((Number)startsWith).intValue())).iterator();
        }
        if (formatter != null) {
            final Iterator it_ = it;
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return it_.hasNext();
                }

                public Object next() {
                    return formatter.apply(it_.next());
                }
            };
        }
        return it;
    }

    private static Predicate<? super Integer> filter(int startsWith) {
        return id -> {
            int value = Math.abs(id);
            int starts = Math.abs(startsWith);
            while (value != starts) {
                if (value < starts) {
                    return false;
                }
                value /= 10;
            }
            return true;
        };
    }
}

