/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.shared.model.Status;

public class ReopenTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        return new ReopenTicketActionExtension();
    }

    private class ReopenTicketActionExtension
    implements TicketActionExtension {
        private ReopenTicketActionExtension() {
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket opTicket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            if (!opTicket.isNew() && Status.isClosedOrDeletedStatus(opTicket.getOldTicket().get().getStatusID()) && Status.isOpenStatus(opTicket.getAttributeValue(Tickets.ATTRIBUTE_STATUS_ID))) {
                opTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_CLOSE_DATE, null);
            }
        }
    }
}

