/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.reporting.server.datasource.TicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Actions;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_ITIL_Links;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_Abrechnung;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_Eskalationen;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_all;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_closed;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_deleted;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_inquiries;
import com.inet.helpdesk.core.reporting.server.dataview.DataView_Tickets_open;
import com.inet.helpdesk.plugins.reporting.server.AttachmentPermissionChecker;
import com.inet.helpdesk.plugins.reporting.server.HDFileUrlPermissionChecker;
import com.inet.helpdesk.plugins.reporting.server.HdEngineFactory;
import com.inet.helpdesk.plugins.reporting.server.HelpDeskConnector;
import com.inet.helpdesk.plugins.reporting.server.HelpDeskPropertiesChecker;
import com.inet.helpdesk.plugins.reporting.server.PrintServlet;
import com.inet.helpdesk.plugins.reporting.server.UserHandler;
import com.inet.helpdesk.plugins.reporting.server.UserHandlerDetails;
import com.inet.helpdesk.plugins.reporting.server.adhoc.DataView_Locations;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportRestrictionFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingFieldFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingImageFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingTicketFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.ReportingUtilitiesFunctions;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.TextAccess;
import com.inet.helpdesk.plugins.reporting.server.userfunctions.UserDataFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.PluginServlet;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.DatabaseMariaDB;
import com.inet.report.DatabaseMysql;
import com.inet.report.DatabaseOracle;
import com.inet.report.DatabaseSqlServer;
import com.inet.report.PropertiesChecker;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.dataview.user.DataView_GroupMembers;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.api.UserField;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReportingServerPluginRegistration {
    public static final String CONFIG_EXPANDER_CLASS_KEY = "formulaExpanderClass";
    private static ReportingServerPluginRegistration instance;
    public static final I18nMessages CLIENT_MSG;
    private static final ConfigValue<DatabaseConfigInfoList> DB_LIST;

    public void registerExtension(final @Nonnull ServerPluginManager spm) {
        ServerPluginDescription pluginDescription = spm.getPluginDescription("reporting");
        if (pluginDescription != null) {
            pluginDescription.addDependency("lang", this.getClass().getClassLoader());
        }
        ConfigKey.LANGUAGE_RESOURCE.setDefault("lang.ReportLang");
        spm.register(PluginServlet.class, (Object)new PrintServlet());
        spm.register(PropertiesChecker.class, (Object)new HelpDeskPropertiesChecker());
        spm.register(UserDefinedFunction.class, (Object)new HelpDeskConnector());
        spm.register(UserDefinedFunction.class, (Object)new ReportRestrictionFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingFieldFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingImageFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingTicketFunctions());
        spm.register(UserDefinedFunction.class, (Object)new ReportingUtilitiesFunctions());
        spm.register(UserDefinedFunction.class, (Object)new UserDataFunctions());
        spm.register(UserDefinedFunction.class, (Object)new TextAccess());
        spm.register(PluginPermissionChecker.class, (Object)new AttachmentPermissionChecker());
        spm.register(PluginPermissionChecker.class, (Object)new HDFileUrlPermissionChecker());
        if (spm.isPluginLoaded("remotegui")) {
            spm.runIfPluginLoaded("promptdialog", () -> new Executable(){

                public void execute() {
                    spm.register(ServiceMethod.class, (Object)new UserHandler());
                    spm.register(ServiceMethod.class, (Object)new UserHandlerDetails());
                    FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                    combinedFile.add(((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/reporting/client/js/promptuserselectrenderer.js"));
                    combinedFile.addMessages(CLIENT_MSG);
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "promptdialog-core.js", combinedFile));
                    combinedFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
                    spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 200, "defaulttheme.css", combinedFile));
                    combinedFile.add(((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/reporting/client/css/defaulttheme.css"));
                    spm.runIfPluginLoaded("theme", () -> new Executable(){

                        public void execute() {
                            spm.register(ThemeResource.class, (Object)new ThemeResource(200, "remotegui", ((Object)((Object)this)).getClass().getClassLoader().getResource("com/inet/helpdesk/plugins/reporting/client/css/promptuserselect.less")));
                        }
                    });
                }
            });
        }
        spm.runIfPluginLoaded("adhoc", () -> new Executable(){

            public void execute() {
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_closed());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_open());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_inquiries());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_all());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_deleted());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_Abrechnung());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Tickets_Eskalationen());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_ITIL_Links());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Actions());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Locations());
            }
        });
        instance = this;
    }

    public void init(@Nonnull ServerPluginManager spm) {
        ConfigurationManager manager = ConfigurationManager.getInstance();
        Configuration config = manager.getCurrent();
        this.patchUDFconfig(config);
        this.patchRemoteSettings(config);
        Cache.setEngineFactory((EngineFactory)new HdEngineFactory((ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class)));
        this.updateDatasource();
        this.patchDataViewDefaults();
    }

    private void patchUDFconfig(Configuration config) {
        block11: {
            if (config != null) {
                HashSet<String> classSet;
                HDLogger.info("Config to be patched is: " + String.valueOf(config));
                String classes = config.get(CONFIG_EXPANDER_CLASS_KEY, "").trim();
                boolean changes = false;
                if (classes.length() > 0) {
                    HDLogger.info("Current expander classes: " + classes);
                    String[] parts = classes.split(",|;");
                    classSet = new HashSet(parts.length);
                    for (String string : parts) {
                        String string2 = string.trim();
                        if (string2.length() <= 0) continue;
                        classSet.add(string2);
                    }
                    changes |= classSet.remove("srv.ServerUtilities");
                } else {
                    HDLogger.info("Current expander classes: NONE");
                    classSet = new HashSet<String>(1);
                }
                if (changes) {
                    StringBuilder buffer = new StringBuilder();
                    for (String string : classSet) {
                        if (buffer.length() > 0) {
                            buffer.append(";");
                        }
                        buffer.append(string);
                    }
                    try {
                        if (ConfigurationManager.isWriteable((int)config.getScope())) {
                            HDLogger.info("Patching expander classes to: " + buffer.toString());
                            config.put(CONFIG_EXPANDER_CLASS_KEY, buffer.toString());
                            config.flush();
                            break block11;
                        }
                        HDLogger.warn("Can not patch expander classes, config is not writable!");
                    }
                    catch (BackingStoreException e) {
                        HDLogger.error(e);
                    }
                } else {
                    HDLogger.info("Config was not patched");
                }
            }
        }
    }

    private void patchRemoteSettings(Configuration config) {
        if (config != null) {
            if (ConfigurationManager.isWriteable((int)config.getScope())) {
                config.put(ConfigKey.RELOAD_ON_NEW_REQUEST.getKey(), "true");
                config.put(ConfigKey.ROWSOURCE_CACHE_ENABLED.getKey(), "false");
                config.put(ConfigKey.CACHE_TYPE.getKey(), "2");
                if (config.get(ConfigKey.STOP_AFTER_PAGE.getKey()) == null) {
                    config.put(ConfigKey.STOP_AFTER_PAGE.getKey(), "1000");
                }
                if (config.get(ConfigKey.ROW_LIMIT.getKey()) == null) {
                    config.put(ConfigKey.ROW_LIMIT.getKey(), "50000");
                }
            } else {
                HDLogger.warn("Config remote interface was not patched: no write access");
            }
        }
    }

    private void updateDatasource() {
        String ds_name = "HelpDesk";
        DatabaseConfigInfo hds = ((DatabaseConfigInfoList)DB_LIST.get()).get("HDS");
        if (hds == null) {
            HDLogger.warn("ReportingServerPlugin: No connection to DB!");
            return;
        }
        try {
            String password = hds.getDecodedPassword();
            String databaseclass = "";
            String driverclass = hds.getDriverClassName();
            switch (hds.getDriver()) {
                case inetora: {
                    databaseclass = DatabaseOracle.class.getName();
                    break;
                }
                case mysql: {
                    databaseclass = DatabaseMysql.class.getName();
                    break;
                }
                case mariadb: {
                    databaseclass = DatabaseMariaDB.class.getName();
                    break;
                }
                case inetdae7: {
                    databaseclass = DatabaseSqlServer.class.getName();
                    break;
                }
                default: {
                    databaseclass = null;
                }
            }
            DataSourceConfiguration config = DataSourceConfigurationManager.getDataSourceConfiguration((String)ds_name, (int)4);
            if (config == null) {
                config = DataSourceConfigurationManager.createDataSourceConfiguration((String)ds_name, (int)4);
            }
            config.setPassword(password);
            config.setSavePassword(true);
            config.setDatabaseClassname(databaseclass);
            config.setUser(hds.getUser());
            config.setDriverClassname(driverclass);
            if (hds.getCustomUrl() == null) {
                config.addProperty("host", hds.getHost());
                String port_instance = hds.getPort();
                try {
                    Integer.valueOf(port_instance);
                    config.addProperty("port", port_instance);
                    config.addProperty("instance", "");
                }
                catch (Exception e) {
                    config.addProperty("port", "");
                    config.addProperty("instance", port_instance);
                }
                config.addProperty("catalog", "");
                config.addProperty("database", hds.getCatalog());
                switch (hds.getDriver()) {
                    case mysql: {
                        config.setUrl("jdbc:mysql://{host}:{port}/{database}");
                        config.addProperty("serverTimezone", TimeZone.getDefault().getID());
                        break;
                    }
                    case mariadb: {
                        config.setUrl("jdbc:mariadb://{host}:{port}/{database}");
                        config.addProperty("serverTimezone", TimeZone.getDefault().getID());
                        break;
                    }
                    case inetora: {
                        config.setUrl("jdbc:inetora");
                        config.addProperty("sid", hds.getSid());
                        break;
                    }
                    default: {
                        config.setUrl("jdbc:inetdae7");
                        break;
                    }
                }
            } else {
                config.setUrl(hds.getCustomUrl());
            }
            config.save();
            if (ServerPluginManager.getInstance().isPluginLoaded("adhoc")) {
                DataSourceConfiguration ticketSource = DataSourceConfigurationManager.getDataSourceConfiguration((String)"HelpDeskTickets", (int)4);
                if (ticketSource == null) {
                    ticketSource = DataSourceConfigurationManager.createDataSourceConfiguration((String)"HelpDeskTickets", (int)4);
                }
                ticketSource.setDatabaseClassname(TicketDataSourceConfiguration.class.getName());
                ticketSource.save();
            }
        }
        catch (Exception e) {
            HDLogger.error(e);
        }
    }

    private void patchDataViewDefaults() {
        ServerPluginManager.getInstance().runIfPluginLoaded("adhoc", () -> new Executable(){

            public void execute() {
                DataView_GroupMembers view_usergroups = (DataView_GroupMembers)ServerPluginManager.getInstance().getSingleInstanceByName(TemplateDataViewDefaults.class, "group_members", false);
                view_usergroups.setOverriddenGetFunction(key -> {
                    if (key == TemplateDataViewDefaults.TABLE_COLUMNS) {
                        ArrayList<TableColumnData> list = new ArrayList<TableColumnData>();
                        list.add(new TableColumnData("UserAdhoc.username"));
                        if (DataSourceUtils.userFieldIsVisible((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) {
                            list.add(new TableColumnData("UserAdhoc." + HDUsersAndGroups.FIELD_LOCATION_ID.getKey()));
                        }
                        if (DataSourceUtils.userFieldIsVisible((UserField)HDUsersAndGroups.FIELD_ROOM)) {
                            list.add(new TableColumnData("UserAdhoc." + HDUsersAndGroups.FIELD_ROOM.getKey()));
                        }
                        return list.toArray(new TableColumnData[list.size()]);
                    }
                    if (key == TemplateDataViewDefaults.TABLE_GROUPS) {
                        return new GroupData[]{new GroupData("UserGroups.usergroupname", SortOrder.ASCENDING)};
                    }
                    if (key == TemplateDataViewDefaults.FILTER_DEFINITION) {
                        return new DataFilter(List.of(List.of(new DataFilter.DataFilterEntry("UserGroups.grouptype", DataFilter.Operation.equals, HDUsersAndGroups.GROUPTYPEDEF_RESOURCE.getDisplayName(), null))));
                    }
                    return null;
                });
            }
        });
    }

    static {
        CLIENT_MSG = new I18nMessages("com.inet.helpdesk.plugins.reporting.client.i18n.LanguageResources", ReportingServerPluginRegistration.class);
        DB_LIST = new ConfigValue<DatabaseConfigInfoList>(HDConfigKeys.DB_CONFIGS){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                if (instance != null) {
                    instance.updateDatasource();
                }
            }
        };
    }
}

