/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationMigrator;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;

public class EmailAccountIdConfigMigrator
implements ConfigurationMigrator {
    public void migrate(Configuration config) {
        String json = config.get(HDConfigKeys.MAIL_ACCOUNTS);
        try {
            EmailAccountList emailAccountList = EmailAccountList.valueOf(json);
            boolean changed = false;
            for (EmailAccount acc : emailAccountList) {
                if (acc.getID() != null) continue;
                acc.setId(GUID.generateNew().toString());
                changed = true;
            }
            if (changed) {
                config.put(HDConfigKeys.MAIL_ACCOUNTS, new Json().toJson((Object)emailAccountList));
            }
        }
        catch (JsonException ex) {
            HDLogger.error((Object)ex);
        }
    }
}

