/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;

public class DefaultUserImage {
    public static BufferedImage createImage(String userDisplayName) {
        if ((userDisplayName = userDisplayName.replaceAll("\\\\", "/")).indexOf(47) > -1) {
            userDisplayName = userDisplayName.substring(userDisplayName.indexOf(47) + 1);
        }
        String value = DefaultUserImage.generateInitials(userDisplayName);
        BufferedImage img = new BufferedImage(300, 300, 5);
        Color color = null;
        int min = 60;
        int max = 160;
        int diff = max - min;
        int x = userDisplayName.hashCode();
        int y = Math.abs(x % (6 * diff));
        switch (y / diff) {
            case 0: {
                color = new Color(max, min, min + y);
                break;
            }
            case 1: {
                color = new Color(max - (y -= diff), min, max);
                break;
            }
            case 2: {
                color = new Color(min, min + (y -= 2 * diff), max);
                break;
            }
            case 3: {
                color = new Color(min, max, max - (y -= 3 * diff));
                break;
            }
            case 4: {
                color = new Color(min + (y -= 4 * diff), max, min);
                break;
            }
            case 5: {
                color = new Color(max, max - (y -= 5 * diff), min);
            }
        }
        Graphics graphics = img.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
        if (!value.isEmpty()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Font font = graphics.getFont();
            TextLayout lay = null;
            double width = img.getWidth(null);
            double height = img.getHeight(null);
            float size = img.getHeight();
            while (width >= (double)img.getWidth(null) * 0.75 || height >= (double)img.getHeight(null) * 0.75) {
                font = font.deriveFont(size -= 1.0f);
                lay = new TextLayout(value, font, ((Graphics2D)graphics).getFontRenderContext());
                width = lay.getBounds().getWidth();
                height = lay.getBounds().getHeight();
            }
            graphics.setFont(font);
            int offsetX = (int)(((double)img.getWidth(null) - width) / 2.0 - lay.getBounds().getX());
            int offsetY = (int)(((double)img.getHeight(null) + height) / 2.0);
            graphics.setColor(Color.WHITE);
            graphics.drawString(value, offsetX, offsetY);
        }
        return img;
    }

    static String generateInitials(String userDisplayName) {
        String[] names = userDisplayName.split(" |-");
        StringBuilder builder = new StringBuilder(names.length);
        for (String part : names) {
            if (part.isEmpty()) continue;
            for (int i = 0; i < part.length(); ++i) {
                char ch = part.charAt(i);
                if (i != 0 && (ch < 'A' || ch > 'Z')) continue;
                builder.append(ch);
            }
        }
        if (builder.length() > 3) {
            builder.setLength(3);
        }
        return builder.toString().toUpperCase();
    }
}

