/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.model.ticket.Action;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ActionDataProvider {
    private static final Set<Integer> UNSEEN_ACTIONS = new HashSet<Integer>(){
        {
            this.add(5);
            this.add(-9);
            this.add(-12);
            this.add(8);
        }
    };

    private ActionDataProvider() {
    }

    private static Action toAction(ActionVO vo) {
        return vo != null ? new Action(vo.getId(), vo.getDisplayValue(), vo.getStatusID(), vo.isHidden(), vo.isInternal(), vo.isDeleted(), vo.getSpecial()) : null;
    }

    public static Action getAction(int aktID) {
        return ActionDataProvider.toAction((ActionVO)ActionManager.getInstance().get(aktID));
    }

    public static ArrayList<Action> getAllActions() {
        return new ArrayList<Action>(ActionManager.getInstance().getAll(false).stream().map(ActionDataProvider::toAction).collect(Collectors.toList()));
    }

    public static int[] getUnseenStates() {
        return ActionManager.getInstance().getAll(true).stream().filter(a -> UNSEEN_ACTIONS.contains(a.getId())).mapToInt(a -> a.getStatusID()).distinct().toArray();
    }
}

