/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class TicketViewCategory {
    public static final String KEY_GLOBAL_SEARCH = "globalsearch";
    public static final String KEY_GLOBAL_VIEWS = "globalviews";
    public static final String KEY_MY_VIEWS = "myviews";
    public static final String KEY_SUPERVISOR = "supervisor";
    public static final String KEY_ITIL = "itil";
    public static final String KEY_PRIORITY = "priority";
    private String key;
    private Supplier<String> displayName;
    private Supplier<String> description;

    public TicketViewCategory(@Nonnull String key) {
        this(key, () -> Tickets.MSG.getMsg("viewgroup." + key, new Object[0]));
    }

    public TicketViewCategory(@Nonnull String key, @Nonnull Supplier<String> displayName) {
        this(key, displayName, null);
    }

    public TicketViewCategory(@Nonnull String key, @Nonnull Supplier<String> displayName, @Nullable Supplier<String> description) {
        this.key = key;
        this.displayName = displayName;
        this.description = description;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public String getDescription() {
        return this.description != null ? this.description.get() : null;
    }
}

