/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.classloader.translations.TranslationKey;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Comparator;
import javax.annotation.Nullable;

public class TicketFieldDefinitionTicketOwnerLocationInfo
extends TicketFieldDefinition {
    public TicketFieldDefinitionTicketOwnerLocationInfo(int prio) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET_OWNER, "ticketowner." + String.valueOf((Object)HDUsersAndGroups.FIELD_LOCATION_ID) + ".info", true, false, prio);
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        LocationVO location;
        Integer locationID;
        GUID ownerID = ticket.getOwnerID();
        if (ownerID == null) {
            return null;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
        if (userAccount != null && (locationID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) != null && (location = (LocationVO)LocationManager.getInstance().get(locationID)) != null) {
            return location.getComment();
        }
        return null;
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(HDUsersAndGroups.FIELD_LOCATION_ID.getKey()) + "-Info";
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }

    public TranslationKey getLabelTranslationKey() {
        return null;
    }

    public String getDescription() {
        return null;
    }
}

