/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.dataview;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.reporting.server.dataview.TemplateDataViewDefaultsHD;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataView_Actions
extends TemplateDataViewDefaultsHD {
    @Nonnull
    public String getExtensionName() {
        return "helpdesk_actions";
    }

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        ArrayList<TemplateDataViewDefaults.Column> list = new ArrayList<TemplateDataViewDefaults.Column>();
        list.add(new TemplateDataViewDefaults.Column("tblAktionen.AktBezeichnung", "Bezeichnung", 11));
        list.add(new TemplateDataViewDefaults.Column("tblAktionen.AktPauschale", "Kostenpauschale", 6));
        list.add(new TemplateDataViewDefaults.Column("tblStatus.StatusBezeichnung", "Folgestatus", 11));
        list.add(new TemplateDataViewDefaults.Column("@EnduserInvisible", "Unsichtbar", 8));
        list.add(new TemplateDataViewDefaults.Column("@Deleted", "Gel\u00f6scht", 8));
        list.add(new TemplateDataViewDefaults.Column("@Intern", "Intern", 8));
        return list;
    }

    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            ArrayList<TableColumnData> list = new ArrayList<TableColumnData>();
            list.add(new TableColumnData("tblAktionen.AktBezeichnung"));
            list.add(new TableColumnData("tblStatus.StatusBezeichnung"));
            return (T)list.toArray(new TableColumnData[0]);
        }
        return null;
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            DatabaseTables dbTables = engine.getDatabaseTables();
            Datasource hd = dbTables.createDatasource("HelpDesk");
            hd.setDataSourceConfiguration(DataSourceConfigurationManager.getDataSource((String)"HelpDesk"));
            TableSource aktionen = hd.createTableSource("tblAktionen");
            TableSource status = hd.createTableSource("tblStatus");
            aktionen.addColumn("AktBezeichnung", 11);
            aktionen.addColumn("AktPauschale", 11);
            aktionen.addColumn("UserInVis", 6);
            aktionen.addColumn("geloescht", 6);
            aktionen.addColumn("intern", 6);
            status.addColumn("StatusBezeichnung", 11);
            engine.getFields().addFormulaField("Deleted", "CBool({tblAktionen.geloescht})", 0);
            engine.getFields().addFormulaField("Intern", "CBool({tblAktionen.intern})", 0);
            engine.getFields().addFormulaField("EnduserInvisible", "CBool({tblAktionen.UserInVis})", 0);
            DataSourceUtils.join((DatabaseTables)dbTables, (TableSource)aktionen, (String)"Status", (TableSource)status, (String)"Status", (int)6);
            this.setSelectionFormula(engine, filter);
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
             @Nonnull TemplateDataViewDefaults.Column> fields = new ArrayList<TemplateDataViewDefaults.Column>();
            fields.addAll(this.getAvailableColumns());
            return new SimpleDataView(fields, engine);
        }
        catch (ReportException e) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)e);
        }
    }
}

