/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.general;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.general.AbstractData;
import com.inet.helpdesk.shared.model.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@JsonData
public class Entry
extends AbstractData {
    private static final long serialVersionUID = 1L;
    private ArrayList<Entry> children = new ArrayList();

    public Entry() {
    }

    public Entry(int typeId, int keyId, String displayName) {
        this(typeId, keyId, null, displayName);
    }

    public Entry(int typeId, int keyId, String stringKey, String displayName) {
        super(typeId, keyId, displayName);
        this.setStringKey(stringKey);
    }

    public void addChild(Entry child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public ArrayList<Entry> getChildren() {
        return this.children;
    }

    @Override
    public void updateTreeData(Boolean parentWritable, final String userDisplayName) {
        Collections.sort(this.children, new Comparator<Entry>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public int compare(Entry o1, Entry o2) {
                String o2Display;
                block9: {
                    if (o1.getTypeId() == 7) {
                        Boolean type2 = (Boolean)o2.getData(Field.RESOURCE_ITILMASTERTYPE, Boolean.FALSE);
                        Boolean type1 = (Boolean)o1.getData(Field.RESOURCE_ITILMASTERTYPE, Boolean.FALSE);
                        if (type2.booleanValue() == type1.booleanValue()) {
                            if (o1.getId() == o2.getId()) {
                                return 0;
                            }
                            break block9;
                        } else {
                            if (type2.booleanValue()) {
                                return -1;
                            }
                            return 1;
                        }
                    }
                    if (o1.getTypeId() == 2) {
                        return o2.getId() - o1.getId();
                    }
                }
                String o1Display = o1.getDisplayName() == null ? "" : o1.getDisplayName();
                String string = o2Display = o2.getDisplayName() == null ? "" : o2.getDisplayName();
                if (o1.getTypeId() == 9) {
                    if (o1Display.equals(userDisplayName)) {
                        return -1;
                    }
                    if (o2Display.equals(userDisplayName)) {
                        return 1;
                    }
                }
                return o1Display.compareToIgnoreCase(o2Display);
            }
        });
        Boolean ownValue = (Boolean)this.getData(Field.RESOURCE_WRITABLE, null);
        if (parentWritable != null && ownValue == null && !parentWritable.booleanValue()) {
            this.setWriteable(false);
            ownValue = parentWritable;
        }
        if (this.children.size() > 0) {
            if (ownValue == null) {
                boolean anyChildWritable = false;
                for (Entry child : this.children) {
                    child.updateTreeData(ownValue, userDisplayName);
                    anyChildWritable |= child.isWriteable();
                }
                if (!anyChildWritable) {
                    this.setWriteable(false);
                }
            } else {
                for (Entry child : this.children) {
                    child.updateTreeData(ownValue, userDisplayName);
                }
            }
        }
    }

    public Entry getChildByID(int id) {
        for (Entry child : this.children) {
            if (child.getId() != id) continue;
            return child;
        }
        return null;
    }

    @Override
    public String toString() {
        return "Entry: type=" + this.getTypeId() + ", id=" + this.getId() + ", name=" + this.getDisplayName();
    }
}

