/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import java.util.ArrayList;
import java.util.List;

public class FilterTicketsResult {
    private List<Integer> readTicketIds;
    private List<Integer> unreadTicketIds;

    public FilterTicketsResult(List<Integer> readTicketIds, List<Integer> unreadTicketIds) {
        this.throwIfNullOrContainsNull(readTicketIds, "readTicketIds");
        this.throwIfNullOrContainsNull(unreadTicketIds, "unreadTicketIds");
        this.readTicketIds = readTicketIds;
        this.unreadTicketIds = unreadTicketIds;
    }

    private void throwIfNullOrContainsNull(List<Integer> list, String name) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("list %s must not be null", name));
        }
        if (list.contains(null)) {
            throw new IllegalArgumentException(String.format("list %s must not contain null", name));
        }
    }

    public List<Integer> getAllTicketIds() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.addAll(this.readTicketIds);
        list.addAll(this.unreadTicketIds);
        return list;
    }

    public List<Integer> getReadTicketIds() {
        return this.readTicketIds;
    }

    public List<Integer> getUnreadTicketIds() {
        return this.unreadTicketIds;
    }

    public int getNumberOfAllTickets() {
        return this.getNumberOfReadTickets() + this.getNumberOfUnreadTickets();
    }

    public int getNumberOfReadTickets() {
        return this.readTicketIds.size();
    }

    public int getNumberOfUnreadTickets() {
        return this.unreadTicketIds.size();
    }
}

