/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.stopwatch;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator2;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.config.stopwatch.ConditionType;
import com.inet.helpdesk.config.stopwatch.StopWatchConfig;
import com.inet.helpdesk.config.stopwatch.StopWatchList;
import com.inet.helpdesk.config.stopwatch.StopWatchRule;
import com.inet.helpdesk.config.stopwatch.StopWatchSetting;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonData
public class StopWatchConfigProperty
extends ItemListConfigProperty {
    public StopWatchConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, HDConfigKeys.STOP_WATCH_RULES.getKey(), "StopWatchRules", StopWatchConfigProperty.getObjectListValue(settings, translator), null, new ConfigRowAction[]{StopWatchConfigProperty.getRowAction(settings, translator)});
        this.setManuallySortable(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings, Translator translator) {
        List cls = (List)settings.getChangedValue(HDConfigKeys.STOP_WATCH_RULES.getKey(), List.class);
        StopWatchList list = cls != null ? StopWatchConfig.getStopWatchSettingsFromConfigGUI(cls) : (StopWatchList)new Json().fromJson(settings.getValue(HDConfigKeys.STOP_WATCH_RULES), StopWatchList.class);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (StopWatchRule classification : list) {
            HashMap<String, String> entry = StopWatchConfigProperty.convertToHashmap(classification, translator);
            result.add(entry);
        }
        return result;
    }

    private static HashMap<String, String> convertToHashmap(StopWatchRule rule, Translator translator) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ConditionType", rule.getCondition().getType().name());
        result.put("ConditionParameter", StringFunctions.stringValueOf((Object)rule.getCondition().getParameter()));
        result.put("ConditionParameterRess", StringFunctions.stringValueOf((Object)rule.getCondition().getParameter()));
        result.put("Setting", rule.getSetting().name());
        Object conditionStr = translator.translate("stopwatch.conditiontype." + rule.getCondition().getType().name());
        if (rule.getCondition().getParameter() != null) {
            UserGroupInfo group = UserGroupManager.getInstance().getGroup(rule.getCondition().getParameter());
            conditionStr = group == null ? (String)conditionStr + " <Deleted Group>" : (String)conditionStr + " " + group.getDisplayName();
        }
        String settingStr = translator.translate("stopwatch.setting." + rule.getSetting().name());
        result.put("previewText", translator.translate(new String[]{"stopwatch.rules.preview", conditionStr, settingStr}));
        return result;
    }

    private static ConfigRowAction getRowAction(ConfigStructureSettings settings, Translator translator) {
        ConfigAction action = new ConfigAction("stopwatchrule.new", translator.translate("stopwatch.rules.add"));
        ConfigCategory category = new ConfigCategory(0, "stopwatchrule.new", translator.translate("stopwatch.rules.add"), "ticket.settings.stopwatch");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "classification.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<SelectConfigProperty> propertyList = new ArrayList<SelectConfigProperty>();
        properties.put("classification.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        List<LocalizedKey> conditionTypes = StopWatchConfig.getConditions();
        List<LocalizedKey> ressisAndGroups = StopWatchConfig.getResourcesAndGroups();
        List<LocalizedKey> ressis = StopWatchConfig.getResources();
        List<LocalizedKey> watchSettings = StopWatchConfig.getSettings();
        propertyList.add(new SelectConfigProperty(123, "ConditionType", "SimpleText", translator.translate("stopwatch.rules.condition"), (Object)conditionTypes.get(0).getKey(), translator.translate("stopwatch.rules.condition.tooltip"), conditionTypes));
        propertyList.add(new SelectConfigProperty(123, "ConditionParameter", "SimpleText", translator.translate("stopwatch.rules.parameter"), (Object)"", translator.translate("stopwatch.rules.parameter.tooltip"), ressisAndGroups));
        propertyList.add(new SelectConfigProperty(123, "ConditionParameterRess", "SimpleText", translator.translate("stopwatch.rules.parameter"), (Object)"", translator.translate("stopwatch.rules.parameter.tooltip"), ressis));
        propertyList.add(new SelectConfigProperty(123, "Setting", "SimpleText", translator.translate("stopwatch.rules.setting"), (Object)StopWatchSetting.OFF, translator.translate("stopwatch.rules.setting.tooltip"), watchSettings));
        conditions.add(ConditionGenerator2.prop((String)"ConditionParameter").visibleIf(ConditionGenerator2.prop((String)"ConditionType").equalTo((Object)ConditionType.UserIsInGroup.name())));
        conditions.add(ConditionGenerator2.prop((String)"ConditionParameterRess").visibleIf(ConditionGenerator2.prop((String)"ConditionType").equalTo((Object)ConditionType.TicketIsInResource.name())));
        return rowAction;
    }
}

