/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.helpdesk.config.mailtemplates.data.SaveMailTemplatesEditorRequest;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplatesHelper;
import com.inet.helpdesk.core.mailtemplates.MailTemplate;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SaveMailTemplatesEditor
extends ServiceMethod<SaveMailTemplatesEditorRequest, Void> {
    public String getMethodName() {
        return "mailtemplates.savemailtemplateseditor";
    }

    public short getMethodType() {
        return 1;
    }

    public Void invoke(HttpServletRequest req, HttpServletResponse resp, SaveMailTemplatesEditorRequest payload) throws IOException {
        MailTemplatesHelper.checkInvalidName(payload.getName());
        String htmlData = payload.getHtmlData();
        String htmlSubject = payload.getHtmlSubject();
        String textData = payload.getTextData();
        String textSubject = payload.getTextSubject();
        boolean textIsGenerated = payload.isTextGenerated();
        MailTemplateData mailTemplateData = MailTemplatesManager.getTemplate(payload.getName(), payload.getSet(), payload.getLang());
        mailTemplateData.setTextGenerated(textIsGenerated);
        boolean isSubTemplate = false;
        try {
            MailTemplate predefinedTemplate = (MailTemplate)ServerPluginManager.getInstance().getSingleInstanceByName(MailTemplate.class, payload.getName(), false);
            isSubTemplate = predefinedTemplate.isSubTemplate();
        }
        catch (IllegalStateException predefinedTemplate) {
            // empty catch block
        }
        if (!isSubTemplate) {
            if (!StringFunctions.isEmpty((String)htmlData) && StringFunctions.isEmpty((String)htmlSubject)) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates.emptyhtmlsubject", new Object[0]));
            }
            if (!StringFunctions.isEmpty((String)textData) && !textIsGenerated && StringFunctions.isEmpty((String)textSubject)) {
                throw new ClientMessageException(HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates.emptytextsubject", new Object[0]));
            }
        }
        if (payload.isHtmlChanged()) {
            if (StringFunctions.isEmpty((String)htmlData)) {
                mailTemplateData.setHtmlData(null);
            } else if (isSubTemplate) {
                mailTemplateData.setHtmlData(htmlData);
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("<html>\n");
                builder.append("   <head>\n");
                if (!StringFunctions.isEmpty((String)htmlSubject)) {
                    builder.append("       <title>");
                    builder.append(StringFunctions.encodeHTML((String)htmlSubject, (boolean)false));
                    builder.append("</title>\n");
                }
                builder.append("   </head>\n");
                builder.append("   <body>\n");
                builder.append(payload.getHtmlData()).append("\n");
                builder.append("   </body>\n");
                builder.append("</html>\n");
                mailTemplateData.setHtmlData(builder.toString());
            }
        }
        if (payload.isTextChanged()) {
            if (StringFunctions.isEmpty((String)textData)) {
                mailTemplateData.setTextData(null);
            } else {
                if (isSubTemplate || textSubject == null) {
                    textSubject = "";
                }
                mailTemplateData.setTextData(textSubject + "\n\n" + this.optionalTrim(MailTemplatesManager.convertToPlainText(textData)));
            }
        }
        MailTemplatesManager.createOrUpdateTemplate(mailTemplateData);
        return null;
    }

    private String optionalTrim(String str) {
        if (str.endsWith("\n")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }
}

