/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.List;
import java.util.Map;

public class MSSQLPatcher
implements IModelComparator {
    @Override
    public Node compare(Node source, Node target, DatabaseInfos sourceInfos, DatabaseInfos targetInfos) {
        return this.compare(source, target);
    }

    private Node compare(Node source, Node target) {
        if (source.getName() == target.getName()) {
            List<? extends Node> children;
            if (source.getName() == NodeFactory.TAG.column && source.getName() == NodeFactory.TAG.column) {
                String defaultValue;
                String type;
                if ("true".equalsIgnoreCase(target.getParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name()))) {
                    source.readParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name(), "true");
                }
                if ((type = target.getParameter(IDatabaseInfos.COLUMN_PARAM.data_type.name())) != null && type.matches("-\\d+")) {
                    for (Map.Entry entry : target.getAttributeMap().entrySet()) {
                        source.readParameter(entry.getKey().toString(), (String)entry.getValue());
                    }
                }
                if ((defaultValue = source.getParameter(IDatabaseInfos.COLUMN_PARAM.column_def.name())) != null && "SYSDATE".equalsIgnoreCase(defaultValue)) {
                    source.readParameter(IDatabaseInfos.COLUMN_PARAM.column_def.name(), "getdate()");
                }
            }
            if ((children = source.getAllChildren()) != null) {
                for (Node node : children) {
                    Node tChild = target.findChildMatching(node.getKeyValueLowerCase(), node.getName());
                    if (tChild == null) continue;
                    this.compare(node, tChild);
                }
            }
        }
        return source;
    }
}

