/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.JobAlterTable;
import com.inet.dbupdater.jobrunner.jobs.JobCopyData;
import com.inet.dbupdater.jobrunner.jobs.JobCreateDB;
import com.inet.dbupdater.jobrunner.jobs.JobCreateData;
import com.inet.dbupdater.jobrunner.jobs.JobCreateFunction;
import com.inet.dbupdater.jobrunner.jobs.JobCreateProcedure;
import com.inet.dbupdater.jobrunner.jobs.JobCreateSequence;
import com.inet.dbupdater.jobrunner.jobs.JobCreateTable;
import com.inet.dbupdater.jobrunner.jobs.JobCreateTrigger;
import com.inet.dbupdater.jobrunner.jobs.JobCreateView;
import com.inet.dbupdater.jobrunner.jobs.JobPrepareTables;
import com.inet.dbupdater.jobrunner.jobs.JobTestTables;
import com.inet.dbupdater.jobrunner.jobs.JobVersionScript;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.util.List;

public class JobFactory {
    private static Logger logger = LogManager.getLogger((String)"DB Updater");
    private DatabaseInfos targetDB;
    private DatabaseInfos sourceDB;
    private Node fromModel;
    private Node toModel;
    private final boolean isUpdate;

    public JobFactory(DatabaseInfos targetDB, DatabaseInfos sourceDB, Node fromModel, Node toModel, boolean isUpdate) {
        this.targetDB = targetDB;
        this.sourceDB = sourceDB;
        this.fromModel = fromModel;
        this.toModel = toModel;
        this.isUpdate = isUpdate;
    }

    public JobStructure createJobList(Node model) throws IllegalStateException {
        logger.info((Object)"Job Factory starting");
        JobStructure jobList = new JobStructure();
        logger.info((Object)"Creating Jobs from structure");
        if (model != null) {
            this.crawlNode(jobList, model);
        }
        if (this.sourceDB != null) {
            jobList.add(new JobCopyData(this.sourceDB, this.targetDB, this.fromModel, this.toModel));
        }
        logger.info((Object)"Job Factory finished");
        return jobList;
    }

    private void crawlNode(JobStructure jobList, Node currentNode) {
        NodeFactory.TAG name = currentNode.getName();
        int state = currentNode.getState();
        if (name == NodeFactory.TAG.dbupdater) {
            this.crawlAllChildren(jobList, currentNode);
        }
        if (name == NodeFactory.TAG.database) {
            if (state == 2) {
                return;
            }
            if (state == 0) {
                JobStructure createCommands = new JobCreateDB().createCommands(this.targetDB, currentNode);
                jobList.addAll(createCommands);
            }
            jobList.addAll(new JobPrepareTables().createCommands(this.targetDB, currentNode));
            this.crawlAllChildren(jobList, currentNode);
        }
        if (name == NodeFactory.TAG.table) {
            if (state == 2) {
                // empty if block
            }
            if (state == 0) {
                jobList.addAll(new JobCreateTable().createCommands(this.targetDB, currentNode));
            }
            if (state == 1) {
                jobList.addAll(new JobAlterTable().createCommands(this.targetDB, currentNode));
            }
            jobList.addAll(new JobTestTables().createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.trigger) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobCreateTrigger(currentNode.getState()).createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.view) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobCreateView(currentNode.getState()).createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.procedure) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobCreateProcedure(currentNode.getState()).createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.function) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobCreateFunction(currentNode.getState()).createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.customscripts) {
            this.crawlAllChildren(jobList, currentNode);
        }
        if (name == NodeFactory.TAG.version) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobVersionScript(this.isUpdate, this.sourceDB).createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.data) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobCreateData().createCommands(this.targetDB, currentNode));
            return;
        }
        if (name == NodeFactory.TAG.sequence) {
            if (state == 2) {
                return;
            }
            jobList.addAll(new JobCreateSequence(currentNode.getState()).createCommands(this.targetDB, currentNode));
            return;
        }
    }

    private void crawlAllChildren(JobStructure jobList, Node currentNode) {
        if (currentNode == null) {
            return;
        }
        List<? extends Node> children = currentNode.getAllChildren();
        if (children == null) {
            return;
        }
        for (Node node : children) {
            this.crawlNode(jobList, node);
        }
    }
}

