/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.DatabaseInfosMariaDB;
import com.inet.dbupdater.databases.DatabaseInfosMySQL;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCreateDatabaseCommand;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.Node;
import java.sql.SQLException;

public class MySQLCreateDatabaseCommand
extends DefaultCreateDatabaseCommand {
    private static final char[] INVALID_CHARS = new char[]{'.', '/', '\\', '\u0000'};
    private final String collation;
    private DatabaseInfos dbInfo_;
    private final String name_;

    public MySQLCreateDatabaseCommand(DatabaseInfos dbInfo, Node databaseNode) {
        super(dbInfo, databaseNode);
        if (dbInfo instanceof DatabaseInfosMariaDB) {
            this.collation = ((DatabaseInfosMariaDB)dbInfo).getDatabaseCreateCollation();
        } else if (dbInfo instanceof DatabaseInfosMySQL) {
            this.collation = ((DatabaseInfosMySQL)dbInfo).getDatabaseCreateCollation();
        } else {
            this.collation = "utf8mb4_unicode_ci";
            logger.error((Object)("in create command with strange DatabaseInfos: " + String.valueOf(dbInfo)));
        }
        String dbName = dbInfo.getDBConnection().getDatabaseName();
        for (char c : INVALID_CHARS) {
            int index = dbName.indexOf(c);
            if (index < 0) continue;
            throw new IllegalArgumentException("Illegal character '" + c + "' at index " + index + " in database name '" + dbName + "'");
        }
        this.name_ = databaseNode.getParameter(IDatabaseInfos.DATABASE_PARAM.name.name());
        this.dbInfo_ = dbInfo;
    }

    @Override
    protected void createDBUser(DatabaseInfos dbInfo, String accountUser, String accountPassword) throws SQLException {
        DBConnection dbCon = dbInfo.getDBConnection();
        try {
            dbCon.executeUpdate(String.format("CREATE USER '%s'@'localhost' IDENTIFIED BY '%s'", accountUser, accountPassword), String.format("CREATE USER '%s'@'localhost' IDENTIFIED BY 'xxxxxxxx'", accountUser));
            dbCon.executeUpdate(String.format("CREATE USER '%s'@'%%' IDENTIFIED BY '%s'", accountUser, accountPassword), String.format("CREATE USER '%s'@'%%' IDENTIFIED BY 'xxxxxxxx'", accountUser));
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("CREATE USER failed") || ex.toString().contains("CREATE USER failed") || ex.getCause() != null && ex.getCause().getMessage().contains("CREATE USER failed")) {
                logger.debug((Object)String.format("Login %s already exist - no problem, but if the password is different, then you cannot connect after update.", accountUser));
            }
            throw ex;
        }
        String dbName = dbCon.getDatabaseName();
        dbCon.executeUpdate(String.format("GRANT ALL PRIVILEGES ON %s.* TO '%s'@'localhost'", dbName, accountUser));
        dbCon.executeUpdate(String.format("GRANT ALL PRIVILEGES ON %s.* TO '%s'@'%%'", dbName, accountUser));
        dbCon.execute("FLUSH PRIVILEGES");
    }

    @Override
    public String getSqlStatement() {
        try {
            return "CREATE DATABASE " + this.dbInfo_.getQuoteIdentiferIfNeeded(this.name_) + " CHARACTER SET utf8mb4 COLLATE " + this.collation;
        }
        catch (SQLException e) {
            return "CREATE DATABASE " + this.name_ + " CHARACTER SET utf8mb4 COLLATE " + this.collation;
        }
    }
}

