/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class BaseAlterColumnCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;

    public BaseAlterColumnCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    protected DatabaseInfos getDbInfo() {
        return this.dbInfo;
    }

    protected List<ReferenceNodeData> getAllRefs(Node column, boolean onTable) {
        String refColumn = onTable ? null : column.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name());
        String refTable = column.getParent().getParameter(IDatabaseInfos.TABLE_PARAM.name.name());
        Node thisTable = column.getParent();
        Node database = thisTable.getParent();
        Map<String, Node> allTablesSource = database.getDiffSource().getChildren(NodeFactory.TAG.table).stream().collect(Collectors.toMap(node -> node.getParameter(IDatabaseInfos.TABLE_PARAM.name.name()), item -> item));
        Map<String, Node> allTablesTarget = database.getDiffTarget().getChildren(NodeFactory.TAG.table).stream().collect(Collectors.toMap(node -> node.getParameter(IDatabaseInfos.TABLE_PARAM.name.name()), item -> item));
        HashMap<String, Node> sourceRefs = new HashMap<String, Node>();
        ArrayList<ReferenceNodeData> refs = new ArrayList<ReferenceNodeData>();
        for (Map.Entry<String, Node> table : allTablesSource.entrySet()) {
            Node node2 = this.getReferenceBind(table.getValue(), refColumn, refTable);
            if (node2 == null) continue;
            if (allTablesTarget.containsKey(table.getKey())) {
                sourceRefs.put(node2.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()), node2);
                continue;
            }
            refs.add(new ReferenceNodeData(node2, null));
        }
        HashMap<String, Node> targetRefs = new HashMap<String, Node>();
        for (Node node3 : allTablesTarget.values()) {
            Node ref = this.getReferenceBind(node3, refColumn, refTable);
            if (ref == null) continue;
            targetRefs.put(ref.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()), ref);
        }
        for (Map.Entry entry : sourceRefs.entrySet()) {
            Node newRef = (Node)targetRefs.get(entry.getKey());
            if (newRef == null) continue;
            Node mergeNode = newRef.replicate(newRef.getState());
            mergeNode.setDiffReferences((Node)entry.getValue(), newRef);
            refs.add(new ReferenceNodeData((Node)entry.getValue(), newRef));
        }
        return refs;
    }

    private Node getReferenceBind(Node table, String refColumn, String refTable) {
        List<? extends Node> refs = table.getChildren(NodeFactory.TAG.reference);
        if (refs == null || refs.size() == 0) {
            return null;
        }
        for (Node node : refs) {
            if (refColumn != null && !refColumn.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.pkcolumn_name.name())) || !refTable.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.pktable_name.name()))) continue;
            return node;
        }
        return null;
    }

    protected List<IComposedCommand> wrapInReferenceUnbind(Node element, boolean unbindIndices) throws SQLException {
        List<Object> indices;
        ICommandFactory factory = this.dbInfo.getCommandFactory();
        List<ReferenceNodeData> allRefs = this.getAllRefs(element, false);
        List<Object> list = indices = unbindIndices ? this.getIndexBind(element) : new ArrayList();
        if (!allRefs.isEmpty() || !indices.isEmpty()) {
            ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
            for (ReferenceNodeData referenceNodeData : allRefs) {
                IComposedCommand iComposedCommand = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.reference, IDatabaseCommand.TIME.dropreferences, referenceNodeData.getOldNode().getParent(), null);
                commands.add(iComposedCommand);
                IComposedCommand.addToList(commands, iComposedCommand.addDataset(referenceNodeData.getOldNode(), ICommandFactory.COMMAND_TYPE.remove));
            }
            HashSet<String> droppedNames = new HashSet<String>();
            for (Node node : indices) {
                String string = node.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
                if (droppedNames.contains(string)) continue;
                droppedNames.add(string);
                IComposedCommand dropIndex = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.index, IDatabaseCommand.TIME.dropreferences, node.getParent(), string);
                commands.add(dropIndex);
                IComposedCommand.addToList(commands, dropIndex.addDataset(node, ICommandFactory.COMMAND_TYPE.remove));
            }
            commands.add(this);
            HashMap<String, IComposedCommand> hashMap = new HashMap<String, IComposedCommand>();
            for (Node node : indices) {
                String indexName = node.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
                if (hashMap.containsKey(indexName)) {
                    IComposedCommand command = (IComposedCommand)hashMap.get(indexName);
                    command.addDataset(node, ICommandFactory.COMMAND_TYPE.create);
                    continue;
                }
                ICommandFactory.COMMAND_TYPE type = ICommandFactory.COMMAND_TYPE.create;
                IDatabaseCommand.TIME time = IDatabaseCommand.TIME.addindices;
                if (indexName != null && indexName.equals("PRIMARY")) {
                    type = ICommandFactory.COMMAND_TYPE.alter;
                    time = IDatabaseCommand.TIME.addreferences;
                }
                IComposedCommand addIndex = factory.getCommand(type, NodeFactory.TAG.index, time, node.getParent(), indexName);
                commands.add(addIndex);
                IComposedCommand.addToList(commands, addIndex.addDataset(node, ICommandFactory.COMMAND_TYPE.create));
                hashMap.put(indexName, addIndex);
            }
            for (ReferenceNodeData referenceNodeData : allRefs) {
                if (referenceNodeData.getNewNode() == null) continue;
                IComposedCommand addRef = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.reference, IDatabaseCommand.TIME.addreferences, referenceNodeData.getOldNode().getParent(), null);
                commands.add(addRef);
                IComposedCommand.addToList(commands, addRef.addDataset(referenceNodeData.getNewNode(), ICommandFactory.COMMAND_TYPE.create));
            }
            return commands;
        }
        return null;
    }

    List<Node> getIndexBind(Node element) {
        String refColumn = element.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name());
        Node sourceTable = element.getDiffSource().getParent();
        List<? extends Node> indices = sourceTable.getChildren(NodeFactory.TAG.index);
        ArrayList<Node> toBeRemoved = new ArrayList<Node>();
        if (indices == null || indices.size() == 0) {
            return toBeRemoved;
        }
        List<? extends Node> tIndices = element.getDiffTarget().getParent().getChildren(NodeFactory.TAG.index);
        HashSet<String> indexNames = new HashSet<String>();
        for (Node node : indices) {
            if (!this.isIndexOf(node, element, refColumn)) continue;
            indexNames.add(node.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name()));
        }
        for (Node node : indices) {
            String indexName = node.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
            if (!indexNames.contains(indexName)) continue;
            Node tIndex = null;
            if (tIndices != null) {
                for (Node node2 : tIndices) {
                    if (!node2.equals(node)) continue;
                    tIndex = node2;
                    break;
                }
            }
            if (tIndex != null) {
                Node newIndex = node.replicate(1);
                newIndex.setDiffReferences(node, tIndex);
                newIndex.setParent(element.getParent());
                toBeRemoved.add(newIndex);
                continue;
            }
            toBeRemoved.add(node);
        }
        return toBeRemoved;
    }

    private boolean isIndexOf(Node indexNode, Node columnNode, String columnName) {
        if (!columnName.equalsIgnoreCase(indexNode.getParameter(IDatabaseInfos.INDEX_PARAM.column_name.name()))) {
            return false;
        }
        List<? extends Node> indices = indexNode.getParent().getChildren(NodeFactory.TAG.index);
        if (indices == null || indices.size() == 0) {
            return false;
        }
        for (Node node : indices) {
            if (node.equals(indexNode) && node.getDiffSource() == null && node.getDiffTarget() == null) {
                return true;
            }
            if (node.getDiffSource() != indexNode) continue;
            return node.getDiffTarget() != null && columnName.equalsIgnoreCase(node.getDiffTarget().getParameter(IDatabaseInfos.INDEX_PARAM.column_name.name()));
        }
        return false;
    }

    public static class ReferenceNodeData {
        private Node oldNode;
        private Node newNode;

        public ReferenceNodeData(Node oldNode, Node newNode) {
            this.oldNode = oldNode;
            this.newNode = newNode;
        }

        public Node getOldNode() {
            return this.oldNode;
        }

        public Node getNewNode() {
            return this.newNode;
        }
    }
}

