/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import srv.controller.ticket.timeline.TimelineJob;
import srv.mail.Mail;

public class ResubmissionExecuter
implements TimelineJob {
    private static final int FLAG_NO_SPECIAL_OPTION = 0;
    private static final int READ_OPTION = 2;
    private static SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final int ticketID;
    private final Timestamp resubmissionTime;

    public ResubmissionExecuter(int ticketID, Timestamp resubmissionTime) {
        this.ticketID = ticketID;
        this.resubmissionTime = resubmissionTime;
    }

    @Override
    public boolean stillValid(boolean reload) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(this.ticketID);
        return ticket != null && ticket.getStatusID() == 150;
    }

    @Override
    public long getExecutionTime() {
        return this.resubmissionTime.getTime();
    }

    @Override
    public void execute() {
        try (UserAccountScope s = UserAccountScope.createPrivileged();){
            TicketManipulator tm = TicketManager.getManipulator();
            ActionVO terminAction = (ActionVO)ActionManager.getInstance().get(-24);
            MutableReaStepData reaStepData = new MutableReaStepData();
            ReaStepTextVO text = ReaStepTextVO.empty();
            tm.applyAction(this.ticketID, reaStepData, text, terminAction, null);
        }
        Mail.sendWV(String.valueOf(this.ticketID), formatter.format(this.resubmissionTime));
    }

    public String toString() {
        return this.ticketID + " resubmission " + String.valueOf(this.resubmissionTime);
    }
}

