/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user;

import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.data.ImagesConnectorImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserSearchDataCache;
import com.inet.helpdesk.usersandgroups.user.persistence.HelpDeskUserPersistence;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.notification.NotificationSettings;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.api.user.search.UserSearchDataCache;
import com.inet.usersandgroups.api.user.search.UserSearchEngine;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.HdLicenseObserver;

public class HelpDeskUserManager
extends UserManager
implements ConnectionCreationListener,
LoginListener {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", ImagesConnectorImpl.class);
    private final UserSearchEngine searchEngine;
    private BaseUserManager manager;
    private HelpDeskUserPersistence userPersistence;
    private boolean connectionEstablished = false;
    private ConnectionFactory connectionFactory;
    private final MutableUserData customDataOfTempMasterUser = new MutableUserData();

    public HelpDeskUserManager(UserSearchEngine searchEngine) {
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        this.searchEngine = searchEngine;
    }

    private boolean hasConnection() {
        return this.connectionEstablished && this.getConnectionFactory().isHelpDeskDatabaseConnectionValid();
    }

    private ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        }
        return this.connectionFactory;
    }

    public void init() throws IOException {
        if (this.manager != null) {
            throw new IllegalStateException("manager is already initialized");
        }
        this.userPersistence = new HelpDeskUserPersistence();
        if (this.connectionEstablished) {
            this.userPersistence.connectionCreated(this.getConnectionFactory());
        }
        this.manager = new BaseUserManager(this.userPersistence, this.searchEngine){

            protected UserSearchDataCache createSearchDataCache(UserPersistence persistence) {
                return new HelpDeskUserSearchDataCache(persistence);
            }
        };
        this.manager.init();
    }

    public UserAccount createUserAccount(UserAccountType type, MutableUserData userData) {
        if (type != UserAccountType.Administrator) {
            this.throwIfNoMoreUsersAllowed(false);
        }
        if (userData != null && userData.containsField((UserField)HDUsersAndGroups.FIELD_USER_ID)) {
            String msg = String.format("User account could not be created because field \"%s\" is already defined", HDUsersAndGroups.FIELD_USER_ID.getKey());
            throw new IllegalArgumentException(msg);
        }
        if (userData == null) {
            throw new IllegalArgumentException("userData cannot be null!");
        }
        userData = this.activateSystemNotificationForEmail(userData);
        UserAccount account = this.manager.createUserAccount(type, userData);
        HdLicenseObserver.resetLicenseCount();
        return account;
    }

    @Nonnull
    private MutableUserData activateSystemNotificationForEmail(@Nonnull MutableUserData data) {
        HashMap activeStatesMap = new HashMap();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("notificationdispatcher.email", Boolean.TRUE);
        activeStatesMap.put("system", map);
        NotificationSettings settings = new NotificationSettings(activeStatesMap, true);
        data = data.copy();
        data.put(UsersAndGroups.FIELD_NOTIFICATIONSETTINGS, (Object)new Json().toJson((Object)settings));
        return data;
    }

    private void throwIfNoMoreUsersAllowed(boolean reactivating) throws IllegalStateException {
        int userCount = HdLicenseObserver.getCountOfNamedUsers(this);
        if (HdLicenseObserver.getMaxUsers() > -1 && userCount >= HdLicenseObserver.getMaxUsers()) {
            throw new IllegalStateException(reactivating ? MSG.getMsg("error.maxusers.exceeded.reactivate", new Object[0]) : MSG.getMsg("error.maxusers.exceeded.newuser", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserData(GUID accountID, MutableUserData userData) {
        if (!this.hasConnection() && MASTER_ACCOUNT_ID.equals((Object)accountID)) {
            MutableUserData mutableUserData = this.customDataOfTempMasterUser;
            synchronized (mutableUserData) {
                userData.getIncludedFields().forEach(field -> this.customDataOfTempMasterUser.put(field, userData.get(field)));
            }
            return;
        }
        if (userData != null && userData.containsField((UserField)HDUsersAndGroups.FIELD_USER_ID)) {
            String msg = String.format("Data of user account with ID \"%s\" could not be updated because field \"%s\" may not be redefined", accountID, HDUsersAndGroups.FIELD_USER_ID.getKey());
            throw new IllegalArgumentException(msg);
        }
        this.manager.updateUserData(accountID, userData);
    }

    public <VALUE> void updateUserData(GUID accountID, UserField<VALUE> field, Function<VALUE, VALUE> func) {
        this.manager.updateUserData(accountID, field, func);
    }

    public void updateLoginSettings(GUID accountID, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove, boolean toEventLog) {
        this.manager.updateLoginSettings(accountID, settingsToAdd, settingsToRemove, toEventLog);
    }

    public void updateUserPermissions(GUID accountID, Set<Permission> permissionsToAdd, Set<Permission> permissionsToRemove) {
        this.manager.updateUserPermissions(accountID, permissionsToAdd, permissionsToRemove);
        HdLicenseObserver.resetLicenseCount();
    }

    public void deleteValuesOfRemovedCustomFields(List<UserField<?>> removedFields) {
        this.manager.deleteValuesOfRemovedCustomFields(removedFields, () -> this.userPersistence.getIteratorOverIDsOfUserAccountWithValuesForSpecifiedFields(removedFields));
    }

    public void deleteUserAccount(GUID accountID) {
        UserAccount account = this.manager.getUserAccount(accountID);
        if (account == null) {
            return;
        }
        String sperrvermerk = (String)account.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED);
        if (sperrvermerk != null) {
            throw new IllegalArgumentException("Cannot delete because user is LOCKED: " + StringFunctions.encodeHTML((String)sperrvermerk));
        }
        this.manager.deleteUserAccount(accountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public void setUserAccountActive(GUID accountID) {
        this.throwIfNoMoreUsersAllowed(true);
        this.manager.setUserAccountActive(accountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public void setUserAccountInactive(GUID accountID) {
        this.manager.setUserAccountInactive(accountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public InputStream getBinaryData(GUID accountID, BinaryDataKey key) {
        if (!this.hasConnection() && MASTER_ACCOUNT_ID.equals((Object)accountID)) {
            return null;
        }
        return this.manager.getBinaryData(accountID, key);
    }

    public void storeBinaryData(GUID accountID, BinaryDataKey key, InputStream in, int length) {
        this.manager.storeBinaryData(accountID, key, in, length);
    }

    public void deleteBinaryData(GUID accountID, BinaryDataKey key) {
        this.manager.deleteBinaryData(accountID, key);
    }

    public UserAccount getUserAccount(GUID accountID) {
        if (PRIVILEGED_ACCOUNT_ID != accountID && !this.hasConnection() && MASTER_ACCOUNT_ID.equals((Object)accountID)) {
            return this.createTempMasterAccount();
        }
        return this.manager.getUserAccount(accountID);
    }

    public List<UserAccount> getUserAccounts(List<GUID> accountIDs) {
        return this.manager.getUserAccounts(accountIDs);
    }

    public Iterator<GUID> getIteratorOverUserAccountIDs(BinaryDataKey key) {
        return this.manager.getIteratorOverUserAccountIDs(key);
    }

    public void registerListener(UserEventListener listener) {
        this.manager.registerListener(listener);
    }

    public void unregisterListener(UserEventListener listener) {
        this.manager.unregisterListener(listener);
    }

    public UserField<Object> getField(String fieldKey) {
        return this.manager.getField(fieldKey);
    }

    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, SearchID searchID) {
        return this.manager.search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID);
    }

    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID, @Nonnull Set<SearchTag> searchTags, @Nullable List<TokenMatcher<GUID>> tokenMatcher) {
        return this.manager.search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID, searchTags, tokenMatcher);
    }

    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.manager.getSearchEngine();
    }

    public UserAccount findActiveUserAccount(String loginSource, String loginID) {
        if ("master".equals(loginSource) && "Master".equals(loginID) && !this.hasConnection()) {
            return this.createTempMasterAccount();
        }
        return this.manager.findActiveUserAccount(loginSource, loginID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserAccount createTempMasterAccount() {
        MutableUserData userData;
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<LoginSettings> loginSettings = new ArrayList<LoginSettings>();
        loginSettings.add(new LoginSettings("master", "Master", ""));
        List userFields = DynamicExtensionManager.getInstance().get(UserField.class);
        userFields.remove((Object)HDUsersAndGroups.FIELD_USER_ID);
        MutableUserData mutableUserData = this.customDataOfTempMasterUser;
        synchronized (mutableUserData) {
            userData = this.customDataOfTempMasterUser.copyWithSpecifiedFieldsOnly((Collection)userFields, true);
        }
        return UserAccount.createForActiveUser((GUID)MASTER_ACCOUNT_ID, (UserAccountType)UserAccountType.Administrator, (long)currentTimeMillis, (long)currentTimeMillis, (MutableUserData)userData, loginSettings, Collections.emptySet());
    }

    public void userLoggedIn(UserAccount userAccount, LoginProcessor loginProcessor) {
        if (!this.hasConnection()) {
            HDLogger.warn("Cannot update current User's authentication groups because connection to the database is not established.");
            return;
        }
        this.manager.userLoggedIn(userAccount, loginProcessor);
        HdLicenseObserver.resetLicenseCount();
    }

    public LoginProcessor getNonSessionLoginProcessor(GUID accountID, String loginID, String loginSource) {
        return this.manager.getNonSessionLoginProcessor(accountID, loginID, loginSource);
    }

    @Override
    public void connectionCreated() {
        this.connectionEstablished = true;
        if (this.userPersistence != null) {
            this.userPersistence.connectionCreated(this.getConnectionFactory());
        }
        HdLicenseObserver.resetLicenseCount();
    }

    public Set<GUID> getAuthGroupMemberIDs(String authGroupName) {
        return this.manager.getAuthGroupMemberIDs(authGroupName);
    }

    public Set<String> getAuthGroupsForUser(GUID accountID) {
        return this.manager.getAuthGroupsForUser(accountID);
    }

    public List<LoginSettings> findConflictingLoginSettings(GUID accountID) {
        return this.manager.findConflictingLoginSettings(accountID);
    }

    public long getAccountFileSize(GUID accountId) {
        return this.manager.getAccountFileSize(accountId);
    }

    public Iterator<Map.Entry<String, InputStream>> getBinaryDataIterator(GUID accountID) {
        return this.manager.getBinaryDataIterator(accountID);
    }

    public void clearUserAuthGroupNames(GUID accountID) {
        this.manager.clearUserAuthGroupNames(accountID);
    }

    public SearchResult<GUID> searchAsUser(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID) {
        return this.manager.searchAsUser(phrase, additionalExpressions, boostingExpressions, maxResults, searchID);
    }

    public SearchResult<GUID> searchAsUser(SearchCommand command) {
        return this.manager.searchAsUser(command);
    }
}

