/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.access;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class TicketPermissionCheckerImpl
implements TicketPermissionChecker {
    private TicketReadDAO readDAO;

    public TicketPermissionCheckerImpl(TicketReadDAO readDAO) {
        this.readDAO = readDAO;
    }

    @Override
    public boolean checkCurrentUserCanReadTicket(int ticketId) {
        TicketPermissionContext context = this.getTicketPermissionInfo(ticketId);
        return context == null || context.hasAnyAccessToTicket();
    }

    @Override
    public boolean checkCurrentUserCanReadReaStep(int reaStepID) {
        ReaStepVO reaStep = this.readDAO.getReaStep(reaStepID);
        if (reaStep == null) {
            return true;
        }
        int ticketId = reaStep.getOrgBunID();
        TicketPermissionContext context = this.getTicketPermissionInfo(ticketId);
        if (context == null) {
            return true;
        }
        if (context.hasAnyAccessToTicket()) {
            return true;
        }
        for (TicketVOSingle bundleMember : this.readDAO.getTicketsInBundle(reaStep.getBunID(), true)) {
            context = this.getTicketPermissionInfo(bundleMember.getID());
            if (context == null || !context.hasEnduserAccessToTicket() || !reaStep.isBundleVisible()) continue;
            return true;
        }
        return false;
    }

    private boolean hasOwnerAccess(@Nullable GUID ownerGUID, TicketVO ticket) {
        if (ownerGUID == null) {
            return false;
        }
        boolean hasAccess = false;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            return false;
        }
        if (userAccount != null && userAccount.getID().equals((Object)ownerGUID)) {
            hasAccess = true;
        } else {
            Integer ownerGroupId;
            UserAccount ownerUser;
            int ownerId = HDUsersAndGroups.getUserID(ownerGUID);
            if (ownerId > -1 && (ownerUser = HDUsersAndGroups.getUserAccount(ownerId)) != null && (ownerGroupId = (Integer)ownerUser.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID)) != null) {
                UserClassManager groupManager = UserClassManager.getInstance();
                List<UserClassVO> usergroups = groupManager.getTeamsWhereUserIsSupervisor(userAccount.getID());
                for (UserClassVO currentusergroup : usergroups) {
                    if (currentusergroup.getId() != ownerGroupId.intValue()) continue;
                    hasAccess = true;
                }
            }
        }
        return hasAccess;
    }

    @Override
    public boolean checkCurrentUserCanWriteTicket(int ticketID) {
        TicketPermissionContext context = this.getTicketPermissionInfo(ticketID);
        if (context == null) {
            return true;
        }
        if (!context.hasAnyAccessToTicket()) {
            return false;
        }
        return context.getEnduserAccess() == TicketPermissionContext.TicketAccess.READWRITE || context.getDispatcherAccess() == TicketPermissionContext.TicketAccess.READWRITE || context.getResourceAccess() == TicketPermissionContext.TicketAccess.READWRITE;
    }

    @Override
    public void throwExceptionIfCurrentUserIsNotDispatcher() throws AccessDeniedException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null || !SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER})) {
            throw new AccessDeniedException(HdPermissions.DISPATCHER);
        }
    }

    @Override
    public boolean checkCanChangeOwnerInTicket(int ticketID) {
        UserGroupInfo ugi;
        TicketVO ticket = TicketManager.getReader().getTicket(ticketID);
        if (ticket == null) {
            return false;
        }
        GUID resourceID = ticket.getResourceID();
        return resourceID == null || ResourceFieldSettings.isSet((Integer)(ugi = UserGroupManager.getInstance().getGroup(resourceID)).getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS), 2);
    }

    @Override
    public TicketPermissionContext getTicketPermissionInfo(int ticketID) throws AccessDeniedException {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        if (ticket == null) {
            return null;
        }
        return this.getTicketPermissionInfo(ticket);
    }

    @Override
    public TicketPermissionContext getTicketPermissionInfo(TicketVO ticket) throws AccessDeniedException {
        Integer minVal;
        boolean isOwner = false;
        int ticketID = ticket.getID();
        GUID ownerGUID = ticket.getOwnerID();
        isOwner = this.hasOwnerAccess(ownerGUID, ticket);
        TicketPermissionContext.TicketAccess permEnduser = isOwner ? TicketPermissionContext.TicketAccess.READWRITE : TicketPermissionContext.TicketAccess.NONE;
        TicketPermissionContext.TicketAccess permDisp = TicketPermissionContext.TicketAccess.NONE;
        TicketPermissionContext.TicketAccess permResource = TicketPermissionContext.TicketAccess.NONE;
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            throw new AccessDeniedException();
        }
        if (!ticket.isInquiry()) {
            GUID resourceID;
            if (SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
                permResource = TicketPermissionContext.TicketAccess.READWRITE;
            } else if (this.hasAdditionalAccess(currentUserAccount, ticket, true) && HDUsersAndGroups.isResourceMember(currentUserAccount)) {
                permResource = TicketPermissionContext.TicketAccess.READWRITE;
            } else if (this.hasAdditionalAccess(currentUserAccount, ticket, false) && HDUsersAndGroups.isResourceMember(currentUserAccount)) {
                permResource = TicketPermissionContext.TicketAccess.READ;
            } else if (SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ})) {
                permResource = TicketPermissionContext.TicketAccess.READ;
            }
            if (ticket.getID() != ticket.getBundleID()) {
                ticket = TicketManager.getReaderForSystem().getTicket(ticket.getBundleID());
            }
            if ((resourceID = ticket.getResourceID()) != null && permResource != TicketPermissionContext.TicketAccess.READWRITE) {
                UserGroupInfo ressourceGroup = UserGroupManager.getInstance().getGroup(resourceID);
                if (HDUsersAndGroups.hasWritePermissionInResource(currentUserAccount.getID(), ressourceGroup)) {
                    permResource = TicketPermissionContext.TicketAccess.READWRITE;
                } else if (HDUsersAndGroups.hasAccessInResource(currentUserAccount.getID(), ressourceGroup)) {
                    permResource = TicketPermissionContext.TicketAccess.READ;
                }
            }
        } else if (HDUsersAndGroups.isDispatcher(currentUserAccount)) {
            permDisp = TicketPermissionContext.TicketAccess.READWRITE;
        }
        if (permDisp == TicketPermissionContext.TicketAccess.NONE && permEnduser == TicketPermissionContext.TicketAccess.NONE && permResource == TicketPermissionContext.TicketAccess.NONE) {
            if (this.hasAdditionalAccess(currentUserAccount, ticket, true)) {
                permEnduser = TicketPermissionContext.TicketAccess.READWRITE;
                isOwner = true;
            } else if (this.hasAdditionalAccess(currentUserAccount, ticket, false)) {
                permEnduser = TicketPermissionContext.TicketAccess.READ;
                isOwner = true;
            }
        }
        if (permDisp == TicketPermissionContext.TicketAccess.NONE && permResource == TicketPermissionContext.TicketAccess.NONE && permEnduser != TicketPermissionContext.TicketAccess.NONE && !HDUsersAndGroups.isSupporter(currentUserAccount) && (minVal = (Integer)CustomTicketViewDefinition.ENDUSDER_FROM_TICKET_NUM.get()) != null && ticketID < minVal) {
            return new TicketPermissionContext(false, TicketPermissionContext.TicketAccess.NONE, permResource, permDisp, false);
        }
        return new TicketPermissionContext(isOwner, permEnduser, permResource, permDisp, HDUsersAndGroups.isDispatcher(currentUserAccount));
    }

    private boolean hasAdditionalAccess(UserAccount currentUserAccount, TicketVO ticket, boolean writeElseRead) {
        Set<Hash> set;
        TicketAdditionalAccessValue aaa = ticket.getValue(Tickets.FIELD_ADDITIONAL_ACCESS);
        if (aaa == null) {
            return false;
        }
        Set<Hash> set2 = set = writeElseRead ? aaa.getWriteAccess() : aaa.getReadAccess();
        if (set.contains(Hash.forUser((GUID)currentUserAccount.getID()))) {
            return true;
        }
        if (!set.stream().anyMatch(h -> h.getType() == Type.group)) {
            return false;
        }
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID());
        for (UserGroupInfo userGroupInfo : groupsForUser) {
            if (!set.contains(Hash.forGroup((GUID)userGroupInfo.getID()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDispatcher() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new AccessDeniedException();
        }
        return HDUsersAndGroups.isDispatcher(userAccount);
    }
}

