/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.ReaStepEmailAddresses;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSlaveForEnduser;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ReaStepEmailUsersVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.internal.ReaStepEmailUsersCreator;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.helpdesk.ticketmanager.search.TicketSearchEngine;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class TicketReaderImpl {
    private final TicketReadDAO readDAO;
    private final TicketSearchDataCache searchDataCache;
    private final TicketSearchEngine searchEngine;
    private static final ConfigValue<HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE> EMAIL_INTERNAL_IS_WHITELIST = new ConfigValue(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_MODE);
    private static final ConfigValue<ArrayList<String>> EMAIL_INTERNAL_ADDRESSES = new ConfigValue(HDConfigKeys.EMAIL_INTERNAL_ADDRESSES_LIST);

    public TicketReaderImpl(TicketReadDAO readDAO, TicketSearchDataCache searchDataCache, TicketSearchEngine searchEngine) {
        if (readDAO == null) {
            throw new IllegalArgumentException("DAO must not be null");
        }
        if (searchDataCache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        this.readDAO = readDAO;
        this.searchDataCache = searchDataCache;
        this.searchEngine = searchEngine;
    }

    public void init() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List pluggableTicketSearchTags = spm.get(PluggableTicketSearchTag.class);
        List ticketTags = spm.get(SearchTagTicketTags.TicketTag.class);
        this.searchDataCache.init(this.readDAO, pluggableTicketSearchTags, ticketTags);
    }

    @Nonnull
    public IndexSearchEngine<Integer> getSearchEngine() {
        return this.searchEngine.getSearchEngine();
    }

    @Nonnull
    public IndexSearchEngine<SlaveInfo> getSlaveInfoEngine() {
        return this.searchEngine.getSlaveInfoEngine();
    }

    @Nonnull
    public IndexSearchEngine<Integer> getReaStepSearchEngine() {
        return this.searchEngine.getReaStepSearchEngine();
    }

    public TicketVO getTicket(int ticketId, TicketPermissionContext context) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        this.throwIfContextIsNull(context);
        if (context.hasEnduserAccessToTicket() && ticket.isSlaveInBundle()) {
            TicketVOSingle master = this.readDAO.getTicket(ticket.getBundleID());
            if (master == null) {
                HDLogger.error(String.format("Master ticket %d of slave ticket %d does not exists!", ticket.getBundleID(), ticket.getID()));
                return null;
            }
            return TicketVOSlaveForEnduser.create(ticket, master);
        }
        return ticket;
    }

    private void throwIfContextIsNull(TicketPermissionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null!");
        }
    }

    public ReaStepVO getReaStep(int reaStepID) {
        ReaStepVO reaStep = this.readDAO.getReaStep(reaStepID);
        return reaStep;
    }

    public ReaStepTextVO getReaStepText(int reaStepId) {
        ReaStepTextVO reaStepText = this.readDAO.getReaStepText(reaStepId);
        return reaStepText;
    }

    public List<ReaStepVO> getReaStepsForTicket(int ticketId, TicketPermissionContext context, BundleStepsFilter stepsFilter) {
        TicketVO ticket = this.getTicket(ticketId, context);
        if (ticket == null) {
            throw new IllegalArgumentException("Ticket does not exist: " + ticketId);
        }
        if (context.hasEnduserAccessToTicket()) {
            if (ticket.isUnbundled()) {
                return this.sortByID(this.filterStepsNotVisibleForEnduser(this.readDAO.getReaStepsForTicket(ticketId), ticket));
            }
        } else if (ticket.isUnbundled() || stepsFilter == BundleStepsFilter.WITHOUT_BUNDLE_STEPS || ticket.isSlaveInBundle()) {
            return this.sortByID(this.readDAO.getReaStepsForTicket(ticketId));
        }
        List<ReaStepVO> stepsFromBundle = this.loadReaStepsFromBundle(ticket, context);
        if (context.hasEnduserAccessToTicket()) {
            return this.sortByID(this.filterStepsNotVisibleForEnduser(stepsFromBundle, ticket));
        }
        return this.sortByID(stepsFromBundle);
    }

    private List<ReaStepVO> sortByID(List<ReaStepVO> reaStepList) {
        Collections.sort(reaStepList, (o1, o2) -> Integer.valueOf(o2.getID()).compareTo(o1.getID()));
        return reaStepList;
    }

    private List<ReaStepVO> loadReaStepsFromBundle(TicketVO ticket, TicketPermissionContext context) {
        AtomicInteger idOfBundlingStep = new AtomicInteger(0);
        ArrayList<ReaStepVO> stepsFromBundle = new ArrayList<ReaStepVO>();
        List<TicketVOSingle> ticketsInBundle = this.readDAO.getTicketsInBundle(ticket.getBundleID(), true);
        for (TicketVOSingle ticketInBundle : ticketsInBundle) {
            List<ReaStepVO> reaStepsForTicket = this.readDAO.getReaStepsForTicket(ticketInBundle.getID());
            stepsFromBundle.addAll(reaStepsForTicket);
            if (ticketInBundle.getID() != ticket.getID() || !ticket.isSlaveInBundle()) continue;
            this.sortByID(reaStepsForTicket);
            Optional<ReaStepVO> first = reaStepsForTicket.stream().filter(step -> step.getActionID() == -1).findFirst();
            if (!first.isPresent()) continue;
            idOfBundlingStep.set(first.get().getID());
        }
        stepsFromBundle.removeIf(reaStep -> {
            if (reaStep.getOrgBunID() == ticket.getID()) {
                return false;
            }
            if (reaStep.getBunID() != ticket.getBundleID()) {
                return true;
            }
            if (context.hasEnduserAccessToTicket()) {
                if (!reaStep.isBundleVisible()) {
                    return true;
                }
                return reaStep.getID() < idOfBundlingStep.get();
            }
            return false;
        });
        return stepsFromBundle;
    }

    private List<ReaStepVO> filterStepsNotVisibleForEnduser(List<ReaStepVO> reaStepsForTicket, TicketVO ticket) {
        String userEmail;
        UserAccount account;
        if (ticket.getOwnerID() != null) {
            account = UserManager.getInstance().getUserAccount(ticket.getOwnerID());
            userEmail = account != null ? (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL) : null;
        } else {
            account = null;
            userEmail = null;
        }
        ActionManager actionManager = ActionManager.getInstance();
        HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE filterMode = (HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE)((Object)EMAIL_INTERNAL_IS_WHITELIST.get());
        ArrayList addressList = (ArrayList)EMAIL_INTERNAL_ADDRESSES.get();
        reaStepsForTicket.removeIf(step -> {
            if (((ActionVO)actionManager.get(step.getActionID())).isHidden()) {
                return true;
            }
            if (!StringFunctions.isEmpty((String)step.getEmailSenderAddress())) {
                if (account == null) {
                    return true;
                }
                if (filterMode == HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.ShowAll) {
                    return false;
                }
                if (filterMode == HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.Blacklist) {
                    for (String addressOrDomainString : addressList) {
                        if (addressOrDomainString == null) continue;
                        if (this.containedIn(step.getEmailSenderAddress(), addressOrDomainString)) {
                            return true;
                        }
                        if (this.containedIn(step.getEmailReceiverAddresses(), addressOrDomainString)) {
                            return true;
                        }
                        if (this.containedIn(step.getEmailCCAdresses(), addressOrDomainString)) {
                            return true;
                        }
                        if (!this.containedIn(step.getEmailBCCAdresses(), addressOrDomainString)) continue;
                        return true;
                    }
                    return false;
                }
                if (filterMode == HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.Whitelist || filterMode == HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.OnlyOwnAndWhitelist) {
                    for (String addressOrDomainString : addressList) {
                        if (addressOrDomainString == null) continue;
                        if (this.containedIn(step.getEmailSenderAddress(), addressOrDomainString)) {
                            return false;
                        }
                        if (this.containedIn(step.getEmailReceiverAddresses(), addressOrDomainString)) {
                            return false;
                        }
                        if (this.containedIn(step.getEmailCCAdresses(), addressOrDomainString)) {
                            return false;
                        }
                        if (!this.containedIn(step.getEmailBCCAdresses(), addressOrDomainString)) continue;
                        return false;
                    }
                }
                if (filterMode == HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.OnlyOwn || filterMode == HDConfigKeys.ENDUSER_EMAIL_FILTER_MODE.OnlyOwnAndWhitelist) {
                    if (account.getID().equals((Object)step.getUserID())) {
                        return false;
                    }
                    if (StringFunctions.isEmpty((String)userEmail)) {
                        return true;
                    }
                    if (this.containedIn(step.getEmailReceiverAddresses(), userEmail)) {
                        return false;
                    }
                    if (this.containedIn(step.getEmailCCAdresses(), userEmail)) {
                        return false;
                    }
                    if (this.containedIn(step.getEmailBCCAdresses(), userEmail)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        });
        return reaStepsForTicket;
    }

    private boolean containedIn(String adresses, String email) {
        return !StringFunctions.isEmpty((String)adresses) && adresses.contains(email);
    }

    public List<TicketVOSingle> getTicketsInBundle(int bundleID, boolean includeMasterTicket) {
        return new ArrayList<TicketVOSingle>(this.readDAO.getTicketsInBundle(bundleID, includeMasterTicket));
    }

    public List<TicketVO> getTickets(Collection<Integer> ticketIds, boolean enduser) {
        ArrayList<TicketVO> result = new ArrayList<TicketVO>();
        for (TicketVOSingle ticket : this.readDAO.getTickets(ticketIds)) {
            if (enduser && ticket.isSlaveInBundle()) {
                TicketVOSingle master = this.readDAO.getTicket(ticket.getBundleID());
                if (master == null) {
                    HDLogger.error(String.format("Ticket %d is a slave ticket, but the master ticket of the bundle %d cannot be found.", ticket.getID(), ticket.getBundleID()));
                    continue;
                }
                result.add(TicketVOSlaveForEnduser.create(ticket, master));
                continue;
            }
            result.add(ticket);
        }
        return result;
    }

    @Deprecated
    public List<ReaStepEmailAddresses> getReaStepEmailAddresses(int ticketId) {
        return this.readDAO.getAllReaStepEmailAddresses(ticketId);
    }

    public ReaStepEmailUsersVO getReaStepEmailUsers(int stepID) {
        return ReaStepEmailUsersCreator.getReaStepEmailUsers(this.readDAO, stepID);
    }

    public int getBunIdForTicketId(int ticketId) {
        return this.readDAO.getTicket(ticketId).getBundleID();
    }

    public List<TicketEmailSenderInformation> getSenderInformationForTicket(int ticketID) throws ServerDataException {
        return this.readDAO.getSenderInformationForTicket(ticketID);
    }
}

