/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.config.AliasMapper;
import com.inet.helpdesk.config.AutoMailHeaderRules;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.logging.MailErrorEventLog;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.mail.reader.ProcessingMailData;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import com.inet.helpdesk.mail.reader.ReadMailResult;
import com.inet.helpdesk.mail.reader.TMReceivedMailDataArgument;
import com.inet.helpdesk.mail.reader.TriggerAndParameterHandler;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.ticketmanager.access.TicketActionCheckerImpl;
import com.inet.helpdesk.ticketmanager.internal.DefaultValueManagerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.html.css.HTML;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.mail.api.AttachedFile;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import srv.HdLicenseObserver;
import srv.mail.AutoMail;
import srv.mail.BlackListHandler;
import srv.mail.CombinationCheck;
import srv.mail.DeliveryStatusInformation;
import srv.mail.Mail;
import srv.mail.TicketIdIdentifier;

public class EmailReader_HDProcessing {
    public static final Map<HTML.Tag, Boolean> IGNORE_MAP = new HashMap<HTML.Tag, Boolean>();
    public static final Logger LOGGER = LogManager.getLogger((String)"Mail");
    private static final ConfigValue<String> FOREIGN_KEY_COLUMN;
    public static final ConfigValue<Boolean> MAIL_USE_RECEIVED_DATE;
    private static final ConfigValue<String> MAIL_FROM;
    private static final ConfigValue<Boolean> MAIL_ANFRAGEN_USER;
    private static final ConfigValue<Boolean> MAIL_COMBINE_MAILS_MULTIPLE_ACCOUNTS;
    private static final ConfigValue<String> MAIL_FORMAT;
    private static final ConfigValue<Boolean> MAIL_SUPPRESS_ACTION_OF_AUTO_RESPONSE;
    private static final ConfigValue<AutoMailHeaderRules> MAIL_SUPPRESS_AUTO_MAIL_HEADERS;
    public static final I18nMessages EMAIL_MESSAGES;
    private TriggerAndParameterHandler triggerAndParameterHandler = new TriggerAndParameterHandler();

    public ReadMailResult readMail(RawReadMailData rawData, CombinationCheck sameEmailsChecker, EmailAccount emailAccount, Set<Integer> idsOfTicketAlreadyProcessed) {
        ProcessingMailData mailData = new ProcessingMailData(emailAccount, rawData);
        try {
            String senderMail = mailData.getSenderMail();
            if (senderMail.length() > 0 && !Mail.testEmailAddressString(senderMail)) {
                LOGGER.warn((Object)("Emailreader: " + senderMail + " Absender wird nicht akzeptiert."));
                return ReadMailResult.ERROR_DROP_MAIL;
            }
            if (((Boolean)MAIL_COMBINE_MAILS_MULTIPLE_ACCOUNTS.get()).booleanValue() && this.checkMultipleAccountsMail(mailData, emailAccount)) {
                LOGGER.info((Object)String.format("[%s] Duplicated mail from %s To %s will be read by other account.", emailAccount.getAccount(), senderMail, mailData.getRecipient()));
                return ReadMailResult.SUCCESS_REMOVE_MAIL;
            }
            this.checkIfIsBounceMailOrAutoResponseMail(rawData, mailData);
            this.setDefaultValuesInModel(mailData);
            this._determineTicketId_loadParameters_runNEW_IN_TRIGGER(mailData, rawData, sameEmailsChecker, emailAccount);
            this.compressContentTextIfIsHtml(mailData);
            boolean validMail = mailData.getTicketId() != null ? this._mailForExistingTicket(mailData, rawData, idsOfTicketAlreadyProcessed) : this._mailForNewTicket(mailData, rawData, sameEmailsChecker);
            if (validMail) {
                idsOfTicketAlreadyProcessed.add(mailData.getTicketId());
                return ReadMailResult.SUCCESS_REMOVE_MAIL;
            }
            return ReadMailResult.ERROR_DROP_MAIL;
        }
        catch (PersistenceException dbError) {
            LOGGER.error((Throwable)dbError);
            return ReadMailResult.ERROR_STOP_READING;
        }
        catch (Throwable th) {
            LOGGER.error((Object)"Fehler beim einlesen einer Email");
            LOGGER.error(th);
            this.sendErrorToSender(th.getMessage(), mailData, rawData, 14);
            return ReadMailResult.ERROR_MOVE_MAIL_TO_ERROR_FOLDER(th.getMessage());
        }
    }

    private boolean checkMultipleAccountsMail(ProcessingMailData mailData, EmailAccount emailAccount) {
        EmailAccountList emailAccountList = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
        if (emailAccountList.size() < 2) {
            return false;
        }
        String receiver = mailData.getRecipient();
        if (receiver == null) {
            return false;
        }
        String[] receivers = receiver.split(";");
        if (receivers.length == 1) {
            return false;
        }
        for (String address : receivers) {
            if (emailAccount.getAccountEmailAddress() != null && emailAccount.getAccountEmailAddress().equalsIgnoreCase(address)) {
                return false;
            }
            boolean isA_HD_Address = emailAccountList.stream().anyMatch(a -> a.getAccountEmailAddress() != null && a.getAccountEmailAddress().equalsIgnoreCase(address));
            if (!isA_HD_Address) continue;
            return true;
        }
        LOGGER.debug((Object)("Cannot find own account in receiver addresses: " + receiver));
        return false;
    }

    private void checkIfIsBounceMailOrAutoResponseMail(RawReadMailData rawData, ProcessingMailData mailData) {
        for (AttachedFile anl : rawData.getAttachments()) {
            if (!anl.isDeliveryStatusPart()) continue;
            mailData.setBounceMail(true);
            mailData.getResponseType().suppressAllMails();
            return;
        }
        if (((Boolean)MAIL_SUPPRESS_ACTION_OF_AUTO_RESPONSE.get()).booleanValue()) {
            Map<String, String> headers = rawData.getHeaderValues();
            List rules = (List)MAIL_SUPPRESS_AUTO_MAIL_HEADERS.get();
            for (String[] rows : rules) {
                boolean incomingMailSeemsToBeAutoResponse = false;
                String header = rows[0];
                String op = rows[1];
                String value = rows[2];
                String action = rows[3];
                if (value != null) {
                    value = value.toLowerCase();
                }
                String headerValue = this.getHeader(headers, header);
                switch (op) {
                    case "exists": {
                        if (headerValue == null) break;
                        incomingMailSeemsToBeAutoResponse = true;
                        break;
                    }
                    case "equals": {
                        if (!Objects.equals(headerValue, value)) break;
                        incomingMailSeemsToBeAutoResponse = true;
                        break;
                    }
                    case "contains": {
                        if (headerValue == null || value == null || !headerValue.contains(value)) break;
                        incomingMailSeemsToBeAutoResponse = true;
                        break;
                    }
                    case "unequals": {
                        if (headerValue == null || Objects.equals(headerValue, value)) break;
                        incomingMailSeemsToBeAutoResponse = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown operator: " + op);
                    }
                }
                if (!incomingMailSeemsToBeAutoResponse) continue;
                String reasonForLog = "Header " + header;
                if (action.equals("noaction")) {
                    LOGGER.info((Object)String.format("No auto-mails or ticket-actions for mail from '%s' with subject '%s' because we found: '%s'", mailData.getSenderMail(), mailData.getSubject(), reasonForLog));
                    mailData.getResponseType().suppressAllMails();
                    mailData.getResponseType().suppressTicketActions();
                    break;
                }
                if (!action.equals("noautomail")) break;
                LOGGER.info((Object)String.format("No auto-mails for mail from '%s' with subject '%s' because we found: '%s'", mailData.getSenderMail(), mailData.getSubject(), reasonForLog));
                mailData.getResponseType().suppressAutoMailsToSenderOnly();
                break;
            }
        }
    }

    private String getHeader(Map<String, String> headers, String header) {
        String string = headers.get(header.toLowerCase());
        return string == null ? null : string.toLowerCase();
    }

    private void setDefaultValuesInModel(ProcessingMailData mailData) {
        mailData.getChangedTicketFields().putAll(this.defaultTicketValues(mailData.getReadInAccount()));
    }

    private MutableTicketData defaultTicketValues(EmailAccount account) {
        PriorityVO priorityVO;
        MutableTicketData mutableTicketData = new MutableTicketData();
        UserGroupInfo resource = HDUsersAndGroups.getResource(account.getResID());
        if (resource != null) {
            mutableTicketData.put(Tickets.FIELD_RESOURCE_GUID, resource.getID());
        }
        if ((priorityVO = (PriorityVO)PriorityManager.getInstance().get(account.getPriority())) != null) {
            mutableTicketData.put(Tickets.FIELD_PRIORITY_ID, Integer.valueOf(priorityVO.getId()));
        } else {
            mutableTicketData.put(Tickets.FIELD_PRIORITY_ID, DefaultValueManagerImpl.getInstance().getPriorityDefault());
        }
        CategoryVO categoryVO = (CategoryVO)CategoryManager.getInstance().get(account.getCategoryId() == null ? 0 : account.getCategoryId());
        if (categoryVO != null && categoryVO.getId() > 0) {
            mutableTicketData.put(Tickets.FIELD_CATEGORY_ID, Integer.valueOf(categoryVO.getId()));
        }
        return mutableTicketData;
    }

    private void compressContentTextIfIsHtml(ProcessingMailData mailData) {
        if (mailData.getContentText().isHtml()) {
            String auftragsText = mailData.getContentText().getText();
            auftragsText = HtmlConverter.getCompactHtmlText((String)auftragsText, null, IGNORE_MAP);
            mailData.getContentText().setText(auftragsText);
        }
    }

    private void replaceEmptyContentTextWithMsg(ProcessingMailData mailData) {
        String subject;
        if (mailData.getContentText().toVO().isEmpty() && ((subject = mailData.getSubject()) == null || subject.isEmpty())) {
            String noTextMsg;
            try {
                UserAccount user = mailData.getSenderUserAccount();
                if (user != null) {
                    String language = (String)user.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
                    noTextMsg = "<" + EMAIL_MESSAGES.getMsg(new Locale(language), "NoBodyText", new Object[0]) + ">";
                } else {
                    noTextMsg = "<" + EMAIL_MESSAGES.getMsg("NoBodyText", new Object[0]) + ">";
                }
            }
            catch (MissingResourceException e) {
                noTextMsg = "<" + EMAIL_MESSAGES.getMsg("NoBodyText", new Object[0]) + ">";
            }
            mailData.getContentText().setText(noTextMsg);
            mailData.getContentText().setIsHtml(false);
        }
    }

    private void setEmailPrefixIfNoUserFound(ProcessingMailData mailData) {
        if (mailData.getSenderUserAccount() == null) {
            mailData.setAcknowledgeStringIfNotSetYet("Email: " + mailData.getSenderMail());
        }
    }

    private void updateUserAccount(ProcessingMailData mailData) {
        UserAccount userAccount = mailData.getSenderUserAccount();
        if (userAccount != null && !mailData.getChangedUserFields().isEmpty()) {
            UserManager.getInstance().updateUserData(userAccount.getID(), mailData.getChangedUserFields());
            mailData.setSenderUserAccountAndUpdateSenderName(UserManager.getInstance().getUserAccount(userAccount.getID()));
        }
    }

    private UserAccount getUserByMailAddress(String email) {
        if (email == null || email.length() == 0) {
            return null;
        }
        UserManager userManager = UserManager.getInstance();
        SearchCondition condition = new SearchCondition(UsersAndGroups.FIELD_EMAIL.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)email);
        SearchResult searchResult = userManager.search("", Arrays.asList(condition), Collections.emptyList(), Integer.MAX_VALUE, null);
        List matchedAccounts = searchResult.getEntries().stream().map(entry -> userManager.getUserAccount((GUID)entry.getId())).filter(Objects::nonNull).collect(Collectors.toList());
        UserAccount bestMatch = null;
        int bestMatchEmailCount = 0;
        block0: for (UserAccount account : matchedAccounts) {
            String[] addresses;
            String value = (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            for (String address : addresses = Mail.convertToAddressArray(value)) {
                if (!email.equalsIgnoreCase(address) || bestMatch != null && (bestMatch.isActive() || !account.isActive()) && (bestMatch.isActive() != account.isActive() || bestMatchEmailCount <= addresses.length)) continue;
                bestMatch = account;
                bestMatchEmailCount = addresses.length;
                continue block0;
            }
        }
        return bestMatch;
    }

    private void sendErrorToSender(String message, ProcessingMailData model, RawReadMailData rawData, int autoMailType) {
        if (model.isBounceMail()) {
            return;
        }
        if (model.getSenderMail() != null && model.getSenderMail().length() > 0 && !model.getResponseType().isSuppressErrorMails()) {
            @Nullable TicketVO ticketVo = model.getTicketId() == null ? null : TicketManager.getReaderForSystem().getTicket(model.getTicketId());
            EmailAccount emailAccount = model.getReadInAccount();
            HashMap<String, String> parameterMap = new HashMap<String, String>(model.getCustomParameterMap());
            if (model.getTicketId() != null && ticketVo != null) {
                parameterMap.put("aufid", String.valueOf(model.getTicketId()));
            }
            parameterMap.put("the message", message + "\n\nFrom: " + model.getSenderMail() + "\nTo: " + emailAccount.getAccount());
            String sender = model.getSenderMail();
            if (StringFunctions.isEmpty((String)sender)) {
                sender = rawData.getSenderMail();
            }
            parameterMap.put("e-mail empfaenger", sender);
            String messageId = rawData.getHeaderValues().get("Message-ID".toLowerCase());
            if (messageId != null && !messageId.isEmpty()) {
                parameterMap.put("In-Reply-To", messageId);
                String subject = rawData.getSubject();
                if (subject != null && !subject.startsWith("Re:") && !subject.startsWith("AW:")) {
                    parameterMap.put("derbetreff_manual", "Re: " + subject);
                }
            }
            if (!AutoMail.putAbsenderFrom(parameterMap, emailAccount.getFrom(), emailAccount.getFromName())) {
                String str = (String)MAIL_FROM.get();
                if (str.length() > 0) {
                    parameterMap.put("name absender", "HelpDesk");
                    parameterMap.put("e-mail absender", str);
                    if (rawData.getReceiverMail() != null) {
                        parameterMap.put("e-mail empfaenger", rawData.getReceiverMail());
                    }
                    if (rawData.getReceiverCCMail() != null) {
                        parameterMap.put("e-mail cc", rawData.getReceiverCCMail());
                    }
                    this.triggerAndParameterHandler.writeTicketValuesIntoMap(parameterMap, model, ticketVo);
                    Mail.send(parameterMap, autoMailType, null);
                }
            } else {
                Mail.send(parameterMap, autoMailType, null);
            }
        }
    }

    private void sendErrorAboutMailLoop(ProcessingMailData mailData, TicketVO ticketVo) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(mailData.getCustomParameterMap());
        parameterMap.put("blacklist", mailData.getSenderMail());
        parameterMap.put("aufid", String.valueOf(mailData.getTicketId()));
        this.triggerAndParameterHandler.writeTicketValuesIntoMap(parameterMap, mailData, ticketVo);
        Mail.send(parameterMap, 16, null);
    }

    private void _determineTicketId_loadParameters_runNEW_IN_TRIGGER(ProcessingMailData mailData, RawReadMailData rawData, CombinationCheck sameEmailsChecker, EmailAccount emailAccount) {
        Integer ticketIdFromSubject;
        int ticketIdFromErrorResponse;
        int testForIDs;
        String testSubject;
        Integer ticketIdFromDuplicateMailCheck = sameEmailsChecker.gotTheSameBefore(mailData.getSubject(), emailAccount, mailData.getSenderMail(), mailData.getReceivedDate());
        this.triggerAndParameterHandler.lookForParametersInAuftragsText(mailData);
        boolean revertModelIfFoundTicketId = false;
        if (mailData.getTicketId() == null) {
            revertModelIfFoundTicketId = this.triggerAndParameterHandler._runMail_NEW_IN_TRIGGER(mailData, rawData);
        }
        Map<String, String> mailHeader = rawData.getHeaderValues();
        Integer aufIdFromForeignKey = this.checkForForeignKeyTicket(mailHeader, mailData);
        if (mailData.getTicketId() == null) {
            mailData.setTicketId(aufIdFromForeignKey);
        }
        if (mailData.getTicketId() == null && (testSubject = mailHeader.get("local key")) != null && (testForIDs = TicketIdIdentifier.testForIDs(testSubject)) > 0) {
            mailData.setTicketId(testForIDs);
        }
        if (mailData.getTicketId() == null && mailData.getResponseType().isSuppressAutoMailsToSender() && rawData.getPossibleTicketIdFromAttachment() != null && (ticketIdFromErrorResponse = TicketIdIdentifier.testForIDs(rawData.getPossibleTicketIdFromAttachment())) > 0) {
            mailData.setTicketId(ticketIdFromErrorResponse);
        }
        if (mailData.getTicketId() == null && (ticketIdFromSubject = Integer.valueOf(TicketIdIdentifier.testForIDs(testSubject = mailData.getSubject()))) != null && ticketIdFromSubject >= 0) {
            mailData.setTicketId(ticketIdFromSubject);
        }
        if (mailData.getTicketId() == null) {
            mailData.setTicketId(ticketIdFromDuplicateMailCheck);
        }
        if (mailData.getTicketId() != null && revertModelIfFoundTicketId) {
            this.triggerAndParameterHandler.revertChangesDoneByMAIL_NEW_IN_Trigger(mailData, mailHeader);
            this.checkForForeignKeyTicket(mailHeader, mailData);
        }
    }

    private Integer checkForForeignKeyTicket(Map<String, String> mailHeader, ProcessingMailData mailData) {
        Object subjectString = mailData.getSubject();
        String foreignKeyColumnName = (String)FOREIGN_KEY_COLUMN.get();
        TicketField<String> foreignKeyColumn = AliasMapper.getCustomTicketFieldForKey(foreignKeyColumnName);
        if (mailHeader.get("foreign key") != null && foreignKeyColumn != null) {
            String forKey = mailHeader.get("foreign key").toString();
            int index = ((String)subjectString).indexOf(forKey);
            if (index > -1) {
                subjectString = ((String)subjectString).substring(0, index) + ((String)subjectString).substring(forKey.length() + index);
                subjectString = ((String)subjectString).trim();
            }
            mailData.setSubject((String)subjectString);
            mailData.getChangedTicketFields().put(foreignKeyColumn, forKey);
            if (mailHeader.get("local key") == null) {
                IndexSearchEngine<Integer> searchEngine = TicketManager.getReader().getSearchEngine();
                SearchCondition hasForeignKey = new SearchCondition(foreignKeyColumn.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)forKey);
                ArrayList ticketsWithForKey = new ArrayList(searchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{hasForeignKey})));
                Collections.sort(ticketsWithForKey);
                Integer matchingTicket = null;
                for (int i = ticketsWithForKey.size() - 1; i >= 0; --i) {
                    Integer aufId = (Integer)ticketsWithForKey.get(i);
                    int status = TicketManager.getReaderForSystem().getTicket(aufId).getStatusID();
                    if (matchingTicket == null) {
                        matchingTicket = aufId;
                    }
                    if (!Status.isOpenStatus(status)) continue;
                    matchingTicket = aufId;
                    break;
                }
                return matchingTicket;
            }
            mailData.getCustomParameterMap().put("foreignKey", forKey);
        }
        return null;
    }

    private boolean _mailForNewTicket(ProcessingMailData mailData, RawReadMailData rawData, CombinationCheck sameEmailsChecker) {
        if (mailData.getReadInAccount().isOnlyAcceptEmailsForExistingTickets()) {
            if (!mailData.getResponseType().isSuppressAutoMailsToSender()) {
                this.sendErrorToSender("", mailData, rawData, 22);
            }
            return false;
        }
        rawData.getAttachments().removeIf(f -> f == AttachedFile.GMAIL_RFC_BOUNCE_DUMMY);
        this._findOrCreateUserForNewTicket(mailData);
        this.setEmailPrefixIfNoUserFound(mailData);
        this.replaceEmptyContentTextWithMsg(mailData);
        TicketVO ticket = this._createNewTicket(mailData, rawData);
        mailData.setTicketId(ticket.getID());
        sameEmailsChecker.noticeNewTicket(mailData.getSubject(), mailData.getReadInAccount(), mailData.getSenderMail(), mailData.getReceivedDate(), ticket.getID());
        this._sendAutoMailToUserForNewTicket(mailData, ticket);
        return true;
    }

    private void _findOrCreateUserForNewTicket(ProcessingMailData mailData) {
        Integer slaPrioId;
        String senderMail = mailData.getSenderMail();
        UserAccount userAccount = this.getUserByMailAddress(senderMail);
        if (userAccount == null && senderMail == null || senderMail.trim().isEmpty()) {
            LOGGER.warn((Object)"Sender mail is empty, no account is created!");
            return;
        }
        if (userAccount == null || !userAccount.isActive()) {
            UserAccount fallbackAccount;
            GUID fallbackOwnerGUID;
            String emailData;
            String[] emails;
            String compareString = senderMail.indexOf(64) > -1 ? senderMail.substring(0, senderMail.indexOf(64)) : senderMail;
            UserAccount secondBest = null;
            UserAccount foundAccount = UserManager.getInstance().findActiveUserAccount("system", compareString);
            if (foundAccount != null && foundAccount.isActive()) {
                secondBest = foundAccount;
            } else {
                foundAccount = UserManager.getInstance().findActiveUserAccount("product", compareString);
                if (foundAccount != null && foundAccount.isActive()) {
                    secondBest = foundAccount;
                }
            }
            if (secondBest != null && (emails = Mail.convertToAddressArray(emailData = (String)secondBest.getValue((UserField)UsersAndGroups.FIELD_EMAIL))).length == 0) {
                userAccount = secondBest;
                MutableUserData userData = new MutableUserData();
                userData.put((UserField)UsersAndGroups.FIELD_EMAIL, (Object)senderMail);
                UserManager.getInstance().updateUserData(userAccount.getID(), userData);
            }
            if (userAccount == null && (fallbackOwnerGUID = mailData.getReadInAccount().getFallbackOwnerGUID()) != null && (fallbackAccount = UserManager.getInstance().getUserAccount(fallbackOwnerGUID)) != null && fallbackAccount.isActive()) {
                mailData.setFallbackAccountForTicketOwner(fallbackOwnerGUID);
            }
        }
        MutableTicketData changedTicketFields = mailData.getChangedTicketFields();
        if (userAccount != null && !userAccount.isActive()) {
            LOGGER.info((Object)String.format("UserAccount %s to use is not active", userAccount.getDisplayName()));
        }
        if (userAccount != null && userAccount.isActive()) {
            LOGGER.debug((Object)String.format("Use UserAccount %s for the ticket", userAccount.getDisplayName()));
            mailData.setSenderUserAccountAndUpdateSenderName(userAccount);
            this.updateUserAccount(mailData);
            userAccount = mailData.getSenderUserAccount();
        } else if (mailData.isNewUserCanBeCreated()) {
            if (HdLicenseObserver.getMaxUsers() > EmailReader_Main.usersCount.get() || HdLicenseObserver.getMaxUsers() == -1) {
                if (userAccount != null) {
                    mailData.setAcknowledgeStringIfNotSetYet("E-Mail von einem deaktivierten Benutzer: " + mailData.getSenderMail());
                    LOGGER.info((Object)String.format("Mail from a deactivated user", new Object[0]));
                } else {
                    LOGGER.debug((Object)String.format("Create new UserAccount for the ticket", new Object[0]));
                    MutableUserData userData = mailData.getChangedUserFields();
                    EmailReader_Main.usersCount.set(EmailReader_Main.usersCount.get() + 1);
                    if (!userData.containsField((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) {
                        int locationId;
                        String locationName = mailData.getSenderMail();
                        if (locationName.indexOf(64) > -1) {
                            locationName = locationName.substring(locationName.indexOf(64) + 1);
                        }
                        List locList = LocationManager.getInstance().getAll(true);
                        String location = locationName;
                        LocationVO locVo = locList.stream().filter(e -> location.equalsIgnoreCase(e.getDisplayValue().toLowerCase())).findFirst().orElse(null);
                        if (locVo == null) {
                            locList = LocationManager.getInstance().getAll(false);
                            locVo = locList.stream().filter(e -> location.equalsIgnoreCase(e.getDisplayValue().toLowerCase())).findFirst().orElse(null);
                            if (locVo == null) {
                                if (mailData.getReadInAccount().getCreateDomain()) {
                                    try {
                                        locationId = LocationManager.getInstance().add(new LocationVO(-1, locationName, null, null, null, 0, false));
                                    }
                                    catch (SQLException e1) {
                                        throw new IllegalStateException(e1);
                                    }
                                } else {
                                    locationId = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
                                }
                            } else {
                                locationId = locVo.getId();
                            }
                        } else {
                            locationId = locVo.getId();
                        }
                        userData.put((UserField)HDUsersAndGroups.FIELD_LOCATION_ID, (Object)locationId);
                    }
                    if (userData.get((UserField)UsersAndGroups.FIELD_LASTNAME) == null) {
                        String vorN = "";
                        String nachN = "";
                        String emailName = mailData.getSenderName();
                        if (emailName == null) {
                            emailName = "";
                        }
                        if (emailName.indexOf(", ") > 1) {
                            vorN = emailName.substring(emailName.indexOf(32) + 1);
                            nachN = emailName.substring(0, emailName.indexOf(44));
                        } else if (emailName.indexOf(32) > 1) {
                            vorN = emailName.substring(0, emailName.indexOf(32));
                            nachN = emailName.substring(emailName.indexOf(32) + 1);
                        } else if (emailName.indexOf(46) > 1 && emailName.indexOf(46) < emailName.indexOf(64)) {
                            vorN = emailName.substring(0, emailName.indexOf(46));
                            nachN = emailName.substring(emailName.indexOf(46) + 1);
                        } else {
                            nachN = emailName.length() < 49 ? emailName : emailName.substring(0, 49);
                        }
                        userData.put((UserField)UsersAndGroups.FIELD_FIRSTNAME, (Object)vorN);
                        userData.put((UserField)UsersAndGroups.FIELD_LASTNAME, (Object)nachN);
                    }
                    this.limitToCharacters((UserField<String>)UsersAndGroups.FIELD_FIRSTNAME, userData, 49);
                    this.limitToCharacters((UserField<String>)UsersAndGroups.FIELD_LASTNAME, userData, 49);
                    userData.put((UserField)UsersAndGroups.FIELD_EMAIL, (Object)mailData.getSenderMail());
                    userData.put((UserField)HDUsersAndGroups.FIELD_LANGUAGE, (Object)"xx");
                    userAccount = UserManager.getInstance().createUserAccount(UserAccountType.Standard, userData);
                    mailData.setSenderUserAccountAndUpdateSenderName(userAccount);
                    mailData.setAcknowledgeStringIfNotSetYet(EMAIL_MESSAGES.getMsg("NewUser", new Object[]{userAccount.getDisplayName()}));
                }
            } else {
                LOGGER.info((Object)String.format("Cannot create new user because license limit is reached", new Object[0]));
            }
        }
        if (DefaultValueManagerImpl.getInstance().hasSlaSettings() && userAccount != null && !this.triggerAndParameterHandler.trigger_MAIL_NEW_IN_Exists() && (slaPrioId = DefaultValueManagerImpl.getInstance().getDefaultPriorityID(userAccount)) != null) {
            changedTicketFields.put(Tickets.FIELD_PRIORITY_ID, slaPrioId);
        }
    }

    private void limitToCharacters(UserField<String> field, MutableUserData userData, int max) {
        String str = (String)userData.get(field);
        if (str != null && str.length() > max) {
            userData.put(field, (Object)str.substring(0, max));
        }
    }

    private TicketVO _createNewTicket(ProcessingMailData mailData, RawReadMailData rawData) {
        GUID userId = mailData.getSenderUserAccount() != null ? mailData.getSenderUserAccount().getID() : UserManager.PRIVILEGED_ACCOUNT_ID;
        mailData.getChangedTicketFields().put(Tickets.FIELD_OWNER_GUID, mailData.getSenderUserAccount() != null ? mailData.getSenderUserAccount().getID() : mailData.getFallbackOwnerGUID());
        mailData.getChangedTicketFields().putValidOrDefaultValue(Tickets.FIELD_SUBJECT, mailData.getSubject());
        ExtensionArguments args = ExtensionArguments.create();
        args.put(ExtensionArguments.EXTARG_EMAIL_DATA, new TMReceivedMailDataArgument(mailData, rawData));
        args.put(ExtensionArguments.EXTARG_DISPATCH_NOW, mailData.getResponseType().isSuppressTicketActions() ? ExtensionArguments.DispatchNow.NOT : ExtensionArguments.DispatchNow.IF_RESOURCE_AVAILABLE);
        if (mailData.getTicketStatusChangedByTrigger() != null && Status.isDeletedStatus(mailData.getTicketStatusChangedByTrigger()) || mailData.getResponseType().isSuppressAutoMailsToAnyone()) {
            args.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NEVER);
        } else if (mailData.getResponseType().isSuppressAutoMailsToSender()) {
            args.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER);
        }
        String emailEingang = "er_" + mailData.getReadInAccount().getAccount();
        try (UserAccountScope scope = UserAccountScope.create((GUID)userId);){
            TicketVO ticketVO = TicketManager.getManipulator().createTicket(mailData.getContentText().toVO(), mailData.getChangedTicketFields(), emailEingang, args);
            return ticketVO;
        }
    }

    private void _sendAutoMailToUserForNewTicket(ProcessingMailData mailData, TicketVO ticket) {
        if (mailData.getResponseType().isSuppressAutoMailsToSender()) {
            LOGGER.info((Object)("Suppress Automail for new ticket: " + ticket.getID()));
            return;
        }
        String test = mailData.getReadInAccount().getTemplate();
        if (((Boolean)MAIL_ANFRAGEN_USER.get()).booleanValue() && test != null && test.length() > 0) {
            boolean htmlMail = "html".equals(MAIL_FORMAT.get());
            HashMap<String, String> data = new HashMap<String, String>(mailData.getCustomParameterMap());
            data.put("aufid", String.valueOf(ticket.getID()));
            data.put("templatename", test + (htmlMail ? ".html" : ".txt"));
            data.remove("e-mail empfaenger");
            data.remove("e-mail cc");
            Mail.send(data, 1, null);
        }
    }

    private boolean _mailForExistingTicket(ProcessingMailData mailData, RawReadMailData rawData, Set<Integer> idsOfTicketAlreadyProcessed) {
        Integer ticketId = mailData.getTicketId();
        TicketVO ticketVo = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticketVo == null) {
            this.sendErrorToSender(EMAIL_MESSAGES.getMsg("err1", new Object[]{TicketIdIdentifier.idsString[0]}) + "\n" + mailData.getSubject(), mailData, rawData, 14);
            return false;
        }
        BlackListHandler.BlackListResponseType blackListCheck = this.blackListCheck(rawData.getAttachments(), ticketId, mailData.getSenderMail());
        switch (blackListCheck) {
            case VALID: {
                break;
            }
            case SUPPRESS_ANSWER: {
                mailData.getResponseType().suppressAllMails();
                break;
            }
            case ERROR: {
                this.sendErrorAboutMailLoop(mailData, ticketVo);
            }
            case BLACK_LIST: {
                mailData.getResponseType().suppressAllAutoMails();
                break;
            }
        }
        if (!mailData.isBounceMail()) {
            UserAccount userAccount = this.getUserByMailAddress(mailData.getSenderMail());
            if (userAccount != null) {
                mailData.setSenderUserAccountAndUpdateSenderName(userAccount);
            }
            this.replaceEmptyContentTextWithMsg(mailData);
            this.dropDefaultvaluesFromModel(mailData);
            this.triggerAndParameterHandler._run_MAIL_IN_TRIGGER_if_exists(mailData, ticketVo);
            this.updateUserAccount(mailData);
        } else {
            this.dropDefaultvaluesFromModel(mailData);
        }
        int status = ticketVo.getStatusID();
        if (Status.isClosedStatus(status) && (mailData.getTicketStatusChangedByTrigger() == null || Status.isOpenStatus(mailData.getTicketStatusChangedByTrigger()))) {
            boolean reactivationAllowedBasedOnStatus;
            boolean reactivationAllowedByPlugins = this.checkActionAllowedIncludingIndirectlyAllowed(-2, ticketId);
            boolean reactivationAllowedBasedOnDate = !TicketActionCheckerImpl.isReactivationTimeExpired(ticketVo, mailData.getReceivedDate());
            boolean bl = reactivationAllowedBasedOnStatus = status < 360 || status > 369;
            if (!(reactivationAllowedBasedOnStatus && reactivationAllowedBasedOnDate && reactivationAllowedByPlugins)) {
                LOGGER.info((Object)String.format("Ticket %d is closed. Discard mail with subject '%s'", ticketId, mailData.getSubject()));
                this.sendErrorToSender(EMAIL_MESSAGES.getMsg("err3", new Object[]{TicketIdIdentifier.idsString[0]}) + "\n" + mailData.getSubject() + " Status: " + ((StatusVO)StatusManager.getInstance().get(status)).getDisplayValue(), mailData, rawData, 14);
                return false;
            }
        }
        if (Status.isOpenStatus(status) && mailData.getTicketStatusChangedByTrigger() != null && Status.isClosedStatus(mailData.getTicketStatusChangedByTrigger()) && !this.checkActionAllowedIncludingIndirectlyAllowed(2, ticketId)) {
            LOGGER.warn((Object)("Incoming Email tried to close ticket " + ticketId + ", which is not allowed. Email is discarded, Sender being notified."));
            this.sendErrorToSender(EMAIL_MESSAGES.getMsg("errActionForbidden", new Object[]{TicketIdIdentifier.idsString[0], "Beenden"}) + "\n" + mailData.getSubject() + " Status: " + ((StatusVO)StatusManager.getInstance().get(status)).getDisplayValue(), mailData, rawData, 14);
            return false;
        }
        if (Status.isOpenStatus(status) && ticketVo.isDispatched() && mailData.getChangedTicketFields().containsKey(Tickets.FIELD_RESOURCE_GUID) && !mailData.getChangedTicketFields().get(Tickets.FIELD_RESOURCE_GUID).equals((Object)ticketVo.getResourceID()) && !this.checkActionAllowedIncludingIndirectlyAllowed(8, ticketId)) {
            LOGGER.warn((Object)("Incoming Email tried to escalate ticket " + ticketId + ", which is not allowed. Email is discarded, Sender being notified."));
            this.sendErrorToSender(EMAIL_MESSAGES.getMsg("errActionForbidden", new Object[]{TicketIdIdentifier.idsString[0], "Weiterleiten (Manuell Eskalieren)"}) + "\n" + mailData.getSubject() + " Status: " + ((StatusVO)StatusManager.getInstance().get(status)).getDisplayValue(), mailData, rawData, 14);
            return false;
        }
        if (Status.isOpenStatus(status) && ticketVo.isInquiry() && mailData.getChangedTicketFields().containsKey(Tickets.FIELD_RESOURCE_GUID) && !this.checkActionAllowedIncludingIndirectlyAllowed(5, ticketId)) {
            LOGGER.warn((Object)("Incoming Email tried to authorize ticket " + ticketId + ", which is not allowed. Email is discarded, Sender being notified."));
            this.sendErrorToSender(EMAIL_MESSAGES.getMsg("errActionForbidden", new Object[]{TicketIdIdentifier.idsString[0], "Autorisieren"}) + "\n" + mailData.getSubject() + " Status: " + ((StatusVO)StatusManager.getInstance().get(status)).getDisplayValue(), mailData, rawData, 14);
            return false;
        }
        if (Status.isDeletedStatus(status)) {
            LOGGER.info((Object)String.format("Ticket %d is deleted. Discard mail with subject '%s'", ticketId, mailData.getSubject()));
            this.sendErrorToSender(EMAIL_MESSAGES.getMsg("err4", new Object[]{TicketIdIdentifier.idsString[0]}) + "\n" + mailData.getSubject() + " Status: " + ((StatusVO)StatusManager.getInstance().get(status)).getDisplayValue(), mailData, rawData, 14);
            return false;
        }
        this._applyActionEmailAnswer(mailData, ticketId, rawData, idsOfTicketAlreadyProcessed);
        return true;
    }

    private boolean checkActionAllowedIncludingIndirectlyAllowed(int actionId, int ticketId) {
        ActionVO reactivate = (ActionVO)ActionManager.getInstance().get(actionId);
        return ((TicketActionCheckerImpl)TicketManager.getTicketActionChecker()).checkActionIndirectlyAllowedAsPriviliged(reactivate, ticketId);
    }

    private void dropDefaultvaluesFromModel(ProcessingMailData mailData) {
        MutableTicketData defaultTicketValues = this.defaultTicketValues(mailData.getReadInAccount());
        for (TicketField<Object> f : defaultTicketValues.getIncludedFields()) {
            Object value = defaultTicketValues.get(f);
            if (!Objects.equals(mailData.getChangedTicketFields().get(f), value)) continue;
            mailData.getChangedTicketFields().remove(f);
        }
    }

    private BlackListHandler.BlackListResponseType blackListCheck(List<AttachedFile> allFiles, int aufID, String senderAddress) {
        for (int i = allFiles.size(); i > 0; --i) {
            AttachedFile anl = allFiles.get(i - 1);
            if (anl.isDeliveryStatusPart()) {
                DeliveryStatusInformation dsi;
                if (anl != AttachedFile.GMAIL_RFC_BOUNCE_DUMMY) {
                    dsi = new DeliveryStatusInformation(anl.getFile());
                } else {
                    dsi = new DeliveryStatusInformation(DeliveryStatusInformation.PERMANENT_FFAILURE, DeliveryStatusInformation.ADDRESSING_STATUS, DeliveryStatusInformation.ADDRESSING_STATUS);
                    allFiles.remove(anl);
                }
                if (dsi.isTemporaryFailure() || dsi.isPermanentFailure()) {
                    if (dsi.getRecipient() == null || dsi.getRecipient().length() == 0) {
                        dsi.setRecipient(senderAddress);
                    }
                    BlackListHandler.addToBlackList(aufID, dsi);
                    if (senderAddress != null && senderAddress.length() > 0 && !senderAddress.equals(dsi.getRecipient())) {
                        DeliveryStatusInformation mailServerBlocker = DeliveryStatusInformation.getInvalidAddressInfo(senderAddress);
                        BlackListHandler.addToBlackList(aufID, mailServerBlocker);
                    }
                }
            }
            LOGGER.debug((Object)("blacklistCheck:   " + anl.getFileName()));
        }
        return BlackListHandler.mailRecieved(aufID, senderAddress);
    }

    private void _applyActionEmailAnswer(ProcessingMailData mailData, Integer ticketId, RawReadMailData rawData, Set<Integer> idsOfTicketAlreadyProcessed) {
        ActionVO action;
        ExtensionArguments extensionArgs = ExtensionArguments.create();
        extensionArgs.put(ExtensionArguments.EXTARG_EMAIL_DATA, new TMReceivedMailDataArgument(mailData, rawData));
        if (mailData.getResponseType().isSuppressAutoMailsToSender()) {
            extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER);
        } else if (mailData.getResponseType().isSuppressAutoMailsToAnyone()) {
            extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NEVER);
        }
        if (idsOfTicketAlreadyProcessed.contains(ticketId)) {
            extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NEVER);
        }
        if (mailData.isBounceMail()) {
            MailErrorEventLog.EmailBouncedAfterSending.log(mailData.getReadInAccount(), "Ticket #" + ticketId + ": " + rawData.getSubject());
            action = (ActionVO)ActionManager.getInstance().get(-11);
        } else {
            action = (ActionVO)ActionManager.getInstance().get(-9);
        }
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            TicketManager.getManipulator().applyAction(ticketId, new MutableReaStepData(), ReaStepTextVO.empty(), action, extensionArgs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        IGNORE_MAP.put(HTML.Tag.BASE, Boolean.FALSE);
        FOREIGN_KEY_COLUMN = new ConfigValue(HDConfigKeys.FOREIGN_KEY_COLUMN);
        MAIL_USE_RECEIVED_DATE = new ConfigValue(HDConfigKeys.MAIL_USE_RECEIVED_DATE);
        MAIL_FROM = new ConfigValue(ConfigKey.MAIL_SENDER);
        MAIL_ANFRAGEN_USER = new ConfigValue(HDConfigKeys.MAIL_ANFRAGEN_USER);
        MAIL_COMBINE_MAILS_MULTIPLE_ACCOUNTS = new ConfigValue(HDConfigKeys.MAIL_COMBINE_MAILS_TO_MULTIPLE_ACCOUNTS);
        MAIL_FORMAT = new ConfigValue(HDConfigKeys.MAIL_FORMAT);
        MAIL_SUPPRESS_ACTION_OF_AUTO_RESPONSE = new ConfigValue(HDConfigKeys.MAIL_SUPRESS_ACTIONS_OF_AUTOMATIC_RESPONSES);
        MAIL_SUPPRESS_AUTO_MAIL_HEADERS = new ConfigValue(HDConfigKeys.MAIL_SUPPRESS_AUTO_MAIL_HEADERS);
        EMAIL_MESSAGES = new I18nMessages("com.inet.helpdesk.mail.reader.i18n.EmailMessages", EmailReader_HDProcessing.class);
    }
}

