/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.config.ConfigValue;
import com.inet.globalbanner.GlobalBanner;
import com.inet.globalbanner.GlobalBannerManager;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.logging.MailErrorEventLog;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationManager;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.MailConnectionErrorNotification;
import srv.mail.MailErrorHandler;

public class EmailReader_ErrorHandler {
    private static final Object GLOBAL_BANNER_MONITOR = new Object();
    private static final ConfigValue<EmailAccountList> MAIL_ACCOUNTS = new ConfigValue<EmailAccountList>(HDConfigKeys.MAIL_ACCOUNTS){};
    private static Set<String> notifiedAccounts = new HashSet<String>();
    private static Map<String, Integer> errorCounts = new HashMap<String, Integer>();
    private static Map<String, Long> failedAccountsSince = new ConcurrentHashMap<String, Long>();
    private static final ConfigValue<Integer> MAIL_FAILURE_COUNT_BEFORE_NOTIFICATION = new ConfigValue(HDConfigKeys.MAIL_FAILURE_COUNT_BEFORE_NOTIFICATION);

    public void connectFailed(EmailAccount account, String errorMessage) {
        int failureThreshold;
        MailErrorEventLog.EmailsCouldNotBeFetched.log(account, errorMessage);
        int currentErrors = errorCounts.getOrDefault(account.getID(), 0) + 1;
        errorCounts.put(account.getID(), currentErrors);
        if (!failedAccountsSince.containsKey(account.getID())) {
            failedAccountsSince.put(account.getID(), System.currentTimeMillis());
            this.updateBannerNotifications();
        }
        if (currentErrors > (failureThreshold = ((Integer)MAIL_FAILURE_COUNT_BEFORE_NOTIFICATION.get()).intValue())) {
            NotificationManager notificationManager = NotificationManager.getInstance();
            MailConnectionErrorNotification notification = new MailConnectionErrorNotification(account, errorMessage);
            notificationManager.registerGenerator((NotificationGenerator)notification);
            notifiedAccounts.add(account.getID());
        }
    }

    public void stopHangingMail(EmailAccount emailAccount, String errorMessage) {
        MailErrorEventLog.EmailsCouldNotBeFetched.log(emailAccount, errorMessage);
        new Thread(() -> new MailErrorHandler(emailAccount.getAccount(), errorMessage, emailAccount.getResID())).start();
    }

    public void readMailFailed(EmailAccount emailAccount, String errorMessage) {
        MailErrorEventLog.EmailsCouldNotBeFetched.log(emailAccount, errorMessage);
        new Thread(() -> new MailErrorHandler(emailAccount.getAccount(), errorMessage, emailAccount.getResID())).start();
    }

    public void unexpectedReadError(EmailAccount emailAccount, String message) {
        MailErrorEventLog.EmailsCouldNotBeFetched.log(emailAccount, message);
        new Thread(() -> new MailErrorHandler(emailAccount.getAccount(), message, emailAccount.getResID())).start();
    }

    public void connectionRestored(EmailAccount emailAccount) {
        MailErrorEventLog.ConnectionRestored.log(emailAccount, "");
        String accountId = emailAccount.getID();
        errorCounts.remove(accountId);
        if (failedAccountsSince.remove(accountId) != null) {
            this.updateBannerNotifications();
        }
        if (notifiedAccounts.contains(accountId)) {
            notifiedAccounts.remove(accountId);
            NotificationManager notificationManager = NotificationManager.getInstance();
            MailConnectionErrorNotification notification = new MailConnectionErrorNotification(emailAccount, "");
            notificationManager.registerGenerator((NotificationGenerator)notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateBannerNotifications() {
        Object object = GLOBAL_BANNER_MONITOR;
        synchronized (object) {
            ServerPluginManager.getInstance().runIfPluginLoaded("remotegui", () -> new Executable(){

                public void execute() {
                    final MailReadingFailedStatus status = EmailReader_ErrorHandler.this.getMailReadingStatus();
                    GlobalBannerManager.getInstance().unregisterGlobalBanner("mailreadingstatus.error");
                    if (status != null) {
                        GlobalBannerManager.getInstance().registerGlobalBanner(new GlobalBanner(){

                            @Nonnull
                            public String getExtensionName() {
                                return "mailreadingstatus.error";
                            }

                            public boolean isVisibleInApp(@Nonnull String appPath) {
                                return "/ticketlist".equals(appPath) || "/start".equals(appPath);
                            }

                            public boolean isAvailableForUser(@Nullable GUID userId) {
                                if (userId == null) {
                                    return false;
                                }
                                UserAccount userAccount = UserManager.getInstance().getUserAccount(userId);
                                if (userAccount == null) {
                                    return false;
                                }
                                return HDUsersAndGroups.isSupporter(userAccount);
                            }

                            @Nonnull
                            public String getText() {
                                return status.message;
                            }

                            @Nonnull
                            public GlobalBanner.BannerType getBannerType() {
                                return GlobalBanner.BannerType.warning;
                            }

                            @Nullable
                            public GlobalBanner.BannerLink getLink() {
                                return null;
                            }
                        });
                    }
                }
            });
        }
    }

    @Nullable
    synchronized MailReadingFailedStatus getMailReadingStatus() {
        if (failedAccountsSince.isEmpty()) {
            return null;
        }
        long earliestFail = System.currentTimeMillis();
        int numberOfAccounts = 0;
        EmailAccount emailAccount = null;
        for (Map.Entry<String, Long> entry : failedAccountsSince.entrySet()) {
            Optional<EmailAccount> possibleAccount = ((EmailAccountList)MAIL_ACCOUNTS.get()).stream().filter(a -> a.getID().equals(entry.getKey())).findFirst();
            if (!possibleAccount.isPresent()) continue;
            ++numberOfAccounts;
            emailAccount = possibleAccount.get();
            if (earliestFail <= entry.getValue()) continue;
            earliestFail = entry.getValue();
        }
        if (numberOfAccounts == 0) {
            return null;
        }
        if (numberOfAccounts == 1 && emailAccount != null) {
            return new MailReadingFailedStatus(earliestFail, Tickets.MSG.getMsg("mail.connect.banner.single", new Object[]{new Date(earliestFail), emailAccount.getAccount()}));
        }
        return new MailReadingFailedStatus(earliestFail, Tickets.MSG.getMsg("mail.connect.banner.multi", new Object[]{new Date(earliestFail), numberOfAccounts}));
    }

    private static class MailReadingFailedStatus {
        public final long connectionFailedSince;
        public final String message;

        public MailReadingFailedStatus(long connectionFailedSince, String message) {
            this.connectionFailedSince = connectionFailedSince;
            this.message = message;
        }
    }
}

