/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SimpleSubViewGrouping
implements SubViewGroupingDefinition {
    public static final int MAX_NODE_COUNT = 100;
    @Nonnull
    private final String key;

    protected SimpleSubViewGrouping(String key) {
        this.key = Objects.requireNonNull(key);
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getRelatedFieldKey() {
        return this.getKey();
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(this.getKey());
    }

    @Override
    @Nonnull
    public String getDescription() {
        return HDFieldDisplayNameProvider.getTicketFieldDisplayDescription(this.getKey() + ".view");
    }

    @Override
    public void appendMarker(@Nonnull SearchCommand command) {
        SearchCondition marker = new SearchCondition(this.key, SearchCondition.SearchTermOperator.StartsWith, (Object)"");
        if (command.getSearchExpression().isEmpty()) {
            command.getSearchExpression().add((SearchExpression)marker);
        } else {
            command.addBoostingExpression((SearchExpression)marker);
        }
    }

    @Override
    public void patchSearchCommand(Object subID, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        AndSearchExpression expressions = command.getSearchExpression();
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            SearchCondition cond;
            SearchExpression expr = (SearchExpression)it.next();
            if (expr.getType() != SearchExpression.Type.Condition || !this.key.equals((cond = (SearchCondition)expr).getLeftOperand())) continue;
            switch (cond.getOperator()) {
                case StartsWith: {
                    it.remove();
                    break;
                }
            }
        }
        expressions.add(this.getSearchCondition(subID));
    }

    @Nonnull
    private SearchExpression getSearchCondition(Object subID) {
        if ("".equals(subID)) {
            return new PhraseSearchExpression(this.key, SearchCondition.SearchTermOperator.Equals, "", Collections.emptyList());
        }
        return new SearchCondition(this.key, SearchCondition.SearchTermOperator.Equals, subID);
    }

    @Override
    public void appendSubViewStates(TicketViewState parentState, @Nonnull TicketViewFactory parentFactory, @Nonnull GUID accountID, @Nonnull Set<Integer> result, @Nullable Set<Integer> unreadResult, IndexSearchEngine<Integer> engine, @Nullable IndexSearchEngine<SlaveInfo> slaveInfoEngine) {
        List<SubView<?>> subViews = this.getSubViews(parentFactory, accountID, Locale.getDefault(), result);
        if (subViews == null || subViews.isEmpty()) {
            return;
        }
        PrefilteredSearchExpression all = new PrefilteredSearchExpression(result);
        TicketViewManager manager = TicketViewManager.getInstance();
        for (SubView<?> subView : subViews) {
            HashSet<Integer> unreadSubResult;
            int unreadCount;
            if (parentState.size() >= 100) break;
            SearchCommand command = subView.createSubSearchCommand(all, accountID, Locale.getDefault());
            if (command == null) continue;
            command.setResultLimit(20000);
            Set subResult = engine.simpleSearch(command);
            manager.convertToBunIdsIfNeeded(slaveInfoEngine, subResult, accountID);
            int count = subResult.size();
            if (count == 0 && !parentFactory.isHideSubnodeTickets()) continue;
            if (unreadResult == null) {
                unreadCount = 0;
                unreadSubResult = null;
            } else {
                unreadSubResult = new HashSet<Integer>(count);
                for (Integer id : subResult) {
                    if (!unreadResult.contains(id)) continue;
                    unreadSubResult.add(id);
                }
                manager.convertToBunIdsIfNeeded(slaveInfoEngine, unreadSubResult, accountID);
                unreadCount = unreadSubResult.size();
            }
            TicketViewState subState = new TicketViewState(subView.getID(), count, unreadCount, subView, parentState);
            SubViewGroupingDefinition grouping = subView.getSubViewGrouping();
            if (grouping != null) {
                Set<Integer> unreadSubRes;
                Set subRes;
                if (parentFactory.isHideSubnodeTickets()) {
                    subRes = result;
                    unreadSubRes = unreadResult;
                } else {
                    subRes = subResult;
                    unreadSubRes = unreadSubResult;
                }
                grouping.appendSubViewStates(subState, subView, accountID, subRes, unreadSubRes, engine, slaveInfoEngine);
            }
            if (count <= 0 && subState.isEmpty()) continue;
            parentState.add(subState);
        }
    }

    @Nullable
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID, boolean hideSubnodeTickets) {
        return () -> this.getSearchCondition(subID);
    }

    @Override
    @Nullable
    public TicketViewSearchCommandFactory getSearchCommandFactory(final TicketViewSearchCommandFactory parentFactory, final @Nonnull String fullID, @Nonnull String subID) {
        boolean hideSubnodeTickets = parentFactory instanceof TicketViewFactory ? ((TicketViewFactory)parentFactory).isHideSubnodeTickets() : false;
        final Supplier<SearchExpression> condition = this.getConditionSupplier(subID, hideSubnodeTickets);
        if (condition == null) {
            return null;
        }
        return new TicketViewSearchCommandFactory(){

            @Override
            @Nonnull
            public String getID() {
                return fullID;
            }

            @Override
            public SearchCommand createSearchCommand(@Nonnull GUID accountID, @Nonnull Locale locale, @Nonnull IndexSearchEngine<Integer> engine) {
                SearchCommand command = parentFactory.createSearchCommand(accountID, locale, engine);
                if (command != null) {
                    AndSearchExpression expressions = command.getSearchExpression();
                    Iterator it = expressions.iterator();
                    while (it.hasNext()) {
                        SearchCondition cond;
                        SearchExpression expr = (SearchExpression)it.next();
                        if (expr.getType() != SearchExpression.Type.Condition || !SimpleSubViewGrouping.this.key.equals((cond = (SearchCondition)expr).getLeftOperand())) continue;
                        switch (cond.getOperator()) {
                            case StartsWith: {
                                it.remove();
                                break;
                            }
                        }
                    }
                    try (UserAccountScope scope = UserAccountScope.create((GUID)accountID);){
                        expressions.add((SearchExpression)condition.get());
                    }
                }
                return command;
            }
        };
    }
}

