/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import java.util.function.Function;

@InternalApi
public class ByIDSortGroupInformation
extends SortGroupInformation {
    private String ticketField;
    private Function<String, SortGroup> sortGroupFactory;

    public ByIDSortGroupInformation(String ticketField, Function<String, SortGroup> sortGroupFactory) {
        this.ticketField = ticketField;
        this.sortGroupFactory = sortGroupFactory;
    }

    @Override
    public boolean supportsSortGroups() {
        return true;
    }

    @Override
    public String getSortGroupKey(TicketVO ticket) {
        if (ticket == null) {
            return "";
        }
        Object ticketValue = ticket.getForKey(this.ticketField);
        if (ticketValue == null) {
            return "";
        }
        return ticketValue.toString();
    }

    @Override
    public SortGroup getSortGroupForKey(String sortGroupKey) {
        return this.sortGroupFactory.apply(sortGroupKey);
    }
}

