/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.lib.util.StringFunctions;

@InternalApi
public class ByFirstLetterSortGroupInformation
extends SortGroupInformation {
    private TicketFieldDefinition ticketFieldDefinition;

    public ByFirstLetterSortGroupInformation(TicketFieldDefinition ticketFieldDefinition) {
        this.ticketFieldDefinition = ticketFieldDefinition;
    }

    @Override
    public boolean supportsSortGroups() {
        return true;
    }

    @Override
    public String getSortGroupKey(TicketVO ticket) {
        if (ticket == null) {
            return "";
        }
        String displayValue = this.ticketFieldDefinition.getDisplayValue(ticket);
        if (displayValue == null) {
            displayValue = "";
        }
        if ((displayValue = displayValue.trim()).length() > 0) {
            return new String(Character.toChars(displayValue.codePointAt(0))).toUpperCase();
        }
        return displayValue;
    }

    @Override
    public SortGroup getSortGroupForKey(String sortGroupKey) {
        if (StringFunctions.isEmpty((String)sortGroupKey)) {
            sortGroupKey = Tickets.MSG.getMsg("value.unset", new Object[0]);
        }
        return new SortGroup(sortGroupKey.toUpperCase());
    }
}

