/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.argcontainers;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

@JsonData
public class ProcessingTime {
    private long start;
    private long end;

    private ProcessingTime() {
    }

    public static ProcessingTime of(Timestamp start, Timestamp end) {
        return ProcessingTime.of(start.getTime(), end.getTime());
    }

    public static ProcessingTime of(long time) {
        return ProcessingTime.of(time, time);
    }

    public static ProcessingTime of(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.startTimeAfterEndTime", new Object[0]));
        }
        ProcessingTime time = new ProcessingTime();
        time.start = start;
        time.end = end;
        return time;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public Timestamp getStartTimestamp() {
        return new Timestamp(this.start);
    }

    public Timestamp getEndTimestamp() {
        return new Timestamp(this.end);
    }

    public static ProcessingTime ofEffort(int effortInMin) {
        Timestamp ende;
        Timestamp start = ende = new Timestamp(System.currentTimeMillis());
        if (effortInMin > 0) {
            start = new Timestamp(ende.getTime() - TimeUnit.MINUTES.toMillis(effortInMin));
        }
        return ProcessingTime.of(start, ende);
    }

    public static ProcessingTime ofEffortWithEndTime(int effortInMin, long end) {
        if (effortInMin < 0) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.effortMustBePositive", new Object[0]));
        }
        if (end <= 0L) {
            end = System.currentTimeMillis();
        }
        long start = effortInMin == 0 ? end : end - (long)effortInMin * 60000L;
        return ProcessingTime.of(start, end);
    }

    public long getEffortInMin() {
        return (this.end - this.start) / 60L / 1000L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingTime other = (ProcessingTime)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }
}

