/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import java.util.HashSet;
import java.util.Set;

public class TicketVOSlaveForEnduser
extends TicketVO {
    private final TicketVOSingle ticket;
    private final TicketVOSingle master;

    private TicketVOSlaveForEnduser(TicketVOSingle ticket, TicketVOSingle master) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket must not be null");
        }
        if (master == null) {
            throw new IllegalArgumentException("master must not be null");
        }
        this.ticket = ticket;
        this.master = master;
    }

    public static TicketVOSlaveForEnduser create(TicketVOSingle ticket, TicketVOSingle master) {
        return new TicketVOSlaveForEnduser(ticket, master);
    }

    @Override
    public <VALUE> VALUE getAttribute(TicketAttribute<VALUE> attribute) {
        return attribute.getValueSourceForSlaveTicketForEnduser(this.master, this.ticket).getAttribute(attribute);
    }

    @Override
    public <VALUE> boolean hasAttributeKey(TicketAttribute<VALUE> attribute) {
        return attribute.getValueSourceForSlaveTicketForEnduser(this.master, this.ticket).hasAttributeKey(attribute);
    }

    @Override
    public Set<TicketAttribute<Object>> getIncludedAttributes() {
        HashSet<TicketAttribute<Object>> attributes = new HashSet<TicketAttribute<Object>>();
        attributes.addAll(this.master.getIncludedAttributes());
        attributes.addAll(this.ticket.getIncludedAttributes());
        attributes.removeIf(att -> !att.getValueSourceForSlaveTicketForEnduser(this.master, this.ticket).hasAttributeKey(att));
        return attributes;
    }

    @Override
    public <VALUE> VALUE getValue(TicketField<VALUE> field) {
        return field.getValueSourceForSlaveTicketForEnduser(this.master, this.ticket).getValue(field);
    }

    @Override
    public <VALUE> boolean hasFieldKey(TicketField<VALUE> field) {
        return field.getValueSourceForSlaveTicketForEnduser(this.master, this.ticket).hasFieldKey(field);
    }

    @Override
    public Set<TicketField<Object>> getIncludedFields() {
        HashSet<TicketField<Object>> fields = new HashSet<TicketField<Object>>();
        fields.addAll(this.master.getIncludedFields());
        fields.addAll(this.ticket.getIncludedFields());
        fields.removeIf(f -> !f.getValueSourceForSlaveTicketForEnduser(this.master, this.ticket).hasFieldKey(f));
        return fields;
    }

    @Override
    public int getID() {
        return this.ticket.getID();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.master == null ? 0 : this.master.hashCode());
        result = 31 * result + (this.ticket == null ? 0 : this.ticket.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketVOSlaveForEnduser other = (TicketVOSlaveForEnduser)obj;
        if (this.master == null ? other.master != null : !this.master.equals(other.master)) {
            return false;
        }
        return !(this.ticket == null ? other.ticket != null : !this.ticket.equals(other.ticket));
    }

    public String toString() {
        return "Slave ticket for enduser:" + this.ticket.getID() + "\n Slave=" + this.ticket.toString() + " \nmaster=" + this.master.toString();
    }
}

